/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.button;

import org.apache.wicket.Component;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.JQueryIcon;
import org.wicketstuff.jquery.ui.form.button.ButtonBehavior;
import org.wicketstuff.jquery.ui.form.button.IndicatingAjaxButton;

public class AjaxIndicatingButtonBehavior
extends ButtonBehavior {
    private static final long serialVersionUID = 1L;
    public static final String CSS_INDICATOR = "ui-icon-indicator";
    private final String icon;
    private final IndicatingAjaxButton.Position position;

    protected AjaxIndicatingButtonBehavior(String selector, String icon, IndicatingAjaxButton.Position position) {
        super(selector);
        this.icon = icon;
        this.position = position;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(AjaxIndicatingButtonBehavior.newIndicatorCssHeaderItem());
    }

    protected String $() {
        StringBuilder builder = new StringBuilder(super.$());
        builder.append("jQuery('").append(this.getSelector()).append("')").append(".click(function() { ");
        builder.append(this.$(this.newOnClickOptions()));
        builder.append("}); ");
        builder.append("jQuery(document).ajaxStart(function() { ");
        builder.append(this.$(this.newAjaxStartOptions()));
        builder.append(" }); ");
        builder.append("jQuery(document).ajaxStop(function() { ");
        builder.append(this.$(this.newOnAjaxStopOptions()));
        builder.append("}); ");
        return builder.toString();
    }

    public static HeaderItem newIndicatorCssHeaderItem() {
        String css = String.format(".ui-icon.%s { background-image: url(%s) !important; background-position: 0 0; }", CSS_INDICATOR, RequestCycleUtils.getAjaxIndicatorUrl());
        return CssHeaderItem.forCSS((CharSequence)css, (String)"jquery-ui-icon-indicator");
    }

    protected Options newOnClickOptions() {
        Options options = new Options();
        options.set("icon", (Object)Options.asString((String)CSS_INDICATOR));
        options.set("iconPosition", (Object)(this.position == IndicatingAjaxButton.Position.LEFT ? "'beginning'" : "'end'"));
        return options;
    }

    protected Options newAjaxStartOptions() {
        return new Options();
    }

    protected Options newOnAjaxStopOptions() {
        Options options = new Options();
        options.set("icon", (Object)(JQueryIcon.isNone(this.icon) ? Options.asString((String)"") : Options.asString((String)this.icon)));
        if (!JQueryIcon.isNone(this.icon)) {
            options.set("iconPosition", (Object)(this.position == IndicatingAjaxButton.Position.LEFT ? "'beginning'" : "'end'"));
        }
        return options;
    }
}

