/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class GetChannelDefinitionResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String channelDefinitionId;

    public GetChannelDefinitionResourceCmd(String channelDefinitionId) {
        if (channelDefinitionId == null || channelDefinitionId.length() < 1) {
            throw new FlowableIllegalArgumentException("The channel definition id is mandatory, but '" + channelDefinitionId + "' has been provided.");
        }
        this.channelDefinitionId = channelDefinitionId;
    }

    public InputStream execute(CommandContext commandContext) {
        ChannelDefinitionEntity channelDefinition = CommandContextUtil.getEventRegistryConfiguration().getDeploymentManager().findDeployedChannelDefinitionById(this.channelDefinitionId);
        String deploymentId = channelDefinition.getDeploymentId();
        String resourceName = channelDefinition.getResourceName();
        InputStream channelDefinitionStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return channelDefinitionStream;
    }
}

