/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.runtime.ProcessInstanceStartEventSubscriptionDeletionBuilder;

public class ProcessInstanceStartEventSubscriptionDeletionBuilderImpl
implements ProcessInstanceStartEventSubscriptionDeletionBuilder {
    protected final RuntimeServiceImpl runtimeService;
    protected String processDefinitionId;
    protected String tenantId;
    protected final Map<String, Object> correlationParameterValues = new HashMap<String, Object>();

    public ProcessInstanceStartEventSubscriptionDeletionBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionDeletionBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionDeletionBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionDeletionBuilder addCorrelationParameterValue(String parameterName, Object parameterValue) {
        this.correlationParameterValues.put(parameterName, parameterValue);
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionDeletionBuilder addCorrelationParameterValues(Map<String, Object> parameters) {
        this.correlationParameterValues.putAll(parameters);
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean hasCorrelationParameterValues() {
        return this.correlationParameterValues.size() > 0;
    }

    public Map<String, Object> getCorrelationParameterValues() {
        return this.correlationParameterValues;
    }

    @Override
    public void deleteSubscriptions() {
        this.checkValidInformation();
        this.runtimeService.deleteProcessInstanceStartEventSubscriptions(this);
    }

    protected void checkValidInformation() {
        if (StringUtils.isEmpty((CharSequence)this.processDefinitionId)) {
            throw new FlowableIllegalArgumentException("The process definition must be provided using the exact id of the version the subscription was registered for.");
        }
    }
}

