/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class HttpComponentsClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<HttpComponentsClientHttpRequestFactory> {
    private final Consumer<HttpClientBuilder> httpClientCustomizer;
    private final Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer;
    private final Consumer<SocketConfig.Builder> socketConfigCustomizer;
    private final Consumer<ConnectionConfig.Builder> connectionConfigCustomizer;
    private final Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer;
    private final Function<SslBundle, TlsSocketStrategy> tlsSocketStrategyFactory;

    HttpComponentsClientHttpRequestFactoryBuilder() {
        this(Collections.emptyList(), HttpComponentsClientHttpRequestFactoryBuilder.emptyCustomizer(), HttpComponentsClientHttpRequestFactoryBuilder.emptyCustomizer(), HttpComponentsClientHttpRequestFactoryBuilder.emptyCustomizer(), HttpComponentsClientHttpRequestFactoryBuilder.emptyCustomizer(), HttpComponentsClientHttpRequestFactoryBuilder.emptyCustomizer(), HttpComponentsClientHttpRequestFactoryBuilder::createTlsSocketStrategy);
    }

    private static TlsSocketStrategy createTlsSocketStrategy(SslBundle sslBundle) {
        SslOptions options = sslBundle.getOptions();
        return new DefaultClientTlsStrategy(sslBundle.createSslContext(), options.getEnabledProtocols(), options.getCiphers(), null, (HostnameVerifier)new DefaultHostnameVerifier());
    }

    private HttpComponentsClientHttpRequestFactoryBuilder(List<Consumer<HttpComponentsClientHttpRequestFactory>> customizers, Consumer<HttpClientBuilder> httpClientCustomizer, Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer, Consumer<SocketConfig.Builder> socketConfigCustomizer, Consumer<ConnectionConfig.Builder> connectionConfigCustomizer, Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer, Function<SslBundle, TlsSocketStrategy> tlsSocketStrategyFactory) {
        super(customizers);
        this.httpClientCustomizer = httpClientCustomizer;
        this.connectionManagerCustomizer = connectionManagerCustomizer;
        this.socketConfigCustomizer = socketConfigCustomizer;
        this.connectionConfigCustomizer = connectionConfigCustomizer;
        this.defaultRequestConfigCustomizer = defaultRequestConfigCustomizer;
        this.tlsSocketStrategyFactory = tlsSocketStrategyFactory;
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withCustomizer(Consumer<HttpComponentsClientHttpRequestFactory> customizer) {
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer), this.httpClientCustomizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<HttpComponentsClientHttpRequestFactory>> customizers) {
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientCustomizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClientBuilder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer.andThen(httpClientCustomizer), this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withConnectionManagerCustomizer(Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, (String)"'connectionManagerCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.connectionManagerCustomizer.andThen(connectionManagerCustomizer), this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withSocketConfigCustomizer(Consumer<SocketConfig.Builder> socketConfigCustomizer) {
        Assert.notNull(socketConfigCustomizer, (String)"'socketConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.connectionManagerCustomizer, this.socketConfigCustomizer.andThen(socketConfigCustomizer), this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withConnectionConfigCustomizer(Consumer<ConnectionConfig.Builder> connectionConfigCustomizer) {
        Assert.notNull(connectionConfigCustomizer, (String)"'connectionConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer.andThen(connectionConfigCustomizer), this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withTlsSocketStrategyFactory(Function<SslBundle, TlsSocketStrategy> tlsSocketStrategyFactory) {
        Assert.notNull(tlsSocketStrategyFactory, (String)"'tlsSocketStrategyFactory' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer, tlsSocketStrategyFactory);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, (String)"'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.connectionConfigCustomizer, this.defaultRequestConfigCustomizer.andThen(defaultRequestConfigCustomizer), this.tlsSocketStrategyFactory);
    }

    @Override
    protected HttpComponentsClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = this.createHttpClient(settings);
        return new HttpComponentsClientHttpRequestFactory(httpClient);
    }

    private HttpClient createHttpClient(ClientHttpRequestFactorySettings settings) {
        HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties().setRedirectStrategy(this.asRedirectStrategy(settings.redirects())).setConnectionManager((HttpClientConnectionManager)this.createConnectionManager(settings)).setDefaultRequestConfig(this.createDefaultRequestConfig());
        this.httpClientCustomizer.accept(builder);
        return builder.build();
    }

    private RedirectStrategy asRedirectStrategy(ClientHttpRequestFactorySettings.Redirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case ClientHttpRequestFactorySettings.Redirects.FOLLOW_WHEN_POSSIBLE, ClientHttpRequestFactorySettings.Redirects.FOLLOW -> DefaultRedirectStrategy.INSTANCE;
            case ClientHttpRequestFactorySettings.Redirects.DONT_FOLLOW -> NoFollowRedirectStrategy.INSTANCE;
        };
    }

    private PoolingHttpClientConnectionManager createConnectionManager(ClientHttpRequestFactorySettings settings) {
        PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        builder.setDefaultSocketConfig(this.createSocketConfig());
        builder.setDefaultConnectionConfig(this.createConnectionConfig(settings));
        map.from(settings::sslBundle).as(this.tlsSocketStrategyFactory).to(arg_0 -> ((PoolingHttpClientConnectionManagerBuilder)builder).setTlsSocketStrategy(arg_0));
        this.connectionManagerCustomizer.accept(builder);
        return builder.build();
    }

    private SocketConfig createSocketConfig() {
        SocketConfig.Builder builder = SocketConfig.custom();
        this.socketConfigCustomizer.accept(builder);
        return builder.build();
    }

    private ConnectionConfig createConnectionConfig(ClientHttpRequestFactorySettings settings) {
        ConnectionConfig.Builder builder = ConnectionConfig.custom();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).as(Duration::toMillis).to(timeout -> builder.setConnectTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(timeout -> builder.setSocketTimeout(timeout.intValue(), TimeUnit.MILLISECONDS));
        this.connectionConfigCustomizer.accept(builder);
        return builder.build();
    }

    private RequestConfig createDefaultRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        this.defaultRequestConfigCustomizer.accept(builder);
        return builder.build();
    }

    private static final class NoFollowRedirectStrategy
    implements RedirectStrategy {
        private static final RedirectStrategy INSTANCE = new NoFollowRedirectStrategy();

        private NoFollowRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            return false;
        }

        public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) {
            return null;
        }
    }

    static class Classes {
        static final String HTTP_CLIENTS = "org.apache.hc.client5.http.impl.classic.HttpClients";
        static final boolean PRESENT = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.classic.HttpClients", null);

        Classes() {
        }
    }
}

