/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthAccessTokenExpirationPolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.OAuth20DefaultAccessToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.HostNameBasedUniqueTicketIdGenerator;
import org.apereo.cas.util.function.FunctionUtils;

public class OAuth20DefaultAccessTokenFactory
implements OAuth20AccessTokenFactory {
    protected final UniqueTicketIdGenerator accessTokenIdGenerator;
    protected final TicketRegistry ticketRegistry;
    protected final ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicyBuilder;
    protected final JwtBuilder jwtBuilder;
    protected final ServicesManager servicesManager;
    protected final TicketTrackingPolicy descendantTicketsTrackingPolicy;

    public OAuth20DefaultAccessTokenFactory(TicketRegistry ticketRegistry, ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicyBuilder, JwtBuilder jwtBuilder, ServicesManager servicesManager, TicketTrackingPolicy descendantTicketsTrackingPolicy) {
        this((UniqueTicketIdGenerator)new HostNameBasedUniqueTicketIdGenerator(), ticketRegistry, expirationPolicyBuilder, jwtBuilder, servicesManager, descendantTicketsTrackingPolicy);
    }

    public OAuth20AccessToken create(Service service, Authentication authentication, Ticket ticketGrantingTicket, Collection<String> scopes, String exchangedToken, String clientId, Map<String, Map<String, Object>> requestClaims, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) throws Throwable {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.jwtBuilder.getServicesManager(), clientId);
        boolean limitReached = false;
        if (ticketGrantingTicket != null) {
            long maxNumberOfTokensAllowed = this.getMaxNumberOfAccessTokensAllowed(registeredService);
            if (maxNumberOfTokensAllowed > 0L) {
                limitReached = this.descendantTicketsTrackingPolicy.countTicketsFor(ticketGrantingTicket, service) >= maxNumberOfTokensAllowed || this.ticketRegistry.countTicketsFor(service) >= maxNumberOfTokensAllowed;
            }
            FunctionUtils.throwIf((boolean)limitReached, () -> new IllegalArgumentException("Access token limit for %s is reached".formatted(service.getId())));
        }
        ExpirationPolicy expirationPolicyToUse = this.determineExpirationPolicyForService(registeredService);
        String accessTokenId = this.generateAccessTokenId(service, authentication);
        OAuth20DefaultAccessToken accessToken = new OAuth20DefaultAccessToken(accessTokenId, service, authentication, expirationPolicyToUse, ticketGrantingTicket, exchangedToken, scopes, clientId, requestClaims, responseType, grantType);
        this.descendantTicketsTrackingPolicy.trackTicket(ticketGrantingTicket, (Ticket)accessToken);
        return accessToken;
    }

    private long getMaxNumberOfAccessTokensAllowed(OAuthRegisteredService registeredService) {
        return Optional.ofNullable(registeredService).map(OAuthRegisteredService::getAccessTokenExpirationPolicy).map(RegisteredServiceOAuthAccessTokenExpirationPolicy::getMaxActiveTokens).orElseGet(() -> this.jwtBuilder.getCasProperties().getAuthn().getOauth().getAccessToken().getMaxActiveTokensAllowed());
    }

    protected String generateAccessTokenId(Service service, Authentication authentication) throws Throwable {
        return this.accessTokenIdGenerator.getNewTicketId("AT");
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20AccessToken.class;
    }

    protected ExpirationPolicy determineExpirationPolicyForService(OAuthRegisteredService registeredService) {
        if (registeredService != null && registeredService.getAccessTokenExpirationPolicy() != null) {
            RegisteredServiceOAuthAccessTokenExpirationPolicy policy = registeredService.getAccessTokenExpirationPolicy();
            String maxTime = policy.getMaxTimeToLive();
            String ttl = policy.getTimeToKill();
            if (StringUtils.isNotBlank((CharSequence)maxTime) && StringUtils.isNotBlank((CharSequence)ttl)) {
                return new OAuth20AccessTokenExpirationPolicy(Beans.newDuration((String)maxTime).toSeconds(), Beans.newDuration((String)ttl).toSeconds());
            }
        }
        return this.expirationPolicyBuilder.buildTicketExpirationPolicy();
    }

    @Generated
    public OAuth20DefaultAccessTokenFactory(UniqueTicketIdGenerator accessTokenIdGenerator, TicketRegistry ticketRegistry, ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicyBuilder, JwtBuilder jwtBuilder, ServicesManager servicesManager, TicketTrackingPolicy descendantTicketsTrackingPolicy) {
        this.accessTokenIdGenerator = accessTokenIdGenerator;
        this.ticketRegistry = ticketRegistry;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.jwtBuilder = jwtBuilder;
        this.servicesManager = servicesManager;
        this.descendantTicketsTrackingPolicy = descendantTicketsTrackingPolicy;
    }

    @Generated
    public UniqueTicketIdGenerator getAccessTokenIdGenerator() {
        return this.accessTokenIdGenerator;
    }

    @Generated
    public TicketRegistry getTicketRegistry() {
        return this.ticketRegistry;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20AccessToken> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }

    @Generated
    public JwtBuilder getJwtBuilder() {
        return this.jwtBuilder;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public TicketTrackingPolicy getDescendantTicketsTrackingPolicy() {
        return this.descendantTicketsTrackingPolicy;
    }
}

