/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import jakarta.xml.bind.DatatypeConverter;
import java.util.Base64;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LDAPPasswordPullActions
implements InboundActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPPasswordPullActions.class);
    @Autowired
    protected UserDAO userDAO;

    public Set<String> moreAttrsToGet(ProvisioningProfile<?, ?> profile, Provision provision) {
        if (AnyTypeKind.USER.name().equals(provision.getAnyType())) {
            return Set.of(OperationalAttributes.PASSWORD_NAME);
        }
        return super.moreAttrsToGet(profile, provision);
    }

    protected Optional<Pair<String, CipherAlgorithm>> parseEncodedPassword(String password) {
        if (password != null && password.startsWith("{")) {
            String digest = Optional.ofNullable(password.substring(1, password.indexOf(125))).map(String::toUpperCase).orElse(null);
            int closingBracketIndex = password.indexOf(125);
            try {
                return Optional.of(Pair.of((Object)password.substring(closingBracketIndex + 1), (Object)CipherAlgorithm.valueOf((String)digest)));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)digest, (Object)e);
            }
        }
        return Optional.empty();
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, LiveSyncDelta delta, EntityTO entity, ProvisioningReport result) {
        if (entity instanceof UserTO) {
            this.userDAO.findById(entity.getKey()).ifPresent(user -> Optional.ofNullable(AttributeUtil.getPasswordValue((Set)delta.getObject().getAttributes())).flatMap(attr -> this.parseEncodedPassword(SecurityUtil.decrypt((GuardedString)attr))).ifPresent(encoded -> {
                String encodedHexStr = DatatypeConverter.printHexBinary((byte[])Base64.getDecoder().decode(((String)encoded.getLeft()).getBytes())).toUpperCase();
                user.setEncodedPassword(encodedHexStr, (CipherAlgorithm)encoded.getRight());
                this.userDAO.save((Entity)user);
            }));
        }
    }
}

