/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.io.Serializable;
import java.time.Duration;
import org.apache.wicket.page.CouldNotLockPageException;
import org.apache.wicket.page.DefaultPageLockManager;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageLockManager;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageAccessSynchronizer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PageAccessSynchronizer.class);
    private final IPageLockManager pageLockManager;

    public PageAccessSynchronizer(Duration timeout) {
        this(new DefaultPageLockManager(timeout));
    }

    public PageAccessSynchronizer(IPageLockManager pageLockManager) {
        this.pageLockManager = (IPageLockManager)Args.notNull((Object)pageLockManager, (String)"pageLockManager");
    }

    public void lockPage(int pageId) throws CouldNotLockPageException {
        this.pageLockManager.lockPage(pageId);
    }

    public void unlockAllPages() {
        this.pageLockManager.unlockAllPages();
    }

    public void unlockPage(int pageId) {
        this.pageLockManager.unlockPage(pageId);
    }

    public IPageManager adapt(final IPageManager manager) {
        return new IPageManager(){

            @Override
            public boolean supportsVersioning() {
                return manager.supportsVersioning();
            }

            @Override
            public IManageablePage getPage(int pageId) {
                IManageablePage page = null;
                try {
                    PageAccessSynchronizer.this.lockPage(pageId);
                    page = manager.getPage(pageId);
                }
                finally {
                    if (page == null) {
                        PageAccessSynchronizer.this.unlockPage(pageId);
                    }
                }
                return page;
            }

            @Override
            public void removePage(IManageablePage page) {
                if (page != null) {
                    try {
                        manager.removePage(page);
                    }
                    finally {
                        PageAccessSynchronizer.this.unlockPage(page.getPageId());
                    }
                }
            }

            @Override
            public void touchPage(IManageablePage page) {
                PageAccessSynchronizer.this.lockPage(page.getPageId());
                manager.touchPage(page);
            }

            @Override
            public void clear() {
                manager.clear();
            }

            @Override
            public void untouchPage(IManageablePage page) {
                manager.untouchPage(page);
            }

            @Override
            public void detach() {
                try {
                    manager.detach();
                }
                finally {
                    PageAccessSynchronizer.this.unlockAllPages();
                }
            }

            @Override
            public IPageStore getPageStore() {
                return manager.getPageStore();
            }

            @Override
            public void destroy() {
                manager.destroy();
            }
        };
    }

    public static class PageLock {
        private final int pageId;
        private final Thread thread;
        private volatile boolean released = false;

        public PageLock(int pageId, Thread thread) {
            this.pageId = pageId;
            this.thread = thread;
        }

        public int getPageId() {
            return this.pageId;
        }

        public Thread getThread() {
            return this.thread;
        }

        public final synchronized void waitForRelease(long remaining, boolean isDebugEnabled) {
            if (this.released) {
                if (isDebugEnabled) {
                    logger.debug("lock for page with id {} no longer locked by {}, falling through", (Object)this.pageId, (Object)this.thread.getName());
                }
                return;
            }
            if (isDebugEnabled) {
                logger.debug("{} waiting for lock to page {} for {}", new Object[]{this.thread.getName(), this.pageId, Duration.ofMillis(remaining)});
            }
            try {
                this.wait(remaining);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public final synchronized void markReleased(boolean isDebugEnabled) {
            if (isDebugEnabled) {
                logger.debug("'{}' notifying blocked threads", (Object)this.thread.getName());
            }
            this.released = true;
            this.notifyAll();
        }
    }
}

