/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.StepDouble;

class AtlasMaxGauge
extends AtlasMeter
implements Gauge {
    private final StepDouble value;
    private final Id stat;

    AtlasMaxGauge(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(Double.NaN, clock, step);
        this.stat = AtlasMeter.addIfMissing(id, (Tag)Statistic.max, DsType.gauge);
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        double v = this.value.poll(now);
        if (Double.isFinite(v)) {
            consumer.accept(this.stat, this.value.timestamp(), v);
        }
    }

    public void set(double v) {
        long now = this.clock.wallTime();
        this.value.max(now, v);
        this.updateLastModTime(now);
    }

    public double value() {
        return this.value.poll();
    }
}

