/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.OperationRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONIntermediateClientRequestControl;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONOperationPurposeRequestControl;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.util.Set;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class JSONRequestAccessLogMessage
extends JSONAccessLogMessage
implements OperationRequestAccessLogMessage {
    private static final long serialVersionUID = -8154114903633681042L;
    @Nullable
    private final Boolean usingAdminSessionWorkerThread;
    @Nullable
    private final Integer messageID;
    @Nullable
    private final JSONIntermediateClientRequestControl intermediateClientRequestControl;
    @Nullable
    private final JSONOperationPurposeRequestControl operationPurposeRequestControl;
    @Nullable
    private final Long operationID = this.getLongNoThrow(JSONFormattedAccessLogFields.OPERATION_ID);
    @Nullable
    private final Long triggeredByConnectionID;
    @Nullable
    private final Long triggeredByOperationID;
    @NotNull
    private final Set<String> requestControlOIDs;
    @Nullable
    private final String administrativeOperationMessage;
    @Nullable
    private final String origin;
    @Nullable
    private final String requesterDN;
    @Nullable
    private final String requesterIPAddress;

    protected JSONRequestAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.messageID = this.getIntegerNoThrow(JSONFormattedAccessLogFields.MESSAGE_ID);
        this.origin = this.getString(JSONFormattedAccessLogFields.ORIGIN);
        this.triggeredByConnectionID = this.getLongNoThrow(JSONFormattedAccessLogFields.TRIGGERED_BY_CONNECTION_ID);
        this.triggeredByOperationID = this.getLongNoThrow(JSONFormattedAccessLogFields.TRIGGERED_BY_OPERATION_ID);
        this.requesterDN = this.getString(JSONFormattedAccessLogFields.REQUESTER_DN);
        this.requesterIPAddress = this.getString(JSONFormattedAccessLogFields.REQUESTER_IP_ADDRESS);
        this.usingAdminSessionWorkerThread = this.getBooleanNoThrow(JSONFormattedAccessLogFields.USING_ADMIN_SESSION_WORKER_THREAD);
        this.administrativeOperationMessage = this.getString(JSONFormattedAccessLogFields.ADMINISTRATIVE_OPERATION);
        this.requestControlOIDs = this.getStringSet(JSONFormattedAccessLogFields.REQUEST_CONTROL_OIDS);
        JSONObject intermediateClientRequestObject = jsonObject.getFieldAsObject(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_REQUEST_CONTROL.getFieldName());
        this.intermediateClientRequestControl = intermediateClientRequestObject == null ? null : new JSONIntermediateClientRequestControl(intermediateClientRequestObject);
        JSONObject operationPurposeRequestObject = jsonObject.getFieldAsObject(JSONFormattedAccessLogFields.OPERATION_PURPOSE.getFieldName());
        this.operationPurposeRequestControl = operationPurposeRequestObject == null ? null : new JSONOperationPurposeRequestControl(operationPurposeRequestObject);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.REQUEST;
    }

    @Override
    @Nullable
    public final Long getOperationID() {
        return this.operationID;
    }

    @Override
    @Nullable
    public final Integer getMessageID() {
        return this.messageID;
    }

    @Override
    @Nullable
    public final String getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public final Long getTriggeredByConnectionID() {
        return this.triggeredByConnectionID;
    }

    @Override
    @Nullable
    public final Long getTriggeredByOperationID() {
        return this.triggeredByOperationID;
    }

    @Override
    @Nullable
    public final String getRequesterDN() {
        return this.requesterDN;
    }

    @Override
    @Nullable
    public final String getRequesterIPAddress() {
        return this.requesterIPAddress;
    }

    @Override
    @NotNull
    public final Set<String> getRequestControlOIDs() {
        return this.requestControlOIDs;
    }

    @Override
    @Nullable
    public final Boolean getUsingAdminSessionWorkerThread() {
        return this.usingAdminSessionWorkerThread;
    }

    @Override
    @Nullable
    public final String getAdministrativeOperationMessage() {
        return this.administrativeOperationMessage;
    }

    @Nullable
    public final JSONIntermediateClientRequestControl getIntermediateClientRequestControl() {
        return this.intermediateClientRequestControl;
    }

    @Nullable
    public final JSONOperationPurposeRequestControl getOperationPurposeRequestControl() {
        return this.operationPurposeRequestControl;
    }
}

