/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.ec;

import io.churchkey.shade.util.Hex;
import io.churchkey.util.Bytes;
import java.math.BigInteger;
import java.security.spec.ECPoint;

public class EcPoints {
    private EcPoints() {
    }

    public static ECPoint fromBytes(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalStateException("Key data is truncated");
        }
        if (bytes[0] != 4) {
            byte[] format = new byte[]{bytes[0]};
            throw new UnsupportedOperationException("Only uncompressed EC points are supported.  Found EC point compression format of " + Hex.toString(format) + " (hex)");
        }
        int length = bytes.length - 1;
        int elements = length / 2;
        if (length != elements * 2) {
            throw new IllegalArgumentException(String.format("Invalid EC point data: expected %s bytes, found %s bytes", 2 * elements, length));
        }
        byte[] xp = new byte[elements];
        byte[] yp = new byte[elements];
        System.arraycopy(bytes, 1, xp, 0, elements);
        System.arraycopy(bytes, 1 + elements, yp, 0, elements);
        BigInteger x = new BigInteger(1, xp);
        BigInteger y = new BigInteger(1, yp);
        return new ECPoint(x, y);
    }

    public static byte[] toBytes(ECPoint point) {
        byte[] xp = Bytes.trim(point.getAffineX().toByteArray());
        byte[] yp = Bytes.trim(point.getAffineY().toByteArray());
        int max = Math.max(xp.length, yp.length);
        xp = EcPoints.pad(xp, max);
        yp = EcPoints.pad(yp, max);
        byte[] bytes = new byte[1 + max * 2];
        bytes[0] = 4;
        System.arraycopy(xp, 0, bytes, 1, xp.length);
        System.arraycopy(yp, 0, bytes, 1 + xp.length, yp.length);
        return bytes;
    }

    private static byte[] pad(byte[] bytes, int max) {
        if (bytes.length == max) {
            return bytes;
        }
        byte[] padded = new byte[max];
        int offset = max - bytes.length;
        System.arraycopy(bytes, 0, padded, offset, bytes.length);
        return padded;
    }
}

