/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;
import java.util.Collections;
import java.util.Iterator;

public class BlockStatement
extends Statement
implements Iterable<Statement> {
    public static final Role<Statement> STATEMENT_ROLE = new Role<Statement>("Statement", Statement.class, Statement.NULL);
    public static final BlockStatement NULL = new NullBlockStatement();

    public BlockStatement() {
        super(-34);
    }

    public BlockStatement(Iterable<Statement> statements) {
        super(-34);
        if (statements != null) {
            for (Statement statement : statements) {
                this.getStatements().add(statement);
            }
        }
    }

    public BlockStatement(Statement ... statements) {
        super(-34);
        Collections.addAll(this.getStatements(), statements);
    }

    public final JavaTokenNode getLeftBraceToken() {
        return this.getChildByRole(Roles.LEFT_BRACE);
    }

    public final AstNodeCollection<Statement> getStatements() {
        return this.getChildrenByRole(STATEMENT_ROLE);
    }

    public final JavaTokenNode getRightBraceToken() {
        return this.getChildByRole(Roles.RIGHT_BRACE);
    }

    public final void add(Statement statement) {
        this.addChild(statement, STATEMENT_ROLE);
    }

    public final void add(Expression expression) {
        this.addChild(new ExpressionStatement(expression), STATEMENT_ROLE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitBlockStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof BlockStatement && !other.isNull() && this.getStatements().matches(((BlockStatement)other).getStatements(), match);
    }

    @Override
    public final Iterator<Statement> iterator() {
        return this.getStatements().iterator();
    }

    public static BlockStatement forPattern(Pattern pattern) {
        return new PatternPlaceholder((Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    private static final class PatternPlaceholder
    extends BlockStatement {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }

    private static final class NullBlockStatement
    extends BlockStatement {
        private NullBlockStatement() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

