/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;

public class MarkReferencedSyntheticsTransform
extends ContextTrackingVisitor<Void> {
    public MarkReferencedSyntheticsTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void data) {
        super.visitMemberReferenceExpression(node, data);
        if (this.isCurrentMemberVisible()) {
            MemberReference resolvedMember;
            MemberReference member = node.getUserData(Keys.MEMBER_REFERENCE);
            if (member == null && node.getParent() != null) {
                member = node.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (member != null && (resolvedMember = member instanceof FieldReference ? ((FieldReference)member).resolve() : ((MethodReference)member).resolve()) != null && resolvedMember.isSynthetic() && !Flags.testAny(resolvedMember.getFlags(), 0x80000000L)) {
                this.context.getForcedVisibleMembers().add((IMemberDefinition)((Object)resolvedMember));
            }
        }
        return null;
    }

    private boolean isCurrentMemberVisible() {
        MethodDefinition currentMethod = this.context.getCurrentMethod();
        if (currentMethod != null && AstBuilder.isMemberHidden(currentMethod, this.context)) {
            return false;
        }
        TypeDefinition currentType = this.context.getCurrentType();
        return currentType == null || !AstBuilder.isMemberHidden(currentType, this.context);
    }
}

