/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.componentmodel;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.componentmodel.FrugalKeyMap;
import com.strobel.componentmodel.Key;
import com.strobel.componentmodel.UserDataStore;
import com.strobel.core.ExceptionUtilities;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class UserDataStoreBase
implements UserDataStore,
Cloneable {
    public static final Key<FrugalKeyMap> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    private static final AtomicReferenceFieldUpdater<UserDataStoreBase, FrugalKeyMap> UPDATER = AtomicReferenceFieldUpdater.newUpdater(UserDataStoreBase.class, FrugalKeyMap.class, "_map");
    @NotNull
    private volatile FrugalKeyMap _map = FrugalKeyMap.EMPTY;

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        return this._map.get(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        FrugalKeyMap oldMap;
        FrugalKeyMap newMap;
        while ((newMap = value == null ? oldMap.minus(key) : oldMap.plus(key, value)) != (oldMap = this._map) && !UPDATER.compareAndSet(this, oldMap, newMap)) {
        }
    }

    @Override
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @Nullable T value) {
        FrugalKeyMap oldMap;
        FrugalKeyMap newMap;
        do {
            oldMap = this._map;
            T oldValue = this._map.get(key);
            if (oldValue == null) continue;
            return oldValue;
        } while ((newMap = value == null ? oldMap.minus(key) : oldMap.plus(key, value)) != oldMap && !UPDATER.compareAndSet(this, oldMap, newMap));
        return value;
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        FrugalKeyMap oldMap;
        FrugalKeyMap newMap;
        do {
            oldMap = this._map;
            T currentValue = this._map.get(key);
            if (currentValue == oldValue) continue;
            return false;
        } while ((newMap = newValue == null ? oldMap.minus(key) : oldMap.plus(key, newValue)) != oldMap && !UPDATER.compareAndSet(this, oldMap, newMap));
        return true;
    }

    public final UserDataStoreBase clone() {
        try {
            return (UserDataStoreBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw ExceptionUtilities.asRuntimeException(e);
        }
    }
}

