/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.pagestore.browser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.util.lang.Objects;

class PersistedPagesProvider
extends SortableDataProvider<IPersistedPage, String> {
    private final IModel<String> sessionId;
    private final IModel<IPersistentPageStore> store;
    private List<IPersistedPage> pages;

    PersistedPagesProvider(IModel<String> sessionId, IModel<IPersistentPageStore> store) {
        this.sessionId = sessionId;
        this.store = store;
    }

    public Iterator<? extends IPersistedPage> iterator(long first, long count) {
        List<IPersistedPage> pages = this.getPages();
        if (this.getSort() != null) {
            Collections.sort(pages, new SortComparator());
        }
        return pages.subList((int)first, (int)(first + count)).iterator();
    }

    private List<IPersistedPage> getPages() {
        if (this.pages == null) {
            this.pages = new ArrayList<IPersistedPage>();
            if (this.sessionId.getObject() != null) {
                String sessId = (String)this.sessionId.getObject();
                IPersistentPageStore persistentPagesStore = (IPersistentPageStore)this.store.getObject();
                if (persistentPagesStore != null) {
                    this.pages.addAll(persistentPagesStore.getPersistedPages(sessId));
                }
            }
        }
        return this.pages;
    }

    public long size() {
        return this.getPages().size();
    }

    public IModel<IPersistedPage> model(IPersistedPage description) {
        return new Model((Serializable)description);
    }

    public void detach() {
        this.sessionId.detach();
        this.store.detach();
        this.pages = null;
    }

    private class SortComparator
    implements Comparator<IPersistedPage> {
        private SortComparator() {
        }

        @Override
        public int compare(IPersistedPage page0, IPersistedPage page1) {
            Object value0 = PropertyResolver.getValue((String)((String)PersistedPagesProvider.this.getSort().getProperty()), (Object)page0);
            Object value1 = PropertyResolver.getValue((String)((String)PersistedPagesProvider.this.getSort().getProperty()), (Object)page1);
            int c = Objects.compareWithConversion((Object)value0, (Object)value1);
            if (!PersistedPagesProvider.this.getSort().isAscending()) {
                c *= -1;
            }
            return c;
        }
    }
}

