/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.repeater;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.repeater.RepeatingView;

public class AjaxListPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private WebMarkupContainer container = new WebMarkupContainer("container");
    private RepeatingView repeater;

    public AjaxListPanel(String id) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.repeater = new RepeatingView("repeater");
        this.container.add(new Component[]{this.repeater});
    }

    public String newChildId() {
        return this.repeater.newChildId();
    }

    public <T extends Component> T append(T component, AjaxRequestTarget target) {
        this.repeater.add(new Component[]{component});
        if (target != null) {
            IMarkupFragment markup = this.repeater.getMarkup();
            MarkupStream stream = new MarkupStream(markup);
            ComponentTag tag = stream.getTag().mutable();
            tag.getXmlTag().setType(XmlTag.TagType.OPEN_CLOSE);
            tag.getXmlTag().put("id", (CharSequence)component.getMarkupId());
            target.prependJavaScript((CharSequence)String.format("Wicket.DOM.add(Wicket.DOM.get('%s'), '%s');", this.container.getMarkupId(), JavaScriptUtils.escapeQuotes((CharSequence)tag.toString())));
            target.add(new Component[]{component});
        }
        return component;
    }

    public <T extends Component> T delete(T component, AjaxRequestTarget target) {
        this.repeater.remove(component);
        if (target != null) {
            target.appendJavaScript((CharSequence)String.format("Wicket.DOM.remove(Wicket.DOM.get('%s'));", component.getMarkupId()));
        }
        return component;
    }
}

