/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.BufferHelper;

public class ResourceLimitSettings
implements Serializable,
EncodingSupport {
    private static final long serialVersionUID = -110638321333856932L;
    public static final SimpleString DEFAULT_MATCH = null;
    public static final Integer DEFAULT_MAX_SESSIONS = -1;
    public static final Integer DEFAULT_MAX_QUEUES = -1;
    SimpleString match = null;
    Integer maxSessions = null;
    Integer maxQueues = null;

    public void setName(String name) {
        this.setMatch(SimpleString.of((String)name));
    }

    public SimpleString getMatch() {
        return this.match != null ? this.match : DEFAULT_MATCH;
    }

    @Deprecated(forRemoval=true)
    public int getMaxConnections() {
        return this.getMaxSessions();
    }

    public int getMaxSessions() {
        return Objects.requireNonNullElse(this.maxSessions, DEFAULT_MAX_SESSIONS);
    }

    public int getMaxQueues() {
        return Objects.requireNonNullElse(this.maxQueues, DEFAULT_MAX_QUEUES);
    }

    public void setMatch(SimpleString match) {
        this.match = match;
    }

    @Deprecated(forRemoval=true)
    public void setMaxConnections(int maxConnections) {
        this.setMaxSessions(maxConnections);
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public void setMaxQueues(int maxQueues) {
        this.maxQueues = maxQueues;
    }

    public int getEncodeSize() {
        return SimpleString.sizeofNullableString((SimpleString)this.match) + BufferHelper.sizeOfNullableInteger((Integer)this.maxSessions) + BufferHelper.sizeOfNullableInteger((Integer)this.maxQueues);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableSimpleString(this.match);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxSessions);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxQueues);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.match = buffer.readNullableSimpleString();
        this.maxSessions = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.maxQueues = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
    }

    public int hashCode() {
        return Objects.hash(this.match, this.maxSessions, this.maxQueues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceLimitSettings)) {
            return false;
        }
        ResourceLimitSettings other = (ResourceLimitSettings)obj;
        return Objects.equals(this.match, other.match) && Objects.equals(this.maxSessions, other.maxSessions) && Objects.equals(this.maxQueues, other.maxQueues);
    }

    public String toString() {
        return "ResourceLimitSettings [match=" + String.valueOf(this.match) + ", maxSessions=" + this.maxSessions + ", maxQueues=" + this.maxQueues + "]";
    }
}

