/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.braintree.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.braintreegateway.SubscriptionGateway;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for com.braintreegateway.SubscriptionGateway
 */
public enum SubscriptionGatewayApiMethod implements ApiMethod {

    CANCEL(
        com.braintreegateway.Result.class,
        "cancel",
        arg("id", String.class)),

    CREATE(
        com.braintreegateway.Result.class,
        "create",
        arg("request", com.braintreegateway.SubscriptionRequest.class)),

    DELETE(
        com.braintreegateway.Result.class,
        "delete",
        arg("customerId", String.class),
        arg("id", String.class)),

    FIND(
        com.braintreegateway.Subscription.class,
        "find",
        arg("id", String.class)),

    RETRY_CHARGE(
        com.braintreegateway.Result.class,
        "retryCharge",
        arg("subscriptionId", String.class)),

    RETRY_CHARGE_1(
        com.braintreegateway.Result.class,
        "retryCharge",
        arg("subscriptionId", String.class),
        arg("amount", java.math.BigDecimal.class)),

    RETRY_CHARGE_2(
        com.braintreegateway.Result.class,
        "retryCharge",
        arg("subscriptionId", String.class),
        arg("submitForSettlement", Boolean.class)),

    RETRY_CHARGE_3(
        com.braintreegateway.Result.class,
        "retryCharge",
        arg("subscriptionId", String.class),
        arg("amount", java.math.BigDecimal.class),
        arg("submitForSettlement", Boolean.class)),

    SEARCH(
        com.braintreegateway.ResourceCollection.class,
        "search",
        arg("searchRequest", com.braintreegateway.SubscriptionSearchRequest.class)),

    UPDATE(
        com.braintreegateway.Result.class,
        "update",
        arg("id", String.class),
        arg("request", com.braintreegateway.SubscriptionRequest.class));

    private final ApiMethod apiMethod;

    private SubscriptionGatewayApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(SubscriptionGateway.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
