/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.tahu.TahuEdgeComponent;

/**
 * Sparkplug B Edge Node and Device support over MQTT using Eclipse Tahu
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface TahuEdgeComponentBuilderFactory {

    /**
     * Tahu Edge Node / Device (camel-tahu)
     * Sparkplug B Edge Node and Device support over MQTT using Eclipse Tahu
     * 
     * Category: messaging,iot,monitoring
     * Since: 4.8
     * Maven coordinates: org.apache.camel:camel-tahu
     * 
     * @return the dsl builder
     */
    static TahuEdgeComponentBuilder tahuEdge() {
        return new TahuEdgeComponentBuilderImpl();
    }

    /**
     * Builder for the Tahu Edge Node / Device component.
     */
    interface TahuEdgeComponentBuilder extends ComponentBuilder<TahuEdgeComponent> {
    
        
        /**
         * MQTT client ID length check enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param checkClientIdLength the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder checkClientIdLength(boolean checkClientIdLength) {
            doSetProperty("checkClientIdLength", checkClientIdLength);
            return this;
        }
    
        /**
         * MQTT client ID to use for all server definitions, rather than
         * specifying the same one for each. Note that if neither the 'clientId'
         * parameter nor an 'MqttClientId' are defined for an MQTT Server, a
         * random MQTT Client ID will be generated automatically, prefaced with
         * 'Camel'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder clientId(java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
    
        
        /**
         * MQTT connection keep alive timeout, in seconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30
         * Group: common
         * 
         * @param keepAliveTimeout the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder keepAliveTimeout(int keepAliveTimeout) {
            doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }
    
        
        /**
         * Delay before recurring node rebirth messages will be sent.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param rebirthDebounceDelay the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder rebirthDebounceDelay(long rebirthDebounceDelay) {
            doSetProperty("rebirthDebounceDelay", rebirthDebounceDelay);
            return this;
        }
    
        /**
         * MQTT server definitions, given with the following syntax in a
         * comma-separated list:
         * MqttServerName:(MqttClientId:)(tcp/ssl)://hostname(:port),...
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param servers the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder servers(java.lang.String servers) {
            doSetProperty("servers", servers);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * To use a shared Tahu configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.tahu.TahuConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder configuration(org.apache.camel.component.tahu.TahuConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * Password for MQTT server authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
    
        /**
         * SSL configuration for MQTT server connections.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder sslContextParameters(org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    
        
        /**
         * Enable/disable global SSL context parameters use.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useGlobalSslContextParameters the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    
        /**
         * Username for MQTT server authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default TahuEdgeComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    class TahuEdgeComponentBuilderImpl
            extends AbstractComponentBuilder<TahuEdgeComponent>
            implements TahuEdgeComponentBuilder {
        @Override
        protected TahuEdgeComponent buildConcreteComponent() {
            return new TahuEdgeComponent();
        }
        private org.apache.camel.component.tahu.TahuConfiguration getOrCreateConfiguration(TahuEdgeComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.tahu.TahuConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "checkClientIdLength": getOrCreateConfiguration((TahuEdgeComponent) component).setCheckClientIdLength((boolean) value); return true;
            case "clientId": getOrCreateConfiguration((TahuEdgeComponent) component).setClientId((java.lang.String) value); return true;
            case "keepAliveTimeout": getOrCreateConfiguration((TahuEdgeComponent) component).setKeepAliveTimeout((int) value); return true;
            case "rebirthDebounceDelay": getOrCreateConfiguration((TahuEdgeComponent) component).setRebirthDebounceDelay((long) value); return true;
            case "servers": getOrCreateConfiguration((TahuEdgeComponent) component).setServers((java.lang.String) value); return true;
            case "lazyStartProducer": ((TahuEdgeComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((TahuEdgeComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "configuration": ((TahuEdgeComponent) component).setConfiguration((org.apache.camel.component.tahu.TahuConfiguration) value); return true;
            case "password": getOrCreateConfiguration((TahuEdgeComponent) component).setPassword((java.lang.String) value); return true;
            case "sslContextParameters": getOrCreateConfiguration((TahuEdgeComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((TahuEdgeComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            case "username": getOrCreateConfiguration((TahuEdgeComponent) component).setUsername((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}