/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.language.Nysiis;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NysiisTest
extends AbstractStringEncoderTest<Nysiis> {
    private final Nysiis fullNysiis = new Nysiis(false);

    NysiisTest() {
    }

    private void assertEncodings(String[] ... testValues) {
        for (String[] arr : testValues) {
            Assertions.assertEquals((Object)arr[1], (Object)this.fullNysiis.encode(arr[0]), (String)("Problem with " + arr[0]));
        }
    }

    @Override
    protected Nysiis createStringEncoder() {
        return new Nysiis();
    }

    private void encodeAll(String[] strings, String expectedEncoding) {
        for (String string : strings) {
            Assertions.assertEquals((Object)expectedEncoding, (Object)((Nysiis)this.getStringEncoder()).encode(string), (String)("Problem with " + string));
        }
    }

    @Test
    void testBran() {
        this.encodeAll(new String[]{"Brian", "Brown", "Brun"}, "BRAN");
    }

    @Test
    void testCap() {
        this.encodeAll(new String[]{"Capp", "Cope", "Copp", "Kipp"}, "CAP");
    }

    @Test
    void testDad() {
        this.encodeAll(new String[]{"Dent"}, "DAD");
    }

    @Test
    void testDan() {
        this.encodeAll(new String[]{"Dane", "Dean", "Dionne"}, "DAN");
    }

    @Test
    void testDropBy() {
        this.assertEncodings({"MACINTOSH", "MCANT"}, {"KNUTH", "NAT"}, {"KOEHN", "CAN"}, {"PHILLIPSON", "FALAPSAN"}, {"PFEISTER", "FASTAR"}, {"SCHOENHOEFT", "SANAFT"}, {"MCKEE", "MCY"}, {"MACKIE", "MCY"}, {"HEITSCHMIDT", "HATSNAD"}, {"BART", "BAD"}, {"HURD", "HAD"}, {"HUNT", "HAD"}, {"WESTERLUND", "WASTARLAD"}, {"CASSTEVENS", "CASTAFAN"}, {"VASQUEZ", "VASG"}, {"FRAZIER", "FRASAR"}, {"BOWMAN", "BANAN"}, {"MCKNIGHT", "MCNAGT"}, {"RICKERT", "RACAD"}, {"DEUTSCH", "DAT"}, {"WESTPHAL", "WASTFAL"}, {"SHRIVER", "SRAVAR"}, {"KUHL", "CAL"}, {"RAWSON", "RASAN"}, {"JILES", "JAL"}, {"CARRAWAY", "CARY"}, {"YAMADA", "YANAD"});
    }

    @Test
    void testFal() {
        this.encodeAll(new String[]{"Phil"}, "FAL");
    }

    @Test
    void testOthers() {
        this.assertEncodings({"O'Daniel", "ODANAL"}, {"O'Donnel", "ODANAL"}, {"Cory", "CARY"}, {"Corey", "CARY"}, {"Kory", "CARY"}, {"FUZZY", "FASY"});
    }

    @Test
    void testRule1() {
        this.assertEncodings({"MACX", "MCX"}, {"KNX", "NX"}, {"KX", "CX"}, {"PHX", "FX"}, {"PFX", "FX"}, {"SCHX", "SX"});
    }

    @Test
    void testRule2() {
        this.assertEncodings({"XEE", "XY"}, {"XIE", "XY"}, {"XDT", "XD"}, {"XRT", "XD"}, {"XRD", "XD"}, {"XNT", "XD"}, {"XND", "XD"});
    }

    @Test
    void testRule4Dot1() {
        this.assertEncodings({"XEV", "XAF"}, {"XAX", "XAX"}, {"XEX", "XAX"}, {"XIX", "XAX"}, {"XOX", "XAX"}, {"XUX", "XAX"});
    }

    @Test
    void testRule4Dot2() {
        this.assertEncodings({"XQ", "XG"}, {"XZ", "X"}, {"XM", "XN"});
    }

    @Test
    void testRule5() {
        this.assertEncodings({"XS", "X"}, {"XSS", "X"});
    }

    @Test
    void testRule6() {
        this.assertEncodings({"XAY", "XY"}, {"XAYS", "XY"});
    }

    @Test
    void testRule7() {
        this.assertEncodings({"XA", "X"}, {"XAS", "X"});
    }

    @Test
    void testSnad() {
        this.encodeAll(new String[]{"Schmidt"}, "SNAD");
    }

    @Test
    void testSnat() {
        this.encodeAll(new String[]{"Smith", "Schmit"}, "SNAT");
    }

    @Test
    void testSpecialBranches() {
        this.encodeAll(new String[]{"Kobwick"}, "CABWAC");
        this.encodeAll(new String[]{"Kocher"}, "CACAR");
        this.encodeAll(new String[]{"Fesca"}, "FASC");
        this.encodeAll(new String[]{"Shom"}, "SAN");
        this.encodeAll(new String[]{"Ohlo"}, "OL");
        this.encodeAll(new String[]{"Uhu"}, "UH");
        this.encodeAll(new String[]{"Um"}, "UN");
    }

    @Test
    void testTranan() {
        this.encodeAll(new String[]{"Trueman", "Truman"}, "TRANAN");
    }

    @Test
    void testTrueVariant() {
        Nysiis encoder = new Nysiis(true);
        String encoded = encoder.encode("WESTERLUND");
        Assertions.assertTrue((encoded.length() <= 6 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"WASTAR", (Object)encoded);
    }
}

