/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public class ArrayInstr
extends Instruction {
    private final Operand selectOp;

    public ArrayInstr(Expression select) {
        this.selectOp = new Operand(this, select, OperandRole.ABSORB);
    }

    public Expression getSelectExp() {
        return this.selectOp.getChildExpression();
    }

    public void setSelectExp(Expression nameExp) {
        this.selectOp.setChildExpression(nameExp);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.selectOp);
    }

    @Override
    public int getInstructionNameCode() {
        return 134;
    }

    @Override
    public ItemType getItemType() {
        return ArrayItemType.ANY_ARRAY_TYPE;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ArrayInstr exp = new ArrayInstr(this.getSelectExp().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getDependencies() {
        return this.getSelectExp().getDependencies() | super.getDependencies();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("xslArray", this);
        this.getSelectExp().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new ArrayInstrElaborator();
    }

    private static class ArrayInstrElaborator
    extends ItemElaborator {
        public static final StringValue valueField = new StringValue(new Twine8("value"));

        private ArrayInstrElaborator() {
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            ArrayInstr expr = (ArrayInstr)this.getExpression();
            Location loc = expr.getLocation();
            PullEvaluator select = expr.getSelectExp().makeElaborator().elaborateForPull();
            return context -> {
                SequenceIterator input = select.iterate(context);
                Item first = input.next();
                if (first == null) {
                    return SimpleArrayItem.EMPTY_ARRAY;
                }
                switch (first.getGenre()) {
                    case ATOMIC: {
                        Item item;
                        ArrayList<GroundedValue> members = new ArrayList<GroundedValue>();
                        members.add(first);
                        while ((item = input.next()) != null) {
                            if (item.getGenre() == Genre.ATOMIC) {
                                members.add(item);
                                continue;
                            }
                            throw new XPathException("xsl:array: if the first item is atomic, then all must be atomic").withErrorCode("XTTE4045").withLocation(loc).asTypeError();
                        }
                        return new SimpleArrayItem(members);
                    }
                    case NODE: {
                        Item item;
                        ArrayList<GroundedValue> members = new ArrayList<GroundedValue>();
                        members.add(first);
                        while ((item = input.next()) != null) {
                            if (item.getGenre() == Genre.NODE) {
                                members.add(item);
                                continue;
                            }
                            throw new XPathException("xsl:array: if the first item is a node, then all must be nodes").withErrorCode("XTTE4045").withLocation(loc).asTypeError();
                        }
                        return new SimpleArrayItem(members);
                    }
                    case MAP: {
                        Item item;
                        ArrayList<GroundedValue> members = new ArrayList<GroundedValue>();
                        GroundedValue firstMember = this.memberFromValueRecord(first);
                        members.add(firstMember);
                        while ((item = input.next()) != null) {
                            members.add(this.memberFromValueRecord(item));
                        }
                        return new SimpleArrayItem(members);
                    }
                }
                throw new XPathException("Invalid item in result of xsl:array/@select: " + Err.depict(first)).withErrorCode("XTTE4045").withLocation(loc).asTypeError();
            };
        }

        private GroundedValue memberFromValueRecord(Item valueRecord) throws XPathException {
            GroundedValue val;
            if (valueRecord instanceof MapItem && (val = ((MapItem)valueRecord).get(valueField)) != null) {
                return val;
            }
            throw new XPathException("In input to xsl:array, expected a value record. Found " + Err.depict(valueRecord));
        }
    }
}

