/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class NextIteration
extends Instruction
implements TailCallLoop.TailCallInfo {
    private WithParam[] actualParams = null;

    public void setParameters(WithParam[] actualParams) {
        this.actualParams = actualParams;
    }

    public WithParam[] getParameters() {
        return this.actualParams;
    }

    @Override
    public boolean isLiftable(boolean forStreaming) {
        return false;
    }

    @Override
    public int getInstructionNameCode() {
        return 182;
    }

    @Override
    public Expression simplify() throws XPathException {
        WithParam.simplify(this.actualParams);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextInfo);
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        NextIteration c2 = new NextIteration();
        ExpressionTool.copyLocationInfo(this, c2);
        c2.actualParams = WithParam.copy(c2, this.actualParams, rebindings);
        return c2;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>();
        WithParam.gatherOperands(this, this.actualParams, list);
        return list;
    }

    @Override
    public String getStreamerName() {
        return "NextIteration";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("nextIteration", this);
        if (this.actualParams != null && this.actualParams.length > 0) {
            WithParam.exportParameters(this.actualParams, out, false);
        }
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new NextIterationElaborator();
    }

    public static class NextIterationElaborator
    extends PushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            NextIteration expr = (NextIteration)this.getExpression();
            return (output, context) -> {
                XPathContextMajor cm = context.getMajorContext();
                if (expr.actualParams.length == 1) {
                    cm.setLocalVariable(expr.actualParams[0].getSlotNumber(), expr.actualParams[0].getSelectValue(context));
                } else {
                    Sequence[] oldVars = cm.getAllVariableValues();
                    Sequence[] newVars = Arrays.copyOf(oldVars, oldVars.length);
                    for (WithParam wp : expr.actualParams) {
                        newVars[wp.getSlotNumber()] = wp.getSelectValue(context);
                    }
                    cm.resetAllVariableValues(newVars);
                }
                cm.requestTailCall(expr, null);
                return null;
            };
        }
    }
}

