/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.functions.CurrentGroupingKeyCall;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class CurrentGroupingKey
extends ContextAccessorFunction {
    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        return new CurrentGroupingKeyCall();
    }

    @Override
    public FunctionItem bindContext(XPathContext context) throws XPathException {
        if (this.getRetainedStaticContext().getPackageData().getHostLanguageVersion() < 40) {
            throw new XPathException("Dynamic call on current-grouping-key() fails (the current group is absent)", "XTDE1071");
        }
        GroupIterator gi = context.getCurrentGroupIterator();
        if (gi == null) {
            throw new XPathException("There is no current grouping key", "XTDE1071");
        }
        AtomicSequence groupingKey = gi.getCurrentGroupingKey();
        ConstantFunction fn = new ConstantFunction(groupingKey);
        fn.setDetails(this.getDetails());
        fn.setRetainedStaticContext(this.getRetainedStaticContext());
        return fn;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        throw new XPathException("Dynamic call on current-grouping-key() fails (the current group is absent)", "XTDE1071");
    }
}

