/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class NamespaceUriFn_1
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item item, XPathContext context) throws XPathException {
        NamespaceUri uri = ((NodeInfo)item).getNamespaceUri();
        return new AnyURIValue(uri.toUnicodeString());
    }

    @Override
    public AnyURIValue resultWhenEmpty() {
        return new AnyURIValue("");
    }

    @Override
    public Elaborator getElaborator() {
        return new NamespaceUriFnElaborator();
    }

    public static class NamespaceUriFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            boolean nullable = Cardinality.allowsZero(arg.getCardinality());
            ItemEvaluator argEval = arg.makeElaborator().elaborateForItem();
            return context -> {
                NodeInfo node = (NodeInfo)argEval.eval(context);
                NamespaceUri uri = nullable && node == null ? NamespaceUri.NULL : node.getNamespaceUri();
                return new AnyURIValue(uri.toUnicodeString());
            };
        }
    }
}

