/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class EntityResolverWrappingResourceResolver
implements EntityResolver2 {
    private final ResourceResolver resourceResolver;

    public EntityResolverWrappingResourceResolver(ResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        Source resolved;
        if (this.resourceResolver instanceof EntityResolver2) {
            return ((EntityResolver2)((Object)this.resourceResolver)).resolveEntity(name, publicId, baseURI, systemId);
        }
        ResourceRequest request = new ResourceRequest();
        request.baseUri = baseURI;
        request.entityName = name;
        request.publicId = publicId;
        request.uri = systemId;
        request.nature = "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity";
        request.purpose = ResourceRequest.ANY_PURPOSE;
        try {
            if (baseURI == null) {
                request.uri = systemId;
            } else {
                request.baseUri = baseURI;
                request.uri = ResolveURI.makeAbsolute(systemId, baseURI).toString();
            }
        }
        catch (URISyntaxException e) {
            throw new IOException("Cannot resolve URI supplied for entity resolution", e);
        }
        try {
            resolved = this.resourceResolver.resolve(request);
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
        if (resolved == null) {
            return null;
        }
        if (resolved instanceof StreamSource) {
            InputSource is = new InputSource(resolved.getSystemId());
            if (((StreamSource)resolved).getInputStream() != null) {
                is.setByteStream(((StreamSource)resolved).getInputStream());
            }
            if (((StreamSource)resolved).getReader() != null) {
                is.setCharacterStream(((StreamSource)resolved).getReader());
            }
            return is;
        }
        if (resolved instanceof SAXSource) {
            return ((SAXSource)resolved).getInputSource();
        }
        throw new SAXException("Unexpected Source type in resolveEntity()");
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }
}

