/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class BMPString
extends UnicodeString {
    private final String baseString;

    protected BMPString(String baseString) {
        this.baseString = baseString;
    }

    public static UnicodeString of(String base) {
        if (Configuration.isAssertionsEnabled()) {
            for (int i = 0; i < base.length(); ++i) {
                assert (!UTF16CharacterSet.isSurrogate(base.charAt(i)));
            }
        }
        return new BMPString(base);
    }

    @Override
    public long length() {
        return this.baseString.length();
    }

    @Override
    public boolean isEmpty() {
        return this.baseString.isEmpty();
    }

    @Override
    public int getWidth() {
        return 16;
    }

    @Override
    public IntIterator codePoints() {
        return StringTool.codePoints(this.baseString);
    }

    @Override
    public long indexOf(int codePoint) {
        if (codePoint > 65535) {
            return -1L;
        }
        return this.baseString.indexOf((char)codePoint);
    }

    @Override
    public long indexOf(int codePoint, long from) {
        int from32 = BMPString.requireInt(from);
        if (codePoint > 65535) {
            return -1L;
        }
        return this.baseString.indexOf((char)codePoint, from32);
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        for (int i = BMPString.requireNonNegativeInt(from); i < this.baseString.length(); ++i) {
            if (!predicate.test(this.baseString.charAt(i))) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public int codePointAt(long index) {
        return this.baseString.charAt(BMPString.requireInt(index));
    }

    @Override
    public UnicodeString substring(long start, long end) {
        int start32 = BMPString.requireInt(start);
        int end32 = BMPString.requireInt(end);
        return new BMPString(this.baseString.substring(start32, end32));
    }

    @Override
    public UnicodeString concat(UnicodeString other) {
        if (other instanceof BMPString) {
            return new BMPString(this.baseString + ((BMPString)other).baseString);
        }
        UnicodeBuilder ub = new UnicodeBuilder();
        return ub.accept(this).accept(other).toUnicodeString();
    }

    @Override
    public int compareTo(UnicodeString other) {
        if (other instanceof BMPString) {
            return this.baseString.compareTo(((BMPString)other).baseString);
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BMPString) {
            return this.baseString.equals(((BMPString)obj).baseString);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.baseString.hashCode();
    }

    public String toString() {
        return this.baseString;
    }

    @Override
    void copy16bit(char[] target, int offset) {
        this.baseString.getChars(0, this.baseString.length(), target, offset);
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        char[] chars = this.baseString.toCharArray();
        int i = 0;
        int j = offset;
        while (i < chars.length) {
            char c = chars[i++];
            target[j++] = 0;
            target[j++] = (byte)(c >> 8);
            target[j++] = (byte)(c & 0xFF);
        }
    }

    @Override
    void copy32bit(int[] target, int offset) {
        int i = 0;
        int j = offset;
        while (i < this.baseString.length()) {
            target[j++] = this.baseString.charAt(i++);
        }
    }
}

