/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.trans.XPathException;

public class XSLOutputCharacter
extends StyleElement {
    private int codepoint = -1;
    private String replacementString = null;

    @Override
    protected void prepareAttributes() {
        block5: for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            if (f.equals("character")) {
                switch (value.length()) {
                    case 0: {
                        this.compileError("character attribute must not be zero-length", "XTSE0020");
                        this.codepoint = 256;
                        continue block5;
                    }
                    case 1: {
                        this.codepoint = value.charAt(0);
                        continue block5;
                    }
                    case 2: {
                        if (UTF16CharacterSet.isHighSurrogate(value.charAt(0)) && UTF16CharacterSet.isLowSurrogate(value.charAt(1))) {
                            this.codepoint = UTF16CharacterSet.combinePair(value.charAt(0), value.charAt(1));
                            continue block5;
                        }
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.codepoint = 256;
                        continue block5;
                    }
                }
                this.compileError("character attribute must be a single XML character", "XTSE0020");
                this.codepoint = 256;
                continue;
            }
            if (f.equals("string")) {
                this.replacementString = value;
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.codepoint == -1) {
            this.reportAbsence("character");
            this.codepoint = 256;
            return;
        }
        if (this.replacementString == null) {
            this.reportAbsence("string");
            this.replacementString = "";
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        if (!(this.getParent() instanceof XSLCharacterMap)) {
            this.compileError("xsl:output-character may appear only as a child of xsl:character-map", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return null;
    }

    public int getCodePoint() {
        return this.codepoint;
    }

    public String getReplacementString() {
        return this.replacementString;
    }
}

