/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.java.CleanerProxy;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicateProxy;

public abstract class TextLinesIterator
implements SequenceIterator {
    protected LineNumberReader reader;
    protected IntPredicateProxy checker;
    StringValue current = null;
    int position = 0;
    protected Location location;
    protected URI uri;
    private CleanerProxy.CleanableProxy cleanable;

    protected TextLinesIterator() {
    }

    @Override
    public StringValue next() {
        if (this.position < 0) {
            this.close();
            return null;
        }
        try {
            String s = this.reader.readLine();
            if (s == null) {
                this.current = null;
                this.position = -1;
                this.close();
                return null;
            }
            if (this.position == 0 && s.length() > 0 && s.charAt(0) == '\ufeff') {
                s = s.substring(1);
            }
            this.checkLine(this.checker, s);
            this.current = new StringValue(s);
            ++this.position;
            return this.current;
        }
        catch (IOException err) {
            this.close();
            XPathException e = this.handleIOError(this.uri, err);
            if (this.location != null) {
                e.setLocator(this.location);
            }
            throw new UncheckedXPathException(e);
        }
        catch (XPathException err) {
            throw new UncheckedXPathException(err);
        }
    }

    protected XPathException handleIOError(URI uri, IOException err) {
        return UnparsedTextFunction.handleIOError(uri, err);
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
    }

    private void checkLine(IntPredicateProxy checker, String buffer) throws XPathException {
        int c = 0;
        while (c < buffer.length()) {
            int ch32;
            if (UTF16CharacterSet.isHighSurrogate(ch32 = buffer.charAt(c++))) {
                char low = buffer.charAt(c++);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (checker.test(ch32)) continue;
            throw new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + this.position + " column=" + (c + 1) + " value=hex " + Integer.toHexString(ch32) + ')').withErrorCode("FOUT1190").withLocation(this.location);
        }
    }

    protected void arrangeCleanup(Reader reader, XPathContext context) {
        this.cleanable = context.getConfiguration().registerCleanupAction(this, () -> {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

