/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Iterator;
import java.util.Objects;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.Item;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;

public abstract class AtomicValue
implements Item,
AtomicSequence,
ConversionResult,
IdentityComparable {
    protected final AtomicType typeLabel;

    public AtomicValue(AtomicType typeLabel) {
        Objects.requireNonNull(typeLabel);
        this.typeLabel = typeLabel;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return this;
    }

    @Override
    public final AtomicValue head() {
        return this;
    }

    @Override
    public int getLength() {
        return 1;
    }

    public boolean isUntypedAtomic() {
        return this.typeLabel == BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public abstract AtomicMatchKey getXPathMatchKey(StringCollator var1, int var2) throws NoDynamicContextException;

    public abstract XPathComparable getXPathComparable(StringCollator var1, int var2) throws NoDynamicContextException;

    public AtomicMatchKey asMapKey() {
        try {
            return this.getXPathMatchKey(CodepointCollator.getInstance(), Integer.MIN_VALUE);
        }
        catch (NoDynamicContextException e) {
            throw new IllegalStateException("No implicit timezone available");
        }
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("equals() not implemented");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() not implemented");
    }

    public boolean isIdentical(AtomicValue v) {
        return SimpleTypeComparison.getInstance().equal(this, v);
    }

    @Override
    public boolean isIdentical(IdentityComparable other) {
        return other instanceof AtomicValue && this.isIdentical((AtomicValue)other);
    }

    @Override
    public int identityHashCode() {
        return this.hashCode();
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        UnicodeString cs = this.getPrimitiveStringValue();
        try {
            return this.typeLabel.postprocess(cs);
        }
        catch (XPathException err) {
            return cs;
        }
    }

    @Override
    public UnicodeString getCanonicalLexicalRepresentation() {
        return this.getUnicodeStringValue();
    }

    @Override
    public final AtomicValue itemAt(int n) {
        return n == 0 ? this.head() : null;
    }

    public final AtomicType getItemType() {
        return this.typeLabel;
    }

    public abstract BuiltInAtomicType getPrimitiveType();

    public final UType getUType() {
        return this.getItemType().getUType();
    }

    public final int getCardinality() {
        return 16384;
    }

    public abstract AtomicValue copyAsSubType(AtomicType var1);

    public boolean isNaN() {
        return false;
    }

    public abstract UnicodeString getPrimitiveStringValue();

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("Effective boolean value is not defined for an atomic value of type " + Type.displayTypeName(this)).asTypeError().withErrorCode("FORG0006");
    }

    public AtomicValue getComponent(AccessorFn.Component component) throws XPathException {
        throw new UnsupportedOperationException("Data type does not support component extraction");
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (whole) {
            SimpleType stype = null;
            if (parentType instanceof SimpleType) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err = stype.validateContent(this.getUnicodeStringValue(), null, env.getConfiguration().getConversionRules());
                if (err != null) {
                    throw err.makeException();
                }
                return;
            }
        }
        if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isAllWhite(this.getUnicodeStringValue())) {
            XPathException err = new XPathException("Complex type " + parentType.getDescription() + " does not allow text content " + Err.wrap(this.getUnicodeStringValue()));
            err.setIsTypeError(true);
            throw err;
        }
    }

    public void checkValidInJavascript() throws XPathException {
    }

    @Override
    public AtomicValue asAtomic() {
        return this;
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public String toShortString() {
        return this.show();
    }

    public String show() {
        return this.typeLabel + "(\"" + this.getUnicodeStringValue() + "\")";
    }

    @Override
    public SingleAtomicIterator iterate() {
        return (SingleAtomicIterator)SingleAtomicIterator.makeIterator(this);
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return new MonoIterator<AtomicValue>(this);
    }

    @Override
    public final Genre getGenre() {
        return Genre.ATOMIC;
    }
}

