/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.functions.Round;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.NumericValue;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NEGATIVE_ZERO = new DoubleValue(-0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private final double value;

    public DoubleValue(double value) {
        super(BuiltInAtomicType.DOUBLE);
        this.value = value;
    }

    public DoubleValue(double value, AtomicType typeLabel) {
        super(typeLabel);
        this.value = value;
    }

    public static DoubleValue makeDoubleValue(double value) {
        return new DoubleValue(value);
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new DoubleValue(this.value, typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DOUBLE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return (float)this.value;
    }

    @Override
    public BigDecimal getDecimalValue() throws ValidationException {
        try {
            return BigDecimal.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public long longValue() throws XPathException {
        return (long)this.value;
    }

    @Override
    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return Double.valueOf(this.value).hashCode();
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        return DoubleValue.doubleToString(this.value);
    }

    @Override
    public UnicodeString getCanonicalLexicalRepresentation() {
        return FloatingPointConverter.convertDouble(this.value, true);
    }

    public static UnicodeString doubleToString(double value) {
        double d = Math.abs(value);
        return FloatingPointConverter.convertDouble(value, d != 0.0 && (d >= 1000000.0 || d < 1.0E-6));
    }

    @Override
    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    @Override
    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    @Override
    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    @Override
    public NumericValue round(int scale) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (scale == 0 && this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            if (this.value >= -0.5 && this.value < 0.0) {
                return new DoubleValue(-0.0);
            }
            return new DoubleValue(Math.round(this.value));
        }
        return this.roundViaDecimal(scale, Round.RoundingRule.HALF_TO_CEILING);
    }

    @Override
    public NumericValue round(int scale, Round.RoundingRule roundingRule) {
        if (this.value == 0.0 || Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return this;
        }
        if (scale == 0) {
            if (roundingRule == Round.RoundingRule.CEILING) {
                return this.ceiling();
            }
            if (roundingRule == Round.RoundingRule.FLOOR) {
                return this.floor();
            }
            if (roundingRule == Round.RoundingRule.HALF_TO_CEILING && this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
                if (this.value >= -0.5 && this.value < 0.0) {
                    return new DoubleValue(-0.0);
                }
                return new DoubleValue(Math.round(this.value));
            }
        }
        return this.roundViaDecimal(scale, roundingRule);
    }

    private DoubleValue roundViaDecimal(int scale, Round.RoundingRule roundingRule) {
        if (this.value == 0.0 || Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return this;
        }
        BigDecimalValue decimalValue = new BigDecimalValue(new BigDecimal(this.value));
        NumericValue rounded = decimalValue.round(scale, roundingRule);
        double result = rounded.getDoubleValue();
        if (result == 0.0) {
            return this.value < 0.0 ? NEGATIVE_ZERO : ZERO;
        }
        return new DoubleValue(result);
    }

    @Override
    public int signum() {
        if (Double.isNaN(this.value)) {
            return 0;
        }
        return this.value > 0.0 ? 1 : (this.value == 0.0 ? 0 : -1);
    }

    @Override
    public boolean isNegativeZero() {
        return this.value == 0.0 && (Double.doubleToLongBits(this.value) & Long.MIN_VALUE) != 0L;
    }

    @Override
    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value) && !Double.isInfinite(this.value);
    }

    @Override
    public int asSubscript() {
        if (this.isWholeNumber() && this.value > 0.0 && this.value <= 2.147483647E9) {
            return (int)this.value;
        }
        return -1;
    }

    @Override
    public NumericValue abs() {
        if (this.value > 0.0) {
            return this;
        }
        return new DoubleValue(Math.abs(this.value));
    }

    @Override
    public int compareTo(long other) {
        double otherDouble = other;
        if (this.value == otherDouble) {
            return 0;
        }
        return this.value < otherDouble ? -1 : 1;
    }

    @Override
    public AtomicMatchKey asMapKey() {
        if (this.isNaN()) {
            return AtomicSortComparer.COLLATION_KEY_NaN;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        try {
            return new BigDecimalValue(this.value);
        }
        catch (ValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean isIdentical(AtomicValue v) {
        return v instanceof DoubleValue && DoubleSortComparer.getInstance().comparesEqual(this, v);
    }
}

