/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.api.infoset;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.daffodil.api.infoset.InfosetArray;
import org.apache.daffodil.api.infoset.InfosetComplexElement;
import org.apache.daffodil.api.infoset.InfosetSimpleElement;

public abstract class InfosetOutputter {
    private Path blobDirectory = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private String blobPrefix = "daffodil-";
    private String blobSuffix = ".blob";
    private List<Path> blobPaths;

    public abstract void reset();

    public abstract void startDocument() throws Exception;

    public abstract void endDocument() throws Exception;

    public abstract void startSimple(InfosetSimpleElement var1) throws Exception;

    public abstract void endSimple(InfosetSimpleElement var1) throws Exception;

    public abstract void startComplex(InfosetComplexElement var1) throws Exception;

    public abstract void endComplex(InfosetComplexElement var1) throws Exception;

    public abstract void startArray(InfosetArray var1) throws Exception;

    public abstract void endArray(InfosetArray var1) throws Exception;

    public final void setBlobAttributes(Path path, String string, String string2) {
        this.blobDirectory = path;
        this.blobPrefix = string;
        this.blobSuffix = string2;
    }

    public final String getBlobPrefix() {
        return this.blobPrefix;
    }

    public final String getBlobSuffix() {
        return this.blobSuffix;
    }

    public final Path getBlobDirectory() {
        return this.blobDirectory;
    }

    public final List<Path> getBlobPaths() {
        return this.blobPaths;
    }

    public final void setBlobPaths(List<Path> list) {
        this.blobPaths = list;
    }
}

