/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dsom;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.core.dsom.Restriction;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.iapi.InvalidRestrictionPolicy;
import org.apache.daffodil.lib.iapi.InvalidRestrictionPolicy$Error$;
import org.apache.daffodil.lib.iapi.InvalidRestrictionPolicy$Ignore$;
import org.apache.daffodil.lib.iapi.InvalidRestrictionPolicy$Validate$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Boolean$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Byte$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Date$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$DateTime$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Decimal$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Double$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Float$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$HexBinary$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Int$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Integer$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Long$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$NonNegativeInteger$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Short$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$String$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Time$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedByte$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedInt$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedLong$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedShort$;
import org.apache.daffodil.runtime1.dsom.Facet;
import org.apache.daffodil.runtime1.dsom.Facet$enumeration$;
import org.apache.daffodil.runtime1.dsom.Facet$fractionDigits$;
import org.apache.daffodil.runtime1.dsom.Facet$length$;
import org.apache.daffodil.runtime1.dsom.Facet$maxExclusive$;
import org.apache.daffodil.runtime1.dsom.Facet$maxInclusive$;
import org.apache.daffodil.runtime1.dsom.Facet$maxLength$;
import org.apache.daffodil.runtime1.dsom.Facet$minExclusive$;
import org.apache.daffodil.runtime1.dsom.Facet$minInclusive$;
import org.apache.daffodil.runtime1.dsom.Facet$minLength$;
import org.apache.daffodil.runtime1.dsom.Facet$pattern$;
import org.apache.daffodil.runtime1.dsom.Facet$totalDigits$;
import org.apache.daffodil.runtime1.dsom.Facet$whiteSpace$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.xml.Node;
import scala.xml.NodeSeq;

public interface Facets {
    public static void $init$(Facets $this) {
    }

    private String retrieveFacetValueFromRestrictionBase(Node xml, Facet.Type facetName) {
        NodeSeq res = xml.$bslash$bslash("restriction").$bslash(facetName.toString()).$bslash("@value");
        if (res.length() > 0) {
            return ((Node)res.head()).text();
        }
        return "";
    }

    private Seq<String> retrieveFacetValuesFromRestrictionBase(Node xml, Facet.Type facetName) {
        NodeSeq res = xml.$bslash$bslash("restriction").$bslash(facetName.toString()).$bslash$bslash("@value");
        List ret = res.length() > 0 ? ((IterableOnceOps)res.map((Function1 & Serializable)n -> n.text())).toList() : package$.MODULE$.List().empty();
        return ret;
    }

    private Seq<String> enumeration(Node xml) {
        return this.retrieveFacetValuesFromRestrictionBase(xml, Facet$enumeration$.MODULE$);
    }

    private String fractionDigits(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$fractionDigits$.MODULE$);
    }

    private String length(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$length$.MODULE$);
    }

    private String maxExclusive(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$maxExclusive$.MODULE$);
    }

    private String maxInclusive(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$maxInclusive$.MODULE$);
    }

    private String maxLength(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$maxLength$.MODULE$);
    }

    private String minExclusive(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$minExclusive$.MODULE$);
    }

    private String minInclusive(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$minInclusive$.MODULE$);
    }

    private String minLength(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$minLength$.MODULE$);
    }

    private Seq<String> pattern(Node xml) {
        Seq res = (Seq)this.retrieveFacetValuesFromRestrictionBase(xml, Facet$pattern$.MODULE$).map((Function1 & Serializable)p -> p);
        return res;
    }

    private String totalDigits(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$totalDigits$.MODULE$);
    }

    private String whitespace(Node xml) {
        return this.retrieveFacetValueFromRestrictionBase(xml, Facet$whiteSpace$.MODULE$);
    }

    public static String localPatternValue$(Facets $this) {
        return $this.localPatternValue();
    }

    default public String localPatternValue() {
        Seq<String> patterns = this.pattern(((Restriction)this).xml());
        return patterns.mkString("|");
    }

    public static String localMinInclusiveValue$(Facets $this) {
        return $this.localMinInclusiveValue();
    }

    default public String localMinInclusiveValue() {
        return this.minInclusive(((Restriction)this).xml());
    }

    public static String localMaxInclusiveValue$(Facets $this) {
        return $this.localMaxInclusiveValue();
    }

    default public String localMaxInclusiveValue() {
        return this.maxInclusive(((Restriction)this).xml());
    }

    public static String localMinExclusiveValue$(Facets $this) {
        return $this.localMinExclusiveValue();
    }

    default public String localMinExclusiveValue() {
        return this.minExclusive(((Restriction)this).xml());
    }

    public static String localMaxExclusiveValue$(Facets $this) {
        return $this.localMaxExclusiveValue();
    }

    default public String localMaxExclusiveValue() {
        return this.maxExclusive(((Restriction)this).xml());
    }

    public static String localLengthValue$(Facets $this) {
        return $this.localLengthValue();
    }

    default public String localLengthValue() {
        return this.length(((Restriction)this).xml());
    }

    public static String localMinLengthValue$(Facets $this) {
        return $this.localMinLengthValue();
    }

    default public String localMinLengthValue() {
        String ml = this.minLength(((Restriction)this).xml());
        if (!ml.isEmpty() && !this.localLengthValue().isEmpty()) {
            throw Assert$.MODULE$.usageError2("Facets length and minLength cannot be specified together", "ml.isEmpty().||(Facets.this.localLengthValue.isEmpty())");
        }
        return ml;
    }

    public static String localMaxLengthValue$(Facets $this) {
        return $this.localMaxLengthValue();
    }

    default public String localMaxLengthValue() {
        String ml = this.maxLength(((Restriction)this).xml());
        if (!ml.isEmpty() && !this.localLengthValue().isEmpty()) {
            throw Assert$.MODULE$.usageError2("Facets length and maxLength cannot be specified together", "ml.isEmpty().||(Facets.this.localLengthValue.isEmpty())");
        }
        return ml;
    }

    public static String localTotalDigitsValue$(Facets $this) {
        return $this.localTotalDigitsValue();
    }

    default public String localTotalDigitsValue() {
        return this.totalDigits(((Restriction)this).xml());
    }

    public static String localFractionDigitsValue$(Facets $this) {
        return $this.localFractionDigitsValue();
    }

    default public String localFractionDigitsValue() {
        return this.fractionDigits(((Restriction)this).xml());
    }

    public static String localEnumerationValue$(Facets $this) {
        return $this.localEnumerationValue();
    }

    default public String localEnumerationValue() {
        Seq<String> enumerations = this.enumeration(((Restriction)this).xml());
        Seq distinctEnums = (Seq)enumerations.distinct();
        if (enumerations.size() != distinctEnums.size()) {
            throw ((Restriction)this).SDE("Enumerations must be unique!", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return ((IterableOnceOps)enumerations.map((Function1 & Serializable)s -> this.escapeForRegex((String)s))).mkString("|");
    }

    public static String localWhitespaceValue$(Facets $this) {
        return $this.localWhitespaceValue();
    }

    default public String localWhitespaceValue() {
        this.whitespace(((Restriction)this).xml());
        throw ((Restriction)this).SDE("whitespaceValue is not implemented for DFDL v1.0 schemas but reserved for future use.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private String escapeForRegex(String s) {
        StringBuilder sb = new StringBuilder();
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> Facets.escapeForRegex$$anonfun$1(sb, BoxesRunTime.unboxToChar((Object)c)));
        return sb.toString();
    }

    public static boolean hasEnumeration$(Facets $this) {
        return $this.hasEnumeration();
    }

    default public boolean hasEnumeration() {
        return this.localEnumerationValue().length() > 0 || this.getRemoteFacetValues(Facet$enumeration$.MODULE$).size() > 0;
    }

    public static boolean hasPattern$(Facets $this) {
        return $this.hasPattern();
    }

    default public boolean hasPattern() {
        return this.localPatternValue().length() > 0 || this.getRemoteFacetValues(Facet$pattern$.MODULE$).size() > 0;
    }

    public static boolean hasLength$(Facets $this) {
        return $this.hasLength();
    }

    default public boolean hasLength() {
        String string = this.localLengthValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$length$.MODULE$).size() > 0;
    }

    public static boolean hasMinLength$(Facets $this) {
        return $this.hasMinLength();
    }

    default public boolean hasMinLength() {
        String string = this.localMinLengthValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$minLength$.MODULE$).size() > 0;
    }

    public static boolean hasMaxLength$(Facets $this) {
        return $this.hasMaxLength();
    }

    default public boolean hasMaxLength() {
        String string = this.localMaxLengthValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$maxLength$.MODULE$).size() > 0;
    }

    public static boolean hasMinInclusive$(Facets $this) {
        return $this.hasMinInclusive();
    }

    default public boolean hasMinInclusive() {
        String string = this.localMinInclusiveValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$minInclusive$.MODULE$).size() > 0;
    }

    public static boolean hasMaxInclusive$(Facets $this) {
        return $this.hasMaxInclusive();
    }

    default public boolean hasMaxInclusive() {
        String string = this.localMaxInclusiveValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$maxInclusive$.MODULE$).size() > 0;
    }

    public static boolean hasMinExclusive$(Facets $this) {
        return $this.hasMinExclusive();
    }

    default public boolean hasMinExclusive() {
        String string = this.localMinExclusiveValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$minExclusive$.MODULE$).size() > 0;
    }

    public static boolean hasMaxExclusive$(Facets $this) {
        return $this.hasMaxExclusive();
    }

    default public boolean hasMaxExclusive() {
        String string = this.localMaxExclusiveValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$maxExclusive$.MODULE$).size() > 0;
    }

    public static boolean hasTotalDigits$(Facets $this) {
        return $this.hasTotalDigits();
    }

    default public boolean hasTotalDigits() {
        String string = this.localTotalDigitsValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$totalDigits$.MODULE$).size() > 0;
    }

    public static boolean hasFractionDigits$(Facets $this) {
        return $this.hasFractionDigits();
    }

    default public boolean hasFractionDigits() {
        String string = this.localFractionDigitsValue();
        String string2 = "";
        return (string != null ? !string.equals(string2) : string2 != null) || this.getRemoteFacetValues(Facet$fractionDigits$.MODULE$).size() > 0;
    }

    public static Seq patternValues$(Facets $this) {
        return $this.patternValues();
    }

    default public Seq<Tuple2<Facet.Type, Regex>> patternValues() {
        Seq values = (Seq)((Restriction)this).combinedBaseFacets().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Facet.Type f;
                Facet.Type type = f = (Facet.Type)tuple2._1();
                Facet$pattern$ facet$pattern$ = Facet$pattern$.MODULE$;
                return !(type != null ? !type.equals(facet$pattern$) : facet$pattern$ != null);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq valuesRemapped = (Seq)values.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._2();
                Facet.Type f = (Facet.Type)tuple2._1();
                if (string != null) {
                    String v = string;
                    String remapped = XMLUtils$.MODULE$.remapPUAToXMLIllegalCharacters(v);
                    return Tuple2$.MODULE$.apply((Object)f, (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(remapped)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)((Restriction)this).primType(), (Object)((Restriction)this).tunable().invalidRestrictionPolicy());
        if (tuple2 != null) {
            InvalidRestrictionPolicy invalidRestrictionPolicy = (InvalidRestrictionPolicy)tuple2._2();
            if (NodeInfo$PrimType$String$.MODULE$.equals(tuple2._1())) {
                return valuesRemapped;
            }
            if (InvalidRestrictionPolicy$Validate$.MODULE$.equals(invalidRestrictionPolicy)) {
                return valuesRemapped;
            }
            if (InvalidRestrictionPolicy$Error$.MODULE$.equals(invalidRestrictionPolicy)) {
                throw ((Restriction)this).SDE("Pattern restriction is only allowed to be applied to string and types derived from string.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            if (InvalidRestrictionPolicy$Ignore$.MODULE$.equals(invalidRestrictionPolicy)) {
                return package$.MODULE$.Nil();
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static Option enumerationValues$(Facets $this) {
        return $this.enumerationValues();
    }

    default public Option<String> enumerationValues() {
        Seq values = (Seq)((Restriction)this).combinedBaseFacets().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Facet.Type f;
                Facet.Type type = f = (Facet.Type)tuple2._1();
                Facet$enumeration$ facet$enumeration$ = Facet$enumeration$.MODULE$;
                return !(type != null ? !type.equals(facet$enumeration$) : facet$enumeration$ != null);
            }
            throw new MatchError((Object)tuple2);
        });
        if (values.size() > 0) {
            Tuple2 tuple2 = (Tuple2)values.apply(0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String value = (String)tuple2._2();
            String value2 = value;
            return Some$.MODULE$.apply((Object)value2);
        }
        return None$.MODULE$;
    }

    public static BigDecimal lengthValue$(Facets $this) {
        return $this.lengthValue();
    }

    default public BigDecimal lengthValue() {
        return this.getFacetValue(this.localLengthValue(), Facet$length$.MODULE$, this.hasLength());
    }

    public static BigDecimal minLengthValue$(Facets $this) {
        return $this.minLengthValue();
    }

    default public BigDecimal minLengthValue() {
        return this.getFacetValue(this.localMinLengthValue(), Facet$minLength$.MODULE$, this.hasMinLength());
    }

    public static BigDecimal maxLengthValue$(Facets $this) {
        return $this.maxLengthValue();
    }

    default public BigDecimal maxLengthValue() {
        return this.getFacetValue(this.localMaxLengthValue(), Facet$maxLength$.MODULE$, this.hasMaxLength());
    }

    public static BigDecimal minInclusiveValue$(Facets $this) {
        return $this.minInclusiveValue();
    }

    default public BigDecimal minInclusiveValue() {
        return this.getFacetValue(this.localMinInclusiveValue(), Facet$minInclusive$.MODULE$, this.hasMinInclusive());
    }

    public static BigDecimal maxInclusiveValue$(Facets $this) {
        return $this.maxInclusiveValue();
    }

    default public BigDecimal maxInclusiveValue() {
        return this.getFacetValue(this.localMaxInclusiveValue(), Facet$maxInclusive$.MODULE$, this.hasMaxInclusive());
    }

    public static BigDecimal minExclusiveValue$(Facets $this) {
        return $this.minExclusiveValue();
    }

    default public BigDecimal minExclusiveValue() {
        return this.getFacetValue(this.localMinExclusiveValue(), Facet$minExclusive$.MODULE$, this.hasMinExclusive());
    }

    public static BigDecimal maxExclusiveValue$(Facets $this) {
        return $this.maxExclusiveValue();
    }

    default public BigDecimal maxExclusiveValue() {
        return this.getFacetValue(this.localMaxExclusiveValue(), Facet$maxExclusive$.MODULE$, this.hasMaxExclusive());
    }

    public static BigDecimal totalDigitsValue$(Facets $this) {
        return $this.totalDigitsValue();
    }

    default public BigDecimal totalDigitsValue() {
        return this.getFacetValue(this.localTotalDigitsValue(), Facet$totalDigits$.MODULE$, this.hasTotalDigits());
    }

    public static BigDecimal fractionDigitsValue$(Facets $this) {
        return $this.fractionDigitsValue();
    }

    default public BigDecimal fractionDigitsValue() {
        return this.getFacetValue(this.localFractionDigitsValue(), Facet$fractionDigits$.MODULE$, this.hasFractionDigits());
    }

    private void errorOnLocalLessThanBaseFacet(BigInteger local, BigInteger base, Facet.Type theFacetType) {
        int res = local.compareTo(base);
        if (res < 0) {
            throw ((Restriction)this).SDE("SimpleTypes: The local %s (%s) was less than the base %s (%s) ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theFacetType, local, theFacetType, base}));
        }
    }

    private void errorOnLocalGreaterThanBaseFacet(BigInteger local, BigInteger base, Facet.Type theFacetType) {
        int res = local.compareTo(base);
        if (res > 0) {
            throw ((Restriction)this).SDE("SimpleTypes: The local %s (%s) was greater than the base %s (%s) ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theFacetType, local, theFacetType, base}));
        }
    }

    private void errorOnLocalLessThanBaseFacet(BigDecimal local, BigDecimal base, Facet.Type theFacetType) {
        int res = local.compareTo(base);
        if (res < 0) {
            throw ((Restriction)this).SDE("SimpleTypes: The local %s (%s) was less than the base %s (%s) ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theFacetType, local, theFacetType, base}));
        }
    }

    private void errorOnLocalGreaterThanBaseFacet(BigDecimal local, BigDecimal base, Facet.Type theFacetType) {
        int res = local.compareTo(base);
        if (res > 0) {
            throw ((Restriction)this).SDE("SimpleTypes: The local %s (%s) was greater than the base %s (%s) ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theFacetType, local, theFacetType, base}));
        }
    }

    private void errorOnLocalNotEqualToBaseFacet(BigInteger local, BigInteger base, Facet.Type theFacetType) {
        int res = local.compareTo(base);
        if (res != 0) {
            throw ((Restriction)this).SDE("SimpleTypes: The local %s (%s) was not equal to the base %s (%s) ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theFacetType, local, theFacetType, base}));
        }
    }

    private Seq<Tuple2<Facet.Type, String>> getRemoteFacetValues(Facet.Type theFacetType) {
        Seq res = (Seq)((Restriction)this).remoteBaseFacets().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Facet.Type f;
                Facet.Type type = f = (Facet.Type)tuple2._1();
                Facet.Type type2 = theFacetType;
                return !(type != null ? !type.equals(type2) : type2 != null);
            }
            throw new MatchError((Object)tuple2);
        });
        return res;
    }

    private String getRemoteFacetValue(Facet.Type theFacetType) {
        Seq res = (Seq)((Restriction)this).remoteBaseFacets().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Facet.Type f = (Facet.Type)tuple2._1();
                String v = (String)tuple2._2();
                Facet.Type type = f;
                Facet.Type type2 = theFacetType;
                return !(type != null ? !type.equals(type2) : type2 != null);
            }
            throw new MatchError((Object)tuple2);
        });
        if (res.size() > 0) {
            Tuple2 tuple2 = (Tuple2)res.apply(0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String theFacetValue = (String)tuple2._2();
            String theFacetValue2 = theFacetValue;
            return theFacetValue2;
        }
        return "";
    }

    private BigDecimal getFacetValue(String theLocalValue, String theRemoteValue, Facet.Type theType, boolean exists) {
        if (!exists) {
            throw ((Restriction)this).SDE("The facet %s was not found.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theType}));
        }
        String string = theLocalValue;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = theRemoteValue;
            String string4 = "";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                String resFacet = this.doNumericFacetNarrowing(theLocalValue, theRemoteValue, theType);
                return new BigDecimal(resFacet);
            }
        }
        String string5 = theLocalValue;
        String string6 = "";
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return this.checkValueSpaceFacetRange(theLocalValue, theType);
        }
        return this.checkValueSpaceFacetRange(theRemoteValue, theType);
    }

    private BigDecimal getFacetValue(String theLocalValue, Facet.Type theType, boolean exists) {
        Seq<Tuple2<Facet.Type, String>> remoteFacets = this.getRemoteFacetValues(theType);
        if (!exists) {
            throw ((Restriction)this).SDE("The facet %s was not found.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{theType}));
        }
        String string = theLocalValue;
        String string2 = "";
        if ((string == null ? string2 != null : !string.equals(string2)) && remoteFacets.size() > 0) {
            Tuple2 tuple2 = (Tuple2)this.getRemoteFacetValues(theType).apply(0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String remoteValue = (String)tuple2._2();
            String remoteValue2 = remoteValue;
            String resFacet = this.doNumericFacetNarrowing(theLocalValue, remoteValue2, theType);
            return new BigDecimal(resFacet);
        }
        String string3 = theLocalValue;
        String string4 = "";
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return this.checkValueSpaceFacetRange(theLocalValue, theType);
        }
        Tuple2 tuple2 = (Tuple2)remoteFacets.apply(0);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String remoteValue = (String)tuple2._2();
        String remoteValue3 = remoteValue;
        return this.checkValueSpaceFacetRange(remoteValue3, theType);
    }

    private String narrowNonNegativeFacets(String localFacet, String remoteFacet, Facet.Type facetType) {
        BigInteger theLocalFacet = new BigInteger(localFacet);
        BigInteger theRemoteFacet = new BigInteger(remoteFacet);
        if (theLocalFacet.signum() != 1) {
            throw ((Restriction)this).SDE("The %s facet must be a non-negative integer.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType}));
        }
        Facet.Type type = facetType;
        if (Facet$minLength$.MODULE$.equals(type)) {
            this.errorOnLocalLessThanBaseFacet(theLocalFacet, theRemoteFacet, facetType);
            return localFacet;
        }
        if (Facet$length$.MODULE$.equals(type)) {
            this.errorOnLocalNotEqualToBaseFacet(theLocalFacet, theRemoteFacet, facetType);
            return localFacet;
        }
        if (Facet$maxLength$.MODULE$.equals(type) || Facet$fractionDigits$.MODULE$.equals(type)) {
            this.errorOnLocalGreaterThanBaseFacet(theLocalFacet, theRemoteFacet, facetType);
            return localFacet;
        }
        String errMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("narrowNonNegativeFacets is not valid for %s facet"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType}));
        throw Assert$.MODULE$.usageError(errMsg);
    }

    private String narrowPositiveIntegerFacets(String localFacet, String remoteFacet, Facet.Type facetType) {
        BigInteger theLocalFacet = new BigInteger(localFacet);
        BigInteger theRemoteFacet = new BigInteger(remoteFacet);
        if (theLocalFacet.signum() != 1 || theLocalFacet.compareTo(BigInteger.ZERO) == 0) {
            throw ((Restriction)this).SDE("The %s facet must be a positive integer.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType}));
        }
        Facet.Type type = facetType;
        if (Facet$totalDigits$.MODULE$.equals(type)) {
            this.errorOnLocalGreaterThanBaseFacet(theLocalFacet, theRemoteFacet, facetType);
            return localFacet;
        }
        String errMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("narrowPositiveIntegerFacets is not valid for %s facet"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType}));
        throw Assert$.MODULE$.usageError(errMsg);
    }

    private String narrowValueSpaceFacets(String localFacet, String remoteFacet, Facet.Type facetType) {
        Tuple2<BigDecimal, BigDecimal> tuple2 = this.checkValueSpaceFacetRange(localFacet, remoteFacet, facetType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BigDecimal theLocalFacet = (BigDecimal)tuple2._1();
        BigDecimal theRemoteFacet = (BigDecimal)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)theLocalFacet, (Object)theRemoteFacet);
        BigDecimal theLocalFacet2 = (BigDecimal)tuple22._1();
        BigDecimal theRemoteFacet2 = (BigDecimal)tuple22._2();
        Facet.Type type = facetType;
        if (Facet$minInclusive$.MODULE$.equals(type)) {
            this.errorOnLocalLessThanBaseFacet(theLocalFacet2, theRemoteFacet2, facetType);
        } else if (Facet$maxInclusive$.MODULE$.equals(type)) {
            this.errorOnLocalGreaterThanBaseFacet(theLocalFacet2, theRemoteFacet2, facetType);
        } else if (Facet$minExclusive$.MODULE$.equals(type)) {
            this.errorOnLocalLessThanBaseFacet(theLocalFacet2, theRemoteFacet2, facetType);
        } else if (Facet$maxExclusive$.MODULE$.equals(type)) {
            this.errorOnLocalGreaterThanBaseFacet(theLocalFacet2, theRemoteFacet2, facetType);
        } else {
            String errMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unrecognized facet type (%s) for narrowing of value-space facets."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType}));
            throw Assert$.MODULE$.usageError(errMsg);
        }
        return localFacet;
    }

    private BigDecimal convertFacetToBigDecimal(String facet) {
        NodeInfo.PrimType primType = ((Restriction)this).primType();
        if (NodeInfo$PrimType$DateTime$.MODULE$.equals(primType)) {
            return ((Restriction)this).dateToBigDecimal(facet, "uuuu-MM-dd'T'HH:mm:ss.SSSSSSxxx", NodeInfo$PrimType$DateTime$.MODULE$.toString(), (ThrowsSDE)((Object)this));
        }
        if (NodeInfo$PrimType$Date$.MODULE$.equals(primType)) {
            return ((Restriction)this).dateToBigDecimal(facet, "uuuu-MM-ddxxx", NodeInfo$PrimType$Date$.MODULE$.toString(), (ThrowsSDE)((Object)this));
        }
        if (NodeInfo$PrimType$Time$.MODULE$.equals(primType)) {
            return ((Restriction)this).dateToBigDecimal(facet, "HH:mm:ss.SSSSSSxxx", NodeInfo$PrimType$Time$.MODULE$.toString(), (ThrowsSDE)((Object)this));
        }
        return new BigDecimal(facet);
    }

    private BigDecimal checkValueSpaceFacetRange(String localFacet, Facet.Type facetType) {
        BigDecimal theLocalFacet = this.convertFacetToBigDecimal(localFacet);
        Facet.Type type = facetType;
        if (Facet$maxExclusive$.MODULE$.equals(type) || Facet$maxInclusive$.MODULE$.equals(type) || Facet$minExclusive$.MODULE$.equals(type) || Facet$minInclusive$.MODULE$.equals(type) || Facet$enumeration$.MODULE$.equals(type)) {
            NodeInfo.PrimType primType = ((Restriction)this).primType();
            if (NodeInfo$PrimType$Int$.MODULE$.equals(primType)) {
                if (!this.isFacetInIntRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Int range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$Byte$.MODULE$.equals(primType)) {
                if (!this.isFacetInByteRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Byte range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$Short$.MODULE$.equals(primType)) {
                if (!this.isFacetInShortRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Short range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$Long$.MODULE$.equals(primType)) {
                if (!this.isFacetInLongRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Long range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$Integer$.MODULE$.equals(primType)) {
                if (!this.isFacetInIntegerRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Integer range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$UnsignedInt$.MODULE$.equals(primType)) {
                if (!this.isFacetInUnsignedIntRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of unsigned int range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$UnsignedByte$.MODULE$.equals(primType)) {
                if (!this.isFacetInUnsignedByteRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of unsigned byte range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$UnsignedShort$.MODULE$.equals(primType)) {
                if (!this.isFacetInUnsignedShortRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of unsigned short range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$UnsignedLong$.MODULE$.equals(primType)) {
                if (!this.isFacetInUnsignedLongRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of unsigned long range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$Double$.MODULE$.equals(primType)) {
                if (!this.isFacetInDoubleRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Double range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$Float$.MODULE$.equals(primType)) {
                if (!this.isFacetInFloatRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of Float range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (NodeInfo$PrimType$NonNegativeInteger$.MODULE$.equals(primType)) {
                if (!this.isFacetInNonNegativeIntegerRange(theLocalFacet)) {
                    throw ((Restriction)this).SDE("%s facet value (%s) was found to be outside of NonNegativeInteger range.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{facetType, localFacet}));
                }
            } else if (!(NodeInfo$PrimType$Decimal$.MODULE$.equals(primType) || NodeInfo$PrimType$DateTime$.MODULE$.equals(primType) || NodeInfo$PrimType$Date$.MODULE$.equals(primType) || NodeInfo$PrimType$Time$.MODULE$.equals(primType))) {
                if (NodeInfo$PrimType$Boolean$.MODULE$.equals(primType)) {
                    throw ((Restriction)this).notYetImplemented("checkValueSpaceFacetRange - Boolean", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                if (!NodeInfo$PrimType$HexBinary$.MODULE$.equals(primType) && !NodeInfo$PrimType$String$.MODULE$.equals(primType)) {
                    throw Assert$.MODULE$.usageError("checkValueSpaceFacetRange - Unrecognized primitive type: " + ((Restriction)this).primType().name());
                }
            }
        }
        return theLocalFacet;
    }

    private Tuple2<BigDecimal, BigDecimal> checkValueSpaceFacetRange(String localFacet, String remoteFacet, Facet.Type facetType) {
        BigDecimal theRemoteFacet = this.checkValueSpaceFacetRange(remoteFacet, facetType);
        BigDecimal theLocalFacet = this.checkValueSpaceFacetRange(localFacet, facetType);
        return Tuple2$.MODULE$.apply((Object)theLocalFacet, (Object)theRemoteFacet);
    }

    private boolean isFacetInByteRange(BigDecimal facet) {
        return ((Restriction)this).isInByteRange(facet);
    }

    private boolean isFacetInShortRange(BigDecimal facet) {
        return ((Restriction)this).isInShortRange(facet);
    }

    private boolean isFacetInIntRange(BigDecimal facet) {
        return ((Restriction)this).isInIntRange(facet);
    }

    private boolean isFacetInIntegerRange(BigDecimal facet) {
        return ((Restriction)this).isInIntegerRange(facet);
    }

    private boolean isFacetInLongRange(BigDecimal facet) {
        return ((Restriction)this).isInLongRange(facet);
    }

    private boolean isFacetInDoubleRange(BigDecimal facet) {
        return ((Restriction)this).isInDoubleRange(facet);
    }

    private boolean isFacetInFloatRange(BigDecimal facet) {
        return ((Restriction)this).isInFloatRange(facet);
    }

    private boolean isFacetInNonNegativeIntegerRange(BigDecimal facet) {
        return ((Restriction)this).isInNonNegativeIntegerRange(facet);
    }

    private boolean isFacetInUnsignedLongRange(BigDecimal facet) {
        return ((Restriction)this).isInUnsignedLongRange(facet);
    }

    private boolean isFacetInUnsignedIntRange(BigDecimal facet) {
        return ((Restriction)this).isInUnsignedIntRange(facet);
    }

    private boolean isFacetInUnsignedShortRange(BigDecimal facet) {
        return ((Restriction)this).isInUnsignedShortRange(facet);
    }

    private boolean isFacetInUnsignedByteRange(BigDecimal facet) {
        return ((Restriction)this).isInUnsignedByteRange(facet);
    }

    public static String doNumericFacetNarrowing$(Facets $this, String localFacet, String remoteFacet, Facet.Type facetType) {
        return $this.doNumericFacetNarrowing(localFacet, remoteFacet, facetType);
    }

    default public String doNumericFacetNarrowing(String localFacet, String remoteFacet, Facet.Type facetType) {
        Facet.Type type = facetType;
        if (Facet$length$.MODULE$.equals(type) || Facet$minLength$.MODULE$.equals(type) || Facet$maxLength$.MODULE$.equals(type) || Facet$fractionDigits$.MODULE$.equals(type)) {
            return this.narrowNonNegativeFacets(localFacet, remoteFacet, facetType);
        }
        if (Facet$minInclusive$.MODULE$.equals(type) || Facet$maxInclusive$.MODULE$.equals(type) || Facet$minExclusive$.MODULE$.equals(type) || Facet$maxExclusive$.MODULE$.equals(type)) {
            return this.narrowValueSpaceFacets(localFacet, remoteFacet, facetType);
        }
        if (Facet$totalDigits$.MODULE$.equals(type)) {
            return this.narrowPositiveIntegerFacets(localFacet, remoteFacet, facetType);
        }
        throw Assert$.MODULE$.usageError("Call to 'doNumericFacetNarrowing' only valid for Numeric Facets.");
    }

    private String getLocalValue(Facet.Type theType) {
        Seq res = (Seq)((Restriction)this).localBaseFacets().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Facet.Type f = (Facet.Type)tuple2._1();
                String v = (String)tuple2._2();
                Facet.Type type = f;
                Facet.Type type2 = theType;
                return !(type != null ? !type.equals(type2) : type2 != null);
            }
            throw new MatchError((Object)tuple2);
        });
        if (res.length() > 0) {
            Tuple2 tuple2 = (Tuple2)res.apply(0);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String theFacetValue = (String)tuple2._2();
            String theFacetValue2 = theFacetValue;
            return theFacetValue2;
        }
        return "";
    }

    public static BigDecimal getCombinedValue$(Facets $this, Facet.Type theType) {
        return $this.getCombinedValue(theType);
    }

    default public BigDecimal getCombinedValue(Facet.Type theType) {
        String lValue = this.getLocalValue(theType);
        String rValue = this.getRemoteFacetValue(theType);
        BigDecimal cValue = this.getFacetValue(lValue, rValue, theType, true);
        return cValue;
    }

    public static String getCombinedValueEnum$(Facets $this) {
        return $this.getCombinedValueEnum();
    }

    default public String getCombinedValueEnum() {
        String lValue = this.getLocalValue(Facet$enumeration$.MODULE$);
        String rValue = this.getRemoteFacetValue(Facet$enumeration$.MODULE$);
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(lValue), (Function1 & Serializable)v1 -> {
            this.getCombinedValueEnum$$anonfun$1(rValue, BoxesRunTime.unboxToChar((Object)v1));
            return BoxedUnit.UNIT;
        });
        if (lValue.length() > 0) {
            return lValue;
        }
        return rValue;
    }

    private static /* synthetic */ StringBuilder escapeForRegex$$anonfun$1(StringBuilder sb$1, char c) {
        char c2 = c;
        switch (c2) {
            case '[': {
                return sb$1.append("\\[");
            }
            case '\\': {
                return sb$1.append("\\\\");
            }
            case '^': {
                return sb$1.append("\\^");
            }
            case '$': {
                return sb$1.append("\\$");
            }
            case '.': {
                return sb$1.append("\\.");
            }
            case '|': {
                return sb$1.append("\\|");
            }
            case '?': {
                return sb$1.append("\\?");
            }
            case '*': {
                return sb$1.append("\\*");
            }
            case '+': {
                return sb$1.append("\\+");
            }
            case '(': {
                return sb$1.append("\\(");
            }
            case ')': {
                return sb$1.append("\\)");
            }
            case '{': {
                return sb$1.append("\\{");
            }
            case '}': {
                return sb$1.append("\\}");
            }
        }
        char x = c2;
        return sb$1.append(x);
    }

    private /* synthetic */ void getCombinedValueEnum$$anonfun$1(String rValue$1, char e) {
        if (rValue$1.length() > 0 && !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(rValue$1), e)) {
            throw ((Restriction)this).SDE("Local enumerations must be a subset of base enumerations.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }
}

