/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.lib.calendar.DFDLCalendar;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.EvalMode;
import org.apache.daffodil.runtime1.dpath.ExpressionEvaluationException;
import org.apache.daffodil.runtime1.dpath.FNErrorException;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$NonEmptyString$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$AnyURI$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Boolean$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Byte$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Date$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$DateTime$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Decimal$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Double$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Float$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$HexBinary$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Int$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Integer$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Long$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$NonNegativeInteger$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Short$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$Time$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedByte$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedInt$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedLong$;
import org.apache.daffodil.runtime1.dpath.NodeInfo$PrimType$UnsignedShort$;
import org.apache.daffodil.runtime1.dpath.ParserDiscriminatorNonBlocking$;
import org.apache.daffodil.runtime1.dpath.ParserNonBlocking$;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.dsom.DPathElementCompileInfo;
import org.apache.daffodil.runtime1.dsom.RuntimeSchemaDefinitionError;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.infoset.InfosetArrayIndexOutOfBoundsException;
import org.apache.daffodil.runtime1.infoset.InfosetException;
import org.apache.daffodil.runtime1.infoset.InfosetLengthUnknownException;
import org.apache.daffodil.runtime1.infoset.InfosetNoDataExceptionBase;
import org.apache.daffodil.runtime1.infoset.InfosetNoInfosetException;
import org.apache.daffodil.runtime1.infoset.InfosetNoNextSiblingException;
import org.apache.daffodil.runtime1.infoset.InfosetNoSuchChildElementException;
import org.apache.daffodil.runtime1.infoset.InfosetNodeNotFinalException;
import org.apache.daffodil.runtime1.infoset.InfosetSelfReferencingException;
import org.apache.daffodil.runtime1.infoset.OutputValueCalcEvaluationException;
import org.apache.daffodil.runtime1.processors.CompileState;
import org.apache.daffodil.runtime1.processors.Failure;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.ProcessingError;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.Suspension;
import org.apache.daffodil.runtime1.processors.VariableException;
import org.apache.daffodil.runtime1.processors.parsers.DoSDEMixin;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionProcessingErrorException;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class RuntimeExpressionDPath<T>
extends CompiledExpression<T>
implements DoSDEMixin {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RuntimeExpressionDPath.class.getDeclaredField("prettyExpr$lzy1"));
    private final NodeInfo.Kind tt;
    private final CompiledDPath recipe;
    private final String dpathText;
    private final DPathCompileInfo ci;
    private final Set contentReferencedElementInfos;
    private final Set valueReferencedElementInfos;
    private volatile Object prettyExpr$lzy1;

    public RuntimeExpressionDPath(NamedQName qn, NodeInfo.Kind tt, CompiledDPath recipe, String dpathText, DPathCompileInfo ci, boolean isEvaluatedAbove, Set<DPathElementCompileInfo> contentReferencedElementInfos, Set<DPathElementCompileInfo> valueReferencedElementInfos) {
        this.tt = tt;
        this.recipe = recipe;
        this.dpathText = dpathText;
        this.ci = ci;
        this.contentReferencedElementInfos = contentReferencedElementInfos;
        this.valueReferencedElementInfos = valueReferencedElementInfos;
        super(qn, dpathText);
    }

    @Override
    public Set<DPathElementCompileInfo> contentReferencedElementInfos() {
        return this.contentReferencedElementInfos;
    }

    @Override
    public Set<DPathElementCompileInfo> valueReferencedElementInfos() {
        return this.valueReferencedElementInfos;
    }

    @Override
    public NodeInfo.Kind targetType() {
        return this.tt;
    }

    @Override
    public String prettyExpr() {
        Object object = this.prettyExpr$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.prettyExpr$lzyINIT1();
    }

    private Object prettyExpr$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.prettyExpr$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = this.dpathText;
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.prettyExpr$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Nothing$ UE(Throwable e, Object maybeCL) {
        throw new UnparseError(Maybe$One$.MODULE$.apply(this.ci.schemaFileLocation()), maybeCL, e);
    }

    private Null$ doPE(Throwable e, ParseOrUnparseState state) {
        ParseOrUnparseState parseOrUnparseState = state;
        if (parseOrUnparseState == null) {
            throw Assert$.MODULE$.usageError("state cannot be null");
        }
        if (parseOrUnparseState instanceof UState) {
            UState ustate = (UState)parseOrUnparseState;
            throw this.UE(e, Maybe$One$.MODULE$.apply(ustate.currentLocation()));
        }
        if (parseOrUnparseState instanceof PState) {
            ProcessingError _pe;
            PState pstate = (PState)parseOrUnparseState;
            Throwable throwable = e;
            ProcessingError pe = throwable instanceof ProcessingError ? (_pe = (ProcessingError)throwable) : new ExpressionEvaluationException(e, state);
            pstate.setFailed(pe.toParseError());
        } else if (parseOrUnparseState instanceof CompileState) {
            org.apache.daffodil.lib.iapi.Diagnostic diagnostic;
            CompileState compState = (CompileState)parseOrUnparseState;
            Throwable throwable = e;
            if (throwable instanceof org.apache.daffodil.lib.iapi.Diagnostic) {
                org.apache.daffodil.lib.iapi.Diagnostic d = (org.apache.daffodil.lib.iapi.Diagnostic)throwable;
                diagnostic = d;
            } else {
                diagnostic = new ExpressionEvaluationException(e, state);
            }
            org.apache.daffodil.lib.iapi.Diagnostic d = diagnostic;
            compState.setFailed(d);
        } else {
            throw new MatchError((Object)parseOrUnparseState);
        }
        return null;
    }

    private Null$ handleCompileState(org.apache.daffodil.lib.iapi.Diagnostic e, ParseOrUnparseState state) {
        ParseOrUnparseState parseOrUnparseState = state;
        if (parseOrUnparseState instanceof CompileState) {
            CompileState cs = (CompileState)parseOrUnparseState;
            state.setFailed(e);
            return null;
        }
        if (parseOrUnparseState instanceof PState) {
            PState ps = (PState)parseOrUnparseState;
            EvalMode evalMode = ps.dState().mode();
            if (ParserDiscriminatorNonBlocking$.MODULE$.equals(evalMode)) {
                org.apache.daffodil.lib.iapi.Diagnostic diagnostic = e;
                if (diagnostic instanceof InfosetNoSuchChildElementException) {
                    InfosetNoSuchChildElementException nc = (InfosetNoSuchChildElementException)diagnostic;
                    return this.doPE(e, ps);
                }
                if (diagnostic instanceof InfosetNoInfosetException) {
                    InfosetNoInfosetException ni = (InfosetNoInfosetException)diagnostic;
                    return this.doPE(e, ps);
                }
                if (diagnostic instanceof InfosetNoDataExceptionBase) {
                    InfosetNoDataExceptionBase nd = (InfosetNoDataExceptionBase)diagnostic;
                    return this.doPE(e, ps);
                }
                if (diagnostic instanceof InfosetArrayIndexOutOfBoundsException) {
                    InfosetArrayIndexOutOfBoundsException ai = (InfosetArrayIndexOutOfBoundsException)diagnostic;
                    return this.doPE(e, ps);
                }
                throw this.doSDE(e, ps);
            }
            if (ParserNonBlocking$.MODULE$.equals(evalMode)) {
                org.apache.daffodil.lib.iapi.Diagnostic diagnostic = e;
                if (diagnostic instanceof InfosetNoDataExceptionBase) {
                    InfosetNoDataExceptionBase nd = (InfosetNoDataExceptionBase)diagnostic;
                    throw this.doSDE(new InfosetSelfReferencingException(state.dState().currentNode().asElement(), state.dState().currentNode().erd()), ps);
                }
                throw this.doSDE(e, ps);
            }
            throw this.doSDE(e, ps);
        }
        if (parseOrUnparseState instanceof UState) {
            UState us = (UState)parseOrUnparseState;
            throw e;
        }
        throw new MatchError((Object)parseOrUnparseState);
    }

    @Override
    public Object evaluateForwardReferencing(ParseOrUnparseState state, Suspension whereBlockedInfo) {
        BoxedUnit boxedUnit;
        Object value = Maybe$.MODULE$.Nope();
        try {
            DState dstate = this.evaluateExpression(state, state.dState());
            value = Maybe$One$.MODULE$.apply(this.processForwardExpressionResults(dstate));
            whereBlockedInfo.setDone();
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable throwable) {
            InfosetNoDataExceptionBase nd;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InfosetNodeNotFinalException) {
                Throwable unfin = (Throwable)((Object)((InfosetNodeNotFinalException)((Object)throwable2)));
                whereBlockedInfo.block(((InfosetNodeNotFinalException)((Object)unfin)).node(), ((InfosetNodeNotFinalException)((Object)unfin)).node().erd().dpathElementCompileInfo(), 0L, unfin);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof InfosetNoSuchChildElementException) {
                InfosetNoSuchChildElementException noChild = (InfosetNoSuchChildElementException)throwable2;
                whereBlockedInfo.block(noChild.diComplex(), noChild.nqn(), 0L, noChild);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof InfosetNoNextSiblingException) {
                InfosetNoNextSiblingException noSibling = (InfosetNoNextSiblingException)throwable2;
                whereBlockedInfo.block(noSibling.diSimple(), noSibling.info(), 0L, noSibling);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof InfosetArrayIndexOutOfBoundsException) {
                InfosetArrayIndexOutOfBoundsException noArrayIndex = (InfosetArrayIndexOutOfBoundsException)throwable2;
                whereBlockedInfo.block(noArrayIndex.diArray(), noArrayIndex.diArray().erd().dpathElementCompileInfo(), noArrayIndex.index(), noArrayIndex);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof InfosetNoDataExceptionBase && (nd = (InfosetNoDataExceptionBase)throwable2).erd().dpathElementCompileInfo().isOutputValueCalc()) {
                OutputValueCalcEvaluationException ovc = new OutputValueCalcEvaluationException(nd);
                whereBlockedInfo.block(nd.diElement(), nd.erd().dpathElementCompileInfo(), 0L, ovc);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof VariableException) {
                VariableException ve = (VariableException)throwable2;
                whereBlockedInfo.block(ve.qname(), ve.context(), 0L, ve);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof InfosetLengthUnknownException) {
                InfosetLengthUnknownException noLength = (InfosetLengthUnknownException)throwable2;
                whereBlockedInfo.block(noLength.diElement(), noLength.erd(), 0L, noLength);
                boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 != null) {
                Throwable th = throwable2;
                this.handleThrow(th, state);
                boxedUnit = null;
            }
            throw throwable;
        }
        this.validateType(value, state);
        return value;
    }

    @Override
    public void run(DState dstate) {
        this.recipe.run(dstate);
    }

    private T processForwardExpressionResults(DState dstate) {
        DIElement n;
        Object object;
        DINode dINode = dstate.currentNode();
        if (dINode == null) {
            Object object2 = dstate.currentValue();
            if (!DataValue$.MODULE$.isDefined$extension(object2)) {
                throw Assert$.MODULE$.abort("Invariant broken: dstate.currentValue.isDefined");
            }
            Object object3 = dstate.currentValue();
            object = DataValue$.MODULE$.getAnyRef$extension(object3);
        } else if (dINode instanceof DIElement && (n = (DIElement)dINode).isNilled()) {
            object = new Maybe(Maybe$One$.MODULE$.apply(n));
        } else if (dINode instanceof DIComplex) {
            DIComplex c = (DIComplex)dINode;
            if (this.targetType() instanceof NodeInfo.AnyAtomicKind) {
                throw Assert$.MODULE$.abort("Invariant broken: RuntimeExpressionDPath.this.targetType.isInstanceOf[org.apache.daffodil.runtime1.dpath.NodeInfo.AnyAtomic.Kind].unary_!");
            }
            object = c;
        } else if (dINode instanceof DISimple) {
            DISimple s = (DISimple)dINode;
            Object object4 = s.dataValue();
            object = DataValue$.MODULE$.getAnyRef$extension(object4);
        } else {
            throw Assert$.MODULE$.invariantFailed("must be an element, simple or complex.");
        }
        Object v = object;
        return (T)v;
    }

    private DState evaluateExpression(ParseOrUnparseState state, DState dstate) {
        this.recipe.runExpression(state, dstate);
        return dstate;
    }

    private Object evaluateMaybe(ParseOrUnparseState state) {
        Object object;
        try {
            DState dstate = this.evaluateExpression(state, state.dState());
            object = Maybe$One$.MODULE$.apply(this.processExpressionResults(dstate));
        }
        catch (Throwable th) {
            this.handleThrow(th, state);
            object = Maybe$.MODULE$.Nope();
        }
        Object value = object;
        this.validateType(value, state);
        return value;
    }

    @Override
    public final T evaluate(ParseOrUnparseState state) {
        Object maybeRes = this.evaluateMaybe(state);
        if (Maybe$.MODULE$.isDefined$extension(maybeRes)) {
            return Maybe$.MODULE$.value$extension(maybeRes);
        }
        if (state.processorStatus() == Success$.MODULE$) {
            throw Assert$.MODULE$.abort("Invariant broken: state.processorStatus.ne(org.apache.daffodil.runtime1.processors.Success)");
        }
        Diagnostic cause = ((Failure)state.processorStatus()).cause();
        throw cause;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public T constant() {
        throw Assert$.MODULE$.usageError("Not a constant.");
    }

    private T processExpressionResults(DState dstate) {
        DIElement n;
        Object object;
        DINode dINode = dstate.currentNode();
        if (dINode == null) {
            Object object2 = dstate.currentValue();
            object = DataValue$.MODULE$.getAnyRef$extension(object2);
        } else if (dINode instanceof DIElement && (n = (DIElement)dINode).isNilled()) {
            object = Maybe$One$.MODULE$;
        } else if (dINode instanceof DIComplex) {
            DIComplex c = (DIComplex)dINode;
            if (this.targetType() instanceof NodeInfo.AnyAtomicKind) {
                throw Assert$.MODULE$.abort("Invariant broken: RuntimeExpressionDPath.this.targetType.isInstanceOf[org.apache.daffodil.runtime1.dpath.NodeInfo.AnyAtomic.Kind].unary_!");
            }
            object = c;
        } else if (dINode instanceof DISimple) {
            DISimple s = (DISimple)dINode;
            try {
                Object object3 = s.dataValue();
                object = DataValue$.MODULE$.getAnyRef$extension(object3);
            }
            catch (OutputValueCalcEvaluationException ovc) {
                throw Assert$.MODULE$.invariantFailed("OVC should always have a data value by the time it reaches here.");
            }
        } else {
            throw Assert$.MODULE$.invariantFailed("must be an element, simple or complex.");
        }
        Object v = object;
        return (T)v;
    }

    private Null$ handleThrow(Throwable th, ParseOrUnparseState state) {
        Throwable throwable = th;
        if (throwable instanceof InfosetException) {
            Throwable e = (Throwable)((Object)((InfosetException)((Object)throwable)));
            return this.handleCompileState(((InfosetException)((Object)e)).asDiagnostic(), state);
        }
        if (throwable instanceof VariableException) {
            VariableException e = (VariableException)throwable;
            return this.handleCompileState(e, state);
        }
        if (throwable instanceof ExpressionEvaluationException) {
            ExpressionEvaluationException e = (ExpressionEvaluationException)throwable;
            ParseOrUnparseState parseOrUnparseState = state;
            if (parseOrUnparseState instanceof CompileState) {
                CompileState cs = (CompileState)parseOrUnparseState;
                return this.handleCompileState(e, state);
            }
            return this.doPE(e, state);
        }
        if (throwable instanceof IllegalStateException) {
            IllegalStateException e = (IllegalStateException)throwable;
            return this.doPE(e, state);
        }
        if (throwable instanceof NumberFormatException) {
            NumberFormatException e = (NumberFormatException)throwable;
            return this.doPE(e, state);
        }
        if (throwable instanceof IllegalArgumentException) {
            IllegalArgumentException e = (IllegalArgumentException)throwable;
            return this.doPE(e, state);
        }
        if (throwable instanceof ArithmeticException) {
            ArithmeticException e = (ArithmeticException)throwable;
            return this.doPE(e, state);
        }
        if (throwable instanceof FNErrorException) {
            Throwable e = (Throwable)((Object)((FNErrorException)((Object)throwable)));
            return this.doPE(e, state);
        }
        if (throwable instanceof UserDefinedFunctionProcessingErrorException) {
            UserDefinedFunctionProcessingErrorException e = (UserDefinedFunctionProcessingErrorException)throwable;
            return this.doPE(e, state);
        }
        Throwable th2 = throwable;
        throw th2;
    }

    private void validateType(Object v, ParseOrUnparseState state) {
        if (Maybe$.MODULE$.isDefined$extension(v)) {
            Object value = Maybe$.MODULE$.get$extension(v);
            if (!(value instanceof DIElement)) {
                NodeInfo.Kind kind = this.targetType();
                if (NodeInfo$NonEmptyString$.MODULE$.equals(kind)) {
                    if (!(value instanceof String)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[scala.Predef.String]");
                    }
                    if (((String)value).length() == 0) {
                        RuntimeSchemaDefinitionError e = new RuntimeSchemaDefinitionError(this.ci.schemaFileLocation(), "Non-empty string required.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                        throw this.doSDE(e, state);
                    }
                    return;
                }
                if (kind instanceof NodeInfo.PrimType.StringKind) {
                    if (!(value instanceof String)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[scala.Predef.String]");
                    }
                    return;
                }
                NodeInfo$PrimType$DateTime$ nodeInfo$PrimType$DateTime$ = NodeInfo$.MODULE$.DateTime();
                NodeInfo.Kind kind2 = kind;
                if (!(nodeInfo$PrimType$DateTime$ != null ? !nodeInfo$PrimType$DateTime$.equals(kind2) : kind2 != null)) {
                    if (!(value instanceof DFDLCalendar)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[org.apache.daffodil.lib.calendar.DFDLCalendar]");
                    }
                    return;
                }
                NodeInfo$PrimType$Date$ nodeInfo$PrimType$Date$ = NodeInfo$.MODULE$.Date();
                NodeInfo.Kind kind3 = kind;
                if (!(nodeInfo$PrimType$Date$ != null ? !nodeInfo$PrimType$Date$.equals(kind3) : kind3 != null)) {
                    if (!(value instanceof DFDLCalendar)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[org.apache.daffodil.lib.calendar.DFDLCalendar]");
                    }
                    return;
                }
                NodeInfo$PrimType$Time$ nodeInfo$PrimType$Time$ = NodeInfo$.MODULE$.Time();
                NodeInfo.Kind kind4 = kind;
                if (!(nodeInfo$PrimType$Time$ != null ? !nodeInfo$PrimType$Time$.equals(kind4) : kind4 != null)) {
                    if (!(value instanceof DFDLCalendar)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[org.apache.daffodil.lib.calendar.DFDLCalendar]");
                    }
                    return;
                }
                NodeInfo$PrimType$Boolean$ nodeInfo$PrimType$Boolean$ = NodeInfo$.MODULE$.Boolean();
                NodeInfo.Kind kind5 = kind;
                if (!(nodeInfo$PrimType$Boolean$ != null ? !nodeInfo$PrimType$Boolean$.equals(kind5) : kind5 != null)) {
                    if (!(value instanceof Boolean)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[scala.Boolean]");
                    }
                    return;
                }
                NodeInfo$PrimType$Byte$ nodeInfo$PrimType$Byte$ = NodeInfo$.MODULE$.Byte();
                NodeInfo.Kind kind6 = kind;
                if (!(nodeInfo$PrimType$Byte$ != null ? !nodeInfo$PrimType$Byte$.equals(kind6) : kind6 != null)) {
                    if (!(value instanceof Byte)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Byte]");
                    }
                    return;
                }
                NodeInfo$PrimType$UnsignedByte$ nodeInfo$PrimType$UnsignedByte$ = NodeInfo$.MODULE$.UnsignedByte();
                NodeInfo.Kind kind7 = kind;
                if (!(nodeInfo$PrimType$UnsignedByte$ != null ? !nodeInfo$PrimType$UnsignedByte$.equals(kind7) : kind7 != null)) {
                    if (!(value instanceof Short)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Short]");
                    }
                    return;
                }
                NodeInfo$PrimType$Short$ nodeInfo$PrimType$Short$ = NodeInfo$.MODULE$.Short();
                NodeInfo.Kind kind8 = kind;
                if (!(nodeInfo$PrimType$Short$ != null ? !nodeInfo$PrimType$Short$.equals(kind8) : kind8 != null)) {
                    if (!(value instanceof Short)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Short]");
                    }
                    return;
                }
                NodeInfo$PrimType$UnsignedShort$ nodeInfo$PrimType$UnsignedShort$ = NodeInfo$.MODULE$.UnsignedShort();
                NodeInfo.Kind kind9 = kind;
                if (!(nodeInfo$PrimType$UnsignedShort$ != null ? !nodeInfo$PrimType$UnsignedShort$.equals(kind9) : kind9 != null)) {
                    if (!(value instanceof Integer)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Integer]");
                    }
                    return;
                }
                NodeInfo$PrimType$Int$ nodeInfo$PrimType$Int$ = NodeInfo$.MODULE$.Int();
                NodeInfo.Kind kind10 = kind;
                if (!(nodeInfo$PrimType$Int$ != null ? !nodeInfo$PrimType$Int$.equals(kind10) : kind10 != null)) {
                    if (!(value instanceof Integer)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Integer]");
                    }
                    return;
                }
                NodeInfo$PrimType$UnsignedInt$ nodeInfo$PrimType$UnsignedInt$ = NodeInfo$.MODULE$.UnsignedInt();
                NodeInfo.Kind kind11 = kind;
                if (!(nodeInfo$PrimType$UnsignedInt$ != null ? !nodeInfo$PrimType$UnsignedInt$.equals(kind11) : kind11 != null)) {
                    if (!(value instanceof Long)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Long]");
                    }
                    return;
                }
                NodeInfo$PrimType$Long$ nodeInfo$PrimType$Long$ = NodeInfo$.MODULE$.Long();
                NodeInfo.Kind kind12 = kind;
                if (!(nodeInfo$PrimType$Long$ != null ? !nodeInfo$PrimType$Long$.equals(kind12) : kind12 != null)) {
                    if (!(value instanceof Long)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Long]");
                    }
                    return;
                }
                NodeInfo$PrimType$UnsignedLong$ nodeInfo$PrimType$UnsignedLong$ = NodeInfo$.MODULE$.UnsignedLong();
                NodeInfo.Kind kind13 = kind;
                if (!(nodeInfo$PrimType$UnsignedLong$ != null ? !nodeInfo$PrimType$UnsignedLong$.equals(kind13) : kind13 != null)) {
                    if (!(value instanceof BigInteger)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.math.BigInteger]");
                    }
                    return;
                }
                NodeInfo$PrimType$Integer$ nodeInfo$PrimType$Integer$ = NodeInfo$.MODULE$.Integer();
                NodeInfo.Kind kind14 = kind;
                if (!(nodeInfo$PrimType$Integer$ != null ? !nodeInfo$PrimType$Integer$.equals(kind14) : kind14 != null)) {
                    if (!(value instanceof BigInteger)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.math.BigInteger]");
                    }
                    return;
                }
                NodeInfo$PrimType$NonNegativeInteger$ nodeInfo$PrimType$NonNegativeInteger$ = NodeInfo$.MODULE$.NonNegativeInteger();
                NodeInfo.Kind kind15 = kind;
                if (!(nodeInfo$PrimType$NonNegativeInteger$ != null ? !nodeInfo$PrimType$NonNegativeInteger$.equals(kind15) : kind15 != null)) {
                    if (!(value instanceof BigInteger)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.math.BigInteger]");
                    }
                    return;
                }
                NodeInfo$PrimType$Float$ nodeInfo$PrimType$Float$ = NodeInfo$.MODULE$.Float();
                NodeInfo.Kind kind16 = kind;
                if (!(nodeInfo$PrimType$Float$ != null ? !nodeInfo$PrimType$Float$.equals(kind16) : kind16 != null)) {
                    if (!(value instanceof Float)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Float]");
                    }
                    return;
                }
                NodeInfo$PrimType$Double$ nodeInfo$PrimType$Double$ = NodeInfo$.MODULE$.Double();
                NodeInfo.Kind kind17 = kind;
                if (!(nodeInfo$PrimType$Double$ != null ? !nodeInfo$PrimType$Double$.equals(kind17) : kind17 != null)) {
                    if (!(value instanceof Double)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.lang.Double]");
                    }
                    return;
                }
                NodeInfo$PrimType$Decimal$ nodeInfo$PrimType$Decimal$ = NodeInfo$.MODULE$.Decimal();
                NodeInfo.Kind kind18 = kind;
                if (!(nodeInfo$PrimType$Decimal$ != null ? !nodeInfo$PrimType$Decimal$.equals(kind18) : kind18 != null)) {
                    if (!(value instanceof BigDecimal)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.math.BigDecimal]");
                    }
                    return;
                }
                NodeInfo$PrimType$HexBinary$ nodeInfo$PrimType$HexBinary$ = NodeInfo$.MODULE$.HexBinary();
                NodeInfo.Kind kind19 = kind;
                if (!(nodeInfo$PrimType$HexBinary$ != null ? !nodeInfo$PrimType$HexBinary$.equals(kind19) : kind19 != null)) {
                    if (!(value instanceof byte[])) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[scala.Array[scala.Byte]]");
                    }
                    return;
                }
                NodeInfo$PrimType$AnyURI$ nodeInfo$PrimType$AnyURI$ = NodeInfo$.MODULE$.AnyURI();
                NodeInfo.Kind kind20 = kind;
                if (!(nodeInfo$PrimType$AnyURI$ != null ? !nodeInfo$PrimType$AnyURI$.equals(kind20) : kind20 != null)) {
                    if (!(value instanceof URI)) {
                        throw Assert$.MODULE$.abort("Invariant broken: value.isInstanceOf[java.net.URI]");
                    }
                    return;
                }
                return;
            }
            return;
        }
    }
}

