/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.daffodil.api.DFDLPrimType;
import org.apache.daffodil.api.infoset.InfosetArray;
import org.apache.daffodil.api.infoset.InfosetComplexElement;
import org.apache.daffodil.api.infoset.InfosetElement;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.api.infoset.InfosetSimpleElement;
import org.apache.daffodil.lib.util.Indentable;
import org.apache.daffodil.lib.util.MStackOfBoolean;
import org.apache.daffodil.lib.util.MStackOfBoolean$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class JsonInfosetOutputter
extends InfosetOutputter
implements Indentable {
    private int indentSize;
    private char indentChar;
    private String org$apache$daffodil$lib$util$Indentable$$indentString;
    private int org$apache$daffodil$lib$util$Indentable$$indentLength;
    private final BufferedWriter writer;
    private final boolean pretty;
    private final MStackOfBoolean isFirstChildStack;
    private final JsonStringEncoder stringEncoder;

    private JsonInfosetOutputter(BufferedWriter writer, boolean pretty) {
        this.writer = writer;
        this.pretty = pretty;
        Indentable.$init$(this);
        this.isFirstChildStack = MStackOfBoolean$.MODULE$.apply();
        this.stringEncoder = JsonStringEncoder.getInstance();
        Statics.releaseFence();
    }

    @Override
    public int indentSize() {
        return this.indentSize;
    }

    @Override
    public char indentChar() {
        return this.indentChar;
    }

    @Override
    public String org$apache$daffodil$lib$util$Indentable$$indentString() {
        return this.org$apache$daffodil$lib$util$Indentable$$indentString;
    }

    @Override
    public int org$apache$daffodil$lib$util$Indentable$$indentLength() {
        return this.org$apache$daffodil$lib$util$Indentable$$indentLength;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$$indentString_$eq(String x$1) {
        this.org$apache$daffodil$lib$util$Indentable$$indentString = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$$indentLength_$eq(int x$1) {
        this.org$apache$daffodil$lib$util$Indentable$$indentLength = x$1;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$_setter_$indentSize_$eq(int x$0) {
        this.indentSize = x$0;
    }

    @Override
    public void org$apache$daffodil$lib$util$Indentable$_setter_$indentChar_$eq(char x$0) {
        this.indentChar = x$0;
    }

    public JsonInfosetOutputter(OutputStream os, boolean pretty) {
        this(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)), pretty);
    }

    @Override
    public void reset() {
        this.isFirstChildStack.clear();
        this.resetIndentation();
    }

    private void startNode() {
        if (BoxesRunTime.unboxToBoolean(this.isFirstChildStack.top())) {
            this.isFirstChildStack.pop();
            this.isFirstChildStack.push(BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            this.writer.write(44);
        }
        if (this.pretty) {
            this.writer.newLine();
        }
        if (this.pretty) {
            this.outputIndentation(this.writer);
            return;
        }
    }

    private void startElement(InfosetElement element) {
        if (!element.metadata().isArray()) {
            this.writer.write(34);
            this.writer.write(element.metadata().name());
            this.writer.write("\": ");
            return;
        }
    }

    private void prepareForChildren() {
        this.incrementIndentation();
        this.isFirstChildStack.push(BoxesRunTime.boxToBoolean((boolean)true));
    }

    private void endNodeWithChildren() {
        this.isFirstChildStack.pop();
        if (this.pretty) {
            this.writer.newLine();
        }
        this.decrementIndentation();
        if (this.pretty) {
            this.outputIndentation(this.writer);
            return;
        }
    }

    @Override
    public void startSimple(InfosetSimpleElement simple) {
        this.startNode();
        this.startElement(simple);
        if (!simple.isNilled()) {
            String text;
            DFDLPrimType dFDLPrimType = simple.metadata().dfdlType();
            DFDLPrimType dFDLPrimType2 = DFDLPrimType.String;
            String string = !(dFDLPrimType != null ? !((Object)((Object)dFDLPrimType)).equals((Object)dFDLPrimType2) : dFDLPrimType2 != null) ? new String(this.stringEncoder.quoteAsString(simple.getText())) : (text = simple.getText());
            if (this.needsQuote(simple)) {
                this.writer.write(34);
                this.writer.write(text);
                this.writer.write(34);
                return;
            }
            this.writer.write(text);
            return;
        }
        this.writer.write("null");
    }

    private boolean needsQuote(InfosetSimpleElement simple) {
        DFDLPrimType dFDLPrimType = simple.metadata().dfdlType();
        DFDLPrimType dFDLPrimType2 = DFDLPrimType.String;
        DFDLPrimType dFDLPrimType3 = dFDLPrimType;
        if (!(dFDLPrimType2 != null ? !((Object)((Object)dFDLPrimType2)).equals((Object)dFDLPrimType3) : dFDLPrimType3 != null)) {
            return true;
        }
        DFDLPrimType dFDLPrimType4 = DFDLPrimType.HexBinary;
        DFDLPrimType dFDLPrimType5 = dFDLPrimType;
        if (!(dFDLPrimType4 != null ? !((Object)((Object)dFDLPrimType4)).equals((Object)dFDLPrimType5) : dFDLPrimType5 != null)) {
            return true;
        }
        DFDLPrimType dFDLPrimType6 = DFDLPrimType.AnyURI;
        DFDLPrimType dFDLPrimType7 = dFDLPrimType;
        if (!(dFDLPrimType6 != null ? !((Object)((Object)dFDLPrimType6)).equals((Object)dFDLPrimType7) : dFDLPrimType7 != null)) {
            return true;
        }
        DFDLPrimType dFDLPrimType8 = DFDLPrimType.DateTime;
        DFDLPrimType dFDLPrimType9 = dFDLPrimType;
        if (!(dFDLPrimType8 != null ? !((Object)((Object)dFDLPrimType8)).equals((Object)dFDLPrimType9) : dFDLPrimType9 != null)) {
            return true;
        }
        DFDLPrimType dFDLPrimType10 = DFDLPrimType.Date;
        DFDLPrimType dFDLPrimType11 = dFDLPrimType;
        if (!(dFDLPrimType10 != null ? !((Object)((Object)dFDLPrimType10)).equals((Object)dFDLPrimType11) : dFDLPrimType11 != null)) {
            return true;
        }
        DFDLPrimType dFDLPrimType12 = DFDLPrimType.Time;
        DFDLPrimType dFDLPrimType13 = dFDLPrimType;
        if (!(dFDLPrimType12 != null ? !((Object)((Object)dFDLPrimType12)).equals((Object)dFDLPrimType13) : dFDLPrimType13 != null)) {
            return true;
        }
        DFDLPrimType dFDLPrimType14 = DFDLPrimType.Double;
        DFDLPrimType dFDLPrimType15 = dFDLPrimType;
        if (!(dFDLPrimType14 != null ? !((Object)((Object)dFDLPrimType14)).equals((Object)dFDLPrimType15) : dFDLPrimType15 != null)) {
            Double d = simple.getDouble();
            return d.isInfinite() || d.isNaN();
        }
        DFDLPrimType dFDLPrimType16 = DFDLPrimType.Float;
        DFDLPrimType dFDLPrimType17 = dFDLPrimType;
        if (!(dFDLPrimType16 != null ? !((Object)((Object)dFDLPrimType16)).equals((Object)dFDLPrimType17) : dFDLPrimType17 != null)) {
            Float f = simple.getFloat();
            return f.isInfinite() || f.isNaN();
        }
        return false;
    }

    @Override
    public void endSimple(InfosetSimpleElement se) {
    }

    @Override
    public void startComplex(InfosetComplexElement complex) {
        this.startNode();
        this.startElement(complex);
        if (!complex.isNilled()) {
            this.writer.write(123);
            this.prepareForChildren();
            return;
        }
        this.writer.write("null");
    }

    @Override
    public void endComplex(InfosetComplexElement complex) {
        if (!complex.isNilled()) {
            this.endNodeWithChildren();
            this.writer.write(125);
            return;
        }
    }

    @Override
    public void startArray(InfosetArray array) {
        this.startNode();
        this.writer.write(34);
        this.writer.write(array.metadata().name());
        this.writer.write("\": [");
        this.prepareForChildren();
    }

    @Override
    public void endArray(InfosetArray array) {
        this.endNodeWithChildren();
        this.writer.write(93);
    }

    @Override
    public void startDocument() {
        this.writer.write(123);
        this.prepareForChildren();
    }

    @Override
    public void endDocument() {
        this.endNodeWithChildren();
        this.writer.write(125);
        if (this.pretty) {
            this.writer.newLine();
        }
        this.writer.flush();
    }
}

