/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.Serializable;
import java.util.Map;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.IllegalContentWhereEventExpected;
import org.apache.daffodil.runtime1.infoset.InvalidInfosetException;
import org.apache.daffodil.runtime1.infoset.IterableNodeList;
import org.apache.daffodil.runtime1.infoset.NonTextFoundInSimpleContentException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public class W3CDOMInfosetInputter
extends InfosetInputter {
    private final MStackOf<Tuple2<Element, Iterator<Node>>> stack;
    private boolean doStartEvent;

    /*
     * WARNING - void declaration
     */
    public W3CDOMInfosetInputter(Document doc) {
        void var2_2;
        MStackOf<Tuple2> s = new MStackOf<Tuple2>();
        IterableNodeList iterator = new IterableNodeList(doc.getChildNodes());
        if (!iterator.hasNext()) {
            throw new InvalidInfosetException("Document does not contain a root element");
        }
        s.push(Tuple2$.MODULE$.apply(null, (Object)iterator));
        this.stack = var2_2;
        this.doStartEvent = true;
    }

    @Override
    public Daffodil.InfosetInputterEventType getEventType() {
        if (this.stack.top()._1() == null) {
            if (this.doStartEvent) {
                return Daffodil.InfosetInputterEventType.StartDocument;
            }
            return Daffodil.InfosetInputterEventType.EndDocument;
        }
        if (this.doStartEvent) {
            return Daffodil.InfosetInputterEventType.StartElement;
        }
        return Daffodil.InfosetInputterEventType.EndElement;
    }

    @Override
    public String getLocalName() {
        if (((Node)this.stack.top()._1()).getNamespaceURI() == null) {
            return ((Node)this.stack.top()._1()).getNodeName();
        }
        return ((Node)this.stack.top()._1()).getLocalName();
    }

    @Override
    public boolean getSupportsNamespaces() {
        return true;
    }

    @Override
    public String getNamespaceURI() {
        return ((Node)this.stack.top()._1()).getNamespaceURI();
    }

    @Override
    public String getSimpleText(NodeInfo.Kind primType, Map<String, String> runtimeProperties) {
        String string;
        if (((Iterator)this.stack.top()._2()).hasNext()) {
            Node child = (Node)((Iterator)this.stack.top()._2()).next();
            if (((Iterator)this.stack.top()._2()).hasNext()) {
                throw new NonTextFoundInSimpleContentException(((Node)this.stack.top()._1()).getNodeName());
            }
            Node node = child;
            if (!(node instanceof Text)) {
                throw new NonTextFoundInSimpleContentException(((Node)this.stack.top()._1()).getNodeName());
            }
            Text t = (Text)node;
            String text = t.getWholeText();
            string = primType instanceof NodeInfo.PrimType.StringKind ? XMLUtils$.MODULE$.remapPUAToXMLIllegalCharacters(text) : text;
        } else {
            string = "";
        }
        String text = string;
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean isNilled() {
        Boolean bl;
        String nilAttrValue;
        Element elem;
        block11: {
            block10: {
                elem = (Element)this.stack.top()._1();
                String string = nilAttrValue = elem.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                String string2 = "";
                if (string == null) {
                    if (string2 == null) return null;
                } else if (string.equals(string2)) {
                    return null;
                }
                String string3 = nilAttrValue;
                String string4 = "true";
                if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block10;
                String string5 = nilAttrValue;
                String string6 = "1";
                if (string5 != null ? !string5.equals(string6) : string6 != null) break block11;
            }
            bl = Predef$.MODULE$.boolean2Boolean(true);
            return bl;
        }
        String string = nilAttrValue;
        String string7 = "false";
        if (string == null ? string7 != null : !string.equals(string7)) {
            String string8 = nilAttrValue;
            String string9 = "0";
            if (string8 == null) {
                if (string9 != null) {
                    throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilAttrValue + "' for element " + elem.getNodeName());
                }
            } else if (!string8.equals(string9)) throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilAttrValue + "' for element " + elem.getNodeName());
        }
        bl = Predef$.MODULE$.boolean2Boolean(false);
        return bl;
    }

    @Override
    public boolean hasNext() {
        boolean atDocumentEnd = this.stack.top()._1() == null && !this.doStartEvent;
        return !atDocumentEnd;
    }

    @Override
    public void fini() {
        this.stack.clear();
    }

    private boolean tryDescend() {
        boolean descended = false;
        while (((Iterator)this.stack.top()._2()).hasNext() && !descended) {
            Text t;
            Node node = (Node)((Iterator)this.stack.top()._2()).next();
            if (node instanceof Element) {
                Element e = (Element)node;
                this.stack.push((Tuple2<Element, Iterator<Node>>)Tuple2$.MODULE$.apply((Object)e, (Object)new IterableNodeList(e.getChildNodes())));
                descended = true;
                continue;
            }
            if (node instanceof Text && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((t = (Text)node).getWholeText()), (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1)))) || node instanceof ProcessingInstruction || node instanceof Comment) continue;
            Node n = node;
            throw new IllegalContentWhereEventExpected("Found " + n.getNodeName());
        }
        return descended;
    }

    @Override
    public void next() {
        if (this.tryDescend()) {
            this.doStartEvent = true;
            return;
        }
        if (this.doStartEvent) {
            this.doStartEvent = false;
            return;
        }
        this.stack.pop();
        if (this.tryDescend()) {
            this.doStartEvent = true;
            return;
        }
    }
}

