/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.nio.channels.WritableByteChannel;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Coroutine;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.MainCoroutine;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.SAXInfosetEvent;
import org.apache.daffodil.runtime1.infoset.SAXInfosetInputter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.xml.NamespaceBinding;
import scala.xml.NamespaceBinding$;
import scala.xml.TopScope$;

public class DaffodilUnparseContentHandlerImpl
extends MainCoroutine<Maybe<Either<Exception, DFDL.UnparseResult>>>
implements DFDL.DaffodilUnparseContentHandler {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(DaffodilUnparseContentHandlerImpl.class.getDeclaredField("batchedInfosetEvents$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DaffodilUnparseContentHandlerImpl.class.getDeclaredField("prefixMappingTrackingStack$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DaffodilUnparseContentHandlerImpl.class.getDeclaredField("characterData$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaffodilUnparseContentHandlerImpl.class.getDeclaredField("inputter$lzy1"));
    private final DFDL.DataProcessor dp;
    private WritableByteChannel output;
    private volatile Object inputter$lzy1;
    private volatile Object characterData$lzy1;
    private NamespaceBinding prefixMapping;
    private volatile Object prefixMappingTrackingStack$lzy1;
    private volatile Object batchedInfosetEvents$lzy1;
    private int currentIndex;
    private boolean contentHandlerPrefixMappingUsed;
    private Object unparseResult;
    private boolean resolveRelativeInfosetBlobURIs;

    public DaffodilUnparseContentHandlerImpl(DFDL.DataProcessor dp, WritableByteChannel output) {
        this.dp = dp;
        this.output = output;
        this.prefixMapping = TopScope$.MODULE$;
        this.currentIndex = 0;
        this.contentHandlerPrefixMappingUsed = false;
        this.unparseResult = Maybe$.MODULE$.Nope();
        this.resolveRelativeInfosetBlobURIs = false;
    }

    private SAXInfosetInputter inputter() {
        Object object = this.inputter$lzy1;
        if (object instanceof SAXInfosetInputter) {
            return (SAXInfosetInputter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SAXInfosetInputter)this.inputter$lzyINIT1();
    }

    private Object inputter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.inputter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SAXInfosetInputter sAXInfosetInputter = null;
                    try {
                        sAXInfosetInputter = new SAXInfosetInputter(this, this.dp, this.output, this.resolveRelativeInfosetBlobURIs);
                        object2 = sAXInfosetInputter == null ? LazyVals.NullValue$.MODULE$ : sAXInfosetInputter;
                        this.output = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.inputter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sAXInfosetInputter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private StringBuilder characterData() {
        Object object = this.characterData$lzy1;
        if (object instanceof StringBuilder) {
            return (StringBuilder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (StringBuilder)this.characterData$lzyINIT1();
    }

    private Object characterData$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.characterData$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    StringBuilder stringBuilder = null;
                    try {
                        stringBuilder = new StringBuilder();
                        object2 = stringBuilder == null ? LazyVals.NullValue$.MODULE$ : stringBuilder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.characterData$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return stringBuilder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private MStackOf<NamespaceBinding> prefixMappingTrackingStack() {
        Object object = this.prefixMappingTrackingStack$lzy1;
        if (object instanceof MStackOf) {
            return (MStackOf)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MStackOf)this.prefixMappingTrackingStack$lzyINIT1();
    }

    private Object prefixMappingTrackingStack$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.prefixMappingTrackingStack$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MStackOf mStackOf = null;
                    try {
                        mStackOf = new MStackOf();
                        object2 = mStackOf == null ? LazyVals.NullValue$.MODULE$ : mStackOf;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.prefixMappingTrackingStack$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mStackOf;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private SAXInfosetEvent[] batchedInfosetEvents() {
        Object object = this.batchedInfosetEvents$lzy1;
        if (object instanceof SAXInfosetEvent[]) {
            return (SAXInfosetEvent[])object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SAXInfosetEvent[])this.batchedInfosetEvents$lzyINIT1();
    }

    private Object batchedInfosetEvents$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.batchedInfosetEvents$lzy1) == null) {
                    int batchSize;
                    SAXInfosetEvent[] sAXInfosetEventArray;
                    SAXInfosetEvent[] sAXInfosetEventArray2;
                    block8: {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        sAXInfosetEventArray2 = null;
                        sAXInfosetEventArray = null;
                        try {
                            batchSize = this.dp.tunables().saxUnparseEventBatchSize();
                            if (batchSize > 0) break block8;
                            throw Assert$.MODULE$.abort("Invariant broken: invalid saxUnparseEventBatchSize; minimum value is 1(batchSize.>(0))");
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, sAXInfosetEventArray2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.batchedInfosetEvents$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, sAXInfosetEventArray2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                    }
                    sAXInfosetEventArray = (SAXInfosetEvent[])Array$.MODULE$.fill(batchSize, DaffodilUnparseContentHandlerImpl::batchedInfosetEvents$lzyINIT1$$anonfun$1, ClassTag$.MODULE$.apply(SAXInfosetEvent.class));
                    sAXInfosetEventArray2 = sAXInfosetEventArray == null ? LazyVals.NullValue$.MODULE$ : sAXInfosetEventArray;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, (Object)sAXInfosetEventArray2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.batchedInfosetEvents$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, (Object)sAXInfosetEventArray2);
                        waiting.countDown();
                    }
                    return sAXInfosetEventArray;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private SAXInfosetEvent currentEvent() {
        return this.batchedInfosetEvents()[this.currentIndex];
    }

    @Override
    public DFDL.UnparseResult getUnparseResult() {
        Object object = this.unparseResult;
        return (DFDL.UnparseResult)Maybe$.MODULE$.orNull$extension(object);
    }

    @Override
    public void enableResolutionOfRelativeInfosetBlobURIs() {
        this.resolveRelativeInfosetBlobURIs = true;
    }

    @Override
    public void startDocument() {
        this.currentEvent().eventType_$eq(Maybe$One$.MODULE$.apply(Daffodil.InfosetInputterEventType.StartDocument));
        this.currentEventIsFinished();
    }

    @Override
    public void endDocument() {
        this.currentEvent().eventType_$eq(Maybe$One$.MODULE$.apply(Daffodil.InfosetInputterEventType.EndDocument));
        this.currentEventIsFinished();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.contentHandlerPrefixMappingUsed = true;
        String string = prefix;
        String string2 = "";
        String pre = !(string != null ? !string.equals(string2) : string2 != null) ? null : prefix;
        this.prefixMapping = NamespaceBinding$.MODULE$.apply(pre, uri, this.prefixMapping);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.prefixMapping = this.prefixMapping.parent();
    }

    public void addPrefixMappingFromAttributes(Attributes atts) {
        int numAtts = atts.getLength();
        for (int i = 0; i < numAtts; ++i) {
            String qName;
            String string = qName = atts.getQName(i);
            String string2 = "xmlns";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.prefixMapping = NamespaceBinding$.MODULE$.apply(null, atts.getValue(i), this.prefixMapping);
                continue;
            }
            if (!qName.startsWith("xmlns:")) continue;
            String prefix = qName.substring(6);
            this.prefixMapping = NamespaceBinding$.MODULE$.apply(prefix, atts.getValue(i), this.prefixMapping);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        String nilValue;
        Object object = this.currentEvent().eventType();
        if (Maybe$.MODULE$.isDefined$extension(object)) {
            Object object2 = this.currentEvent().eventType();
            if ((Daffodil.InfosetInputterEventType)((Object)Maybe$.MODULE$.get$extension(object2)) != Daffodil.InfosetInputterEventType.StartElement) {
                throw Assert$.MODULE$.abort("Invariant broken: DaffodilUnparseContentHandlerImpl.this.currentEvent.eventType.get.eq(org.apache.daffodil.api.Daffodil.InfosetInputterEventType.StartElement)");
            }
            this.currentEventIsFinished();
        }
        this.currentEvent().eventType_$eq(Maybe$One$.MODULE$.apply(Daffodil.InfosetInputterEventType.StartElement));
        if (!this.contentHandlerPrefixMappingUsed) {
            this.prefixMappingTrackingStack().push(this.prefixMapping);
            this.addPrefixMappingFromAttributes(atts);
        }
        if ((nilValue = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null) {
            this.currentEvent().nilValue_$eq(Maybe$One$.MODULE$.apply(nilValue));
        }
        this.setLocalNameAndNamespaceUri(uri, localName, qName);
        this.checkMixedContent();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Object object = this.currentEvent().eventType();
        if (Maybe$.MODULE$.contains$extension(object, Daffodil.InfosetInputterEventType.StartElement)) {
            this.currentEvent().simpleText_$eq(Maybe$One$.MODULE$.apply(this.characterData().toString()));
            this.characterData().setLength(0);
            this.currentEventIsFinished();
        } else {
            this.checkMixedContent();
        }
        this.currentEvent().eventType_$eq(Maybe$One$.MODULE$.apply(Daffodil.InfosetInputterEventType.EndElement));
        this.setLocalNameAndNamespaceUri(uri, localName, qName);
        if (!this.contentHandlerPrefixMappingUsed) {
            this.prefixMapping = this.prefixMappingTrackingStack().pop();
        }
        this.currentEventIsFinished();
    }

    private void checkMixedContent() {
        if (this.characterData().nonEmpty()) {
            if (!Misc$.MODULE$.isAllWhitespace(this.characterData())) {
                this.currentEvent().mixedContent_$eq(Maybe$One$.MODULE$.apply(this.characterData().toString()));
            }
            this.characterData().setLength(0);
            return;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characterData().appendAll(ch, start, length);
    }

    private void currentEventIsFinished() {
        Object maybeUnparseResultOrException;
        Object object;
        if (this.currentIndex < this.batchedInfosetEvents().length - 1 && (Daffodil.InfosetInputterEventType)((Object)Maybe$.MODULE$.get$extension(object = this.currentEvent().eventType())) != Daffodil.InfosetInputterEventType.EndDocument) {
            ++this.currentIndex;
            if (!this.currentEvent().isEmpty()) {
                throw Assert$.MODULE$.abort("Invariant broken: DaffodilUnparseContentHandlerImpl.this.currentEvent.isEmpty");
            }
            return;
        }
        Object object2 = this.resume((Coroutine)this.inputter(), this.batchedInfosetEvents());
        Object object3 = maybeUnparseResultOrException = object2 == null ? null : ((Maybe)object2).v();
        if (Maybe$.MODULE$.isEmpty$extension(maybeUnparseResultOrException)) {
            this.currentIndex = 0;
            if (!this.currentEvent().isEmpty()) {
                throw Assert$.MODULE$.abort("Invariant broken: DaffodilUnparseContentHandlerImpl.this.currentEvent.isEmpty");
            }
            return;
        }
        Either either = (Either)Maybe$.MODULE$.get$extension(maybeUnparseResultOrException);
        if (either instanceof Right) {
            DFDL.UnparseResult ur = (DFDL.UnparseResult)((Right)either).value();
            this.unparseResult = Maybe$One$.MODULE$.apply(ur);
            if (((DFDL.Result)((Object)ur)).isError()) {
                throw new DFDL.DaffodilUnparseErrorSAXException(ur);
            }
            return;
        }
        if (either instanceof Left) {
            Exception e = (Exception)((Left)either).value();
            throw new DFDL.DaffodilUnhandledSAXException(e);
        }
        throw new MatchError((Object)either);
    }

    private void setLocalNameAndNamespaceUri(String uri, String localName, String qName) {
        Object object;
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(localName))) {
            object = Maybe$One$.MODULE$.apply(localName);
        } else if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(qName))) {
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])DaffodilUnparseContentHandlerImpl.qNameArr$1(lazyRef, qName));
            object = Maybe$One$.MODULE$.apply((String)ArrayOps$.MODULE$.last$extension(object2));
        } else {
            object = Maybe$.MODULE$.Nope();
        }
        Object maybelocalName = object;
        Object maybeNamespaceURI = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(uri)) ? Maybe$One$.MODULE$.apply(uri) : Maybe$.MODULE$.apply(this.prefixMapping.getURI(DaffodilUnparseContentHandlerImpl.qNamePrefix$1(lazyRef2, lazyRef, qName)));
        this.currentEvent().localName_$eq(maybelocalName);
        this.currentEvent().namespaceURI_$eq(maybeNamespaceURI);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    private static final SAXInfosetEvent batchedInfosetEvents$lzyINIT1$$anonfun$1() {
        return new SAXInfosetEvent();
    }

    private static final String[] qNameArr$lzyINIT1$1(LazyRef qNameArr$lzy1$1, String qName$1) {
        String[] stringArray;
        LazyRef lazyRef = qNameArr$lzy1$1;
        synchronized (lazyRef) {
            stringArray = (String[])(qNameArr$lzy1$1.initialized() ? qNameArr$lzy1$1.value() : qNameArr$lzy1$1.initialize((Object)qName$1.split(":")));
        }
        return stringArray;
    }

    private static final String[] qNameArr$1(LazyRef qNameArr$lzy1$2, String qName$2) {
        return qNameArr$lzy1$2.initialized() ? qNameArr$lzy1$2.value() : DaffodilUnparseContentHandlerImpl.qNameArr$lzyINIT1$1(qNameArr$lzy1$2, qName$2);
    }

    private static final String qNamePrefix$lzyINIT1$1(LazyRef qNamePrefix$lzy1$1, LazyRef qNameArr$lzy1$3, String qName$3) {
        String string;
        LazyRef lazyRef = qNamePrefix$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (qNamePrefix$lzy1$1.initialized()) {
                object = qNamePrefix$lzy1$1.value();
            } else {
                String string2;
                if (DaffodilUnparseContentHandlerImpl.qNameArr$1(qNameArr$lzy1$3, qName$3).length > 1) {
                    Object object2 = Predef$.MODULE$.refArrayOps((Object[])DaffodilUnparseContentHandlerImpl.qNameArr$1(qNameArr$lzy1$3, qName$3));
                    string2 = (String)ArrayOps$.MODULE$.head$extension(object2);
                } else {
                    string2 = null;
                }
                object = qNamePrefix$lzy1$1.initialize(string2);
            }
            string = (String)object;
        }
        return string;
    }

    private static final String qNamePrefix$1(LazyRef qNamePrefix$lzy1$2, LazyRef qNameArr$lzy1$4, String qName$4) {
        return (String)(qNamePrefix$lzy1$2.initialized() ? qNamePrefix$lzy1$2.value() : DaffodilUnparseContentHandlerImpl.qNamePrefix$lzyINIT1$1(qNamePrefix$lzy1$2, qNameArr$lzy1$4, qName$4));
    }
}

