/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.TextTruncationType;
import org.apache.daffodil.runtime1.processors.TextTruncationType$ErrorIfNeeded$;
import org.apache.daffodil.runtime1.processors.TextTruncationType$Left$;
import org.apache.daffodil.runtime1.processors.TextTruncationType$None$;
import org.apache.daffodil.runtime1.processors.TextTruncationType$Right$;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.StringSpecifiedLengthUnparserBase;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public abstract class StringSpecifiedLengthUnparserTruncateBase
extends StringSpecifiedLengthUnparserBase {
    private final TextTruncationType.Type stringTruncationType;

    public StringSpecifiedLengthUnparserTruncateBase(TextTruncationType.Type stringTruncationType, ElementRuntimeData erd) {
        this.stringTruncationType = stringTruncationType;
        super(erd);
        if (stringTruncationType == TextTruncationType$None$.MODULE$) {
            throw Assert$.MODULE$.usageError("StringSpecifiedLengthUnparserTruncateBase.this.stringTruncationType.ne(org.apache.daffodil.runtime1.processors.TextTruncationType.None)");
        }
    }

    private ElementRuntimeData erd$accessor() {
        return super.erd();
    }

    public final String truncateByJustification(UState ustate, String str, long nChars) {
        String string;
        if (!this.erd$accessor().optTruncateSpecifiedLengthString().isDefined()) {
            throw Assert$.MODULE$.abort("Invariant broken: StringSpecifiedLengthUnparserTruncateBase.this.erd.optTruncateSpecifiedLengthString.isDefined");
        }
        int nCharsToTrim = str.length() - (int)nChars;
        TextTruncationType.Type type = this.stringTruncationType;
        if (TextTruncationType$Right$.MODULE$.equals(type)) {
            string = str.substring(nCharsToTrim);
        } else if (TextTruncationType$Left$.MODULE$.equals(type)) {
            string = str.substring(0, str.length() - nCharsToTrim);
        } else {
            if (TextTruncationType$ErrorIfNeeded$.MODULE$.equals(type)) {
                throw this.UE(ustate, "Truncation required but disallowed when dfdl:truncateSpecifiedLengthString=\"yes\" and dfdl:textStringJustification=\"center\"", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            if (TextTruncationType$None$.MODULE$.equals(type)) {
                throw Assert$.MODULE$.invariantFailed("cannot be TextTruncationType.None");
            }
            throw new MatchError((Object)type);
        }
        String result = string;
        return result;
    }
}

