/*
 * Decompiled with CFR 0.152.
 */
package passera.unsigned;

import passera.unsigned.UByte;
import passera.unsigned.UByte$;
import passera.unsigned.UInt;
import passera.unsigned.UInt$;
import passera.unsigned.ULong;
import passera.unsigned.ULong$;
import passera.unsigned.UShort;
import passera.unsigned.UShort$;
import passera.unsigned.package$;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.Range;
import scala.math.Integral;
import scala.math.Ordering;
import scala.runtime.RichInt$;

public final class package {
    public static DoubleOps doubleOps(double d) {
        return package$.MODULE$.doubleOps(d);
    }

    public static FloatOps floatOps(float f) {
        return package$.MODULE$.floatOps(f);
    }

    public static RichUInt richUInt(int n) {
        return package$.MODULE$.richUInt(n);
    }

    public static RicherUInt richerUInt(int n) {
        return package$.MODULE$.richerUInt(n);
    }

    public static SignedIntOps signedIntOps(int n) {
        return package$.MODULE$.signedIntOps(n);
    }

    public static SignedLongOps signedLongOps(long l) {
        return package$.MODULE$.signedLongOps(l);
    }

    public static SignedRichIntOps signedRichIntOps(int n) {
        return package$.MODULE$.signedRichIntOps(n);
    }

    public static int ubyte2uint(byte by) {
        return package$.MODULE$.ubyte2uint(by);
    }

    public static long ubyte2ulong(byte by) {
        return package$.MODULE$.ubyte2ulong(by);
    }

    public static long uint2ulong(int n) {
        return package$.MODULE$.uint2ulong(n);
    }

    public static int ushort2uint(short s) {
        return package$.MODULE$.ushort2uint(s);
    }

    public static long ushort2ulong(short s) {
        return package$.MODULE$.ushort2ulong(s);
    }

    public static class DoubleOps {
        private final double x;

        public DoubleOps(double x) {
            this.x = x;
        }

        public byte toUByte() {
            return UByte$.MODULE$.apply((byte)this.x);
        }

        public short toUShort() {
            return UShort$.MODULE$.apply((short)this.x);
        }

        public int toUInt() {
            return UInt$.MODULE$.apply((int)this.x);
        }

        public long toULong() {
            return ULong$.MODULE$.apply((long)this.x);
        }

        public double $plus(int y) {
            return this.x + new UInt(y).toDouble();
        }

        public double $minus(int y) {
            return this.x - new UInt(y).toDouble();
        }

        public double $times(int y) {
            return this.x * new UInt(y).toDouble();
        }

        public double $div(int y) {
            return this.x / new UInt(y).toDouble();
        }

        public double $percent(int y) {
            return this.x % new UInt(y).toDouble();
        }
    }

    public static class FloatOps {
        private final float x;

        public FloatOps(float x) {
            this.x = x;
        }

        public byte toUByte() {
            return UByte$.MODULE$.apply((byte)this.x);
        }

        public short toUShort() {
            return UShort$.MODULE$.apply((short)this.x);
        }

        public int toUInt() {
            return UInt$.MODULE$.apply((int)this.x);
        }

        public long toULong() {
            return ULong$.MODULE$.apply((long)this.x);
        }

        public float $plus(int y) {
            return this.x + new UInt(y).toFloat();
        }

        public float $minus(int y) {
            return this.x - new UInt(y).toFloat();
        }

        public float $times(int y) {
            return this.x * new UInt(y).toFloat();
        }

        public float $div(int y) {
            return this.x / new UInt(y).toFloat();
        }

        public float $percent(int y) {
            return this.x % new UInt(y).toFloat();
        }
    }

    public static class RichUInt {
        private final int x;

        public RichUInt(int x) {
            this.x = x;
        }

        public Range.Inclusive to(int y) {
            return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(new UInt(this.x).toInt()), new UInt(y).toInt());
        }

        public Range until(int y) {
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(new UInt(this.x).toInt()), new UInt(y).toInt());
        }

        public int compare(int y) {
            if (new UInt(this.x).$less(y)) {
                return 1;
            }
            if (new UInt(this.x).$greater(y)) {
                return -1;
            }
            return 0;
        }

        public int max(int y) {
            if (new UInt(this.x).$less(y)) {
                return y;
            }
            return this.x;
        }

        public int min(int y) {
            if (new UInt(this.x).$greater(y)) {
                return y;
            }
            return this.x;
        }

        public int $plus(int y) {
            return new UInt(this.x).toInt() + y;
        }

        public int $minus(int y) {
            return new UInt(this.x).toInt() - y;
        }

        public int $times(int y) {
            return new UInt(this.x).toInt() * y;
        }

        public int $div(int y) {
            return new UInt(this.x).toInt() / y;
        }

        public int $percent(int y) {
            return new UInt(this.x).toInt() % y;
        }

        public long $plus(long y) {
            return new UInt(this.x).toLong() + y;
        }

        public long $minus(long y) {
            return new UInt(this.x).toLong() - y;
        }

        public long $times(long y) {
            return new UInt(this.x).toLong() * y;
        }

        public long $div(long y) {
            return new UInt(this.x).toLong() / y;
        }

        public long $percent(long y) {
            return new UInt(this.x).toLong() % y;
        }

        public float $plus(float y) {
            return new UInt(this.x).toFloat() + y;
        }

        public float $minus(float y) {
            return new UInt(this.x).toFloat() - y;
        }

        public float $times(float y) {
            return new UInt(this.x).toFloat() * y;
        }

        public float $div(float y) {
            return new UInt(this.x).toFloat() / y;
        }

        public float $percent(float y) {
            return new UInt(this.x).toFloat() % y;
        }

        public double $plus(double y) {
            return new UInt(this.x).toDouble() + y;
        }

        public double $minus(double y) {
            return new UInt(this.x).toDouble() - y;
        }

        public double $times(double y) {
            return new UInt(this.x).toDouble() * y;
        }

        public double $div(double y) {
            return new UInt(this.x).toDouble() / y;
        }

        public double $percent(double y) {
            return new UInt(this.x).toDouble() % y;
        }

        public int abs() {
            return this.x;
        }
    }

    public static class RicherUInt {
        private final int rep;

        public RicherUInt(int rep) {
            this.rep = rep;
        }

        public int bitCount() {
            return Integer.bitCount(this.rep);
        }

        public int highestOneBit() {
            return Integer.highestOneBit(this.rep);
        }

        public int lowestOneBit() {
            return Integer.lowestOneBit(this.rep);
        }

        public int numberOfLeadingZeros() {
            return Integer.numberOfLeadingZeros(this.rep);
        }

        public int numberOfTrailingZeros() {
            return Integer.numberOfTrailingZeros(this.rep);
        }

        public int reverse() {
            return UInt$.MODULE$.apply(Integer.reverse(this.rep));
        }

        public int reverseBytes() {
            return UInt$.MODULE$.apply(Integer.reverseBytes(this.rep));
        }

        public int rotateLeft(int dist) {
            return UInt$.MODULE$.apply(Integer.rotateLeft(this.rep, dist));
        }

        public int rotateRight(int dist) {
            return UInt$.MODULE$.apply(Integer.rotateRight(this.rep, dist));
        }

        public int signum() {
            if (this.rep == 0) {
                return 0;
            }
            return 1;
        }
    }

    public static class SignedIntOps {
        private final int x;

        public SignedIntOps(int x) {
            this.x = x;
        }

        public byte toUByte() {
            return UByte$.MODULE$.apply((byte)(this.x & 0xFF));
        }

        public short toUShort() {
            return UShort$.MODULE$.apply((short)(this.x & 0xFFFF));
        }

        public int toUInt() {
            return UInt$.MODULE$.apply(this.x);
        }

        public long toULong() {
            return ULong$.MODULE$.apply(this.x);
        }

        public int $plus(byte y) {
            return this.x + new UByte(y).toInt();
        }

        public int $minus(byte y) {
            return this.x - new UByte(y).toInt();
        }

        public int $times(byte y) {
            return this.x * new UByte(y).toInt();
        }

        public int $div(byte y) {
            return this.x / new UByte(y).toInt();
        }

        public int $percent(byte y) {
            return this.x % new UByte(y).toInt();
        }

        public int $amp(byte y) {
            return this.x & new UByte(y).toInt();
        }

        public int $bar(byte y) {
            return this.x | new UByte(y).toInt();
        }

        public int $up(byte y) {
            return this.x ^ new UByte(y).toInt();
        }

        public int $plus(short y) {
            return this.x + new UShort(y).toInt();
        }

        public int $minus(short y) {
            return this.x - new UShort(y).toInt();
        }

        public int $times(short y) {
            return this.x * new UShort(y).toInt();
        }

        public int $div(short y) {
            return this.x / new UShort(y).toInt();
        }

        public int $percent(short y) {
            return this.x % new UShort(y).toInt();
        }

        public int $amp(short y) {
            return this.x & new UShort(y).toInt();
        }

        public int $bar(short y) {
            return this.x | new UShort(y).toInt();
        }

        public int $up(short y) {
            return this.x ^ new UShort(y).toInt();
        }

        public int $plus(int y) {
            return this.x + new UInt(y).toInt();
        }

        public int $minus(int y) {
            return this.x - new UInt(y).toInt();
        }

        public int $times(int y) {
            return this.x * new UInt(y).toInt();
        }

        public int $div(int y) {
            return this.x / new UInt(y).toInt();
        }

        public int $percent(int y) {
            return this.x % new UInt(y).toInt();
        }

        public int $amp(int y) {
            return this.x & new UInt(y).toInt();
        }

        public int $bar(int y) {
            return this.x | new UInt(y).toInt();
        }

        public int $up(int y) {
            return this.x ^ new UInt(y).toInt();
        }
    }

    public static class SignedLongOps {
        private final long x;

        public SignedLongOps(long x) {
            this.x = x;
        }

        public byte toUByte() {
            return UByte$.MODULE$.apply((byte)(this.x & 0xFFL));
        }

        public short toUShort() {
            return UShort$.MODULE$.apply((short)(this.x & 0xFFFFL));
        }

        public int toUInt() {
            return UInt$.MODULE$.apply((int)(this.x & 0xFFFFFFFFL));
        }

        public long toULong() {
            return ULong$.MODULE$.apply(this.x);
        }

        public long $plus(int y) {
            return this.x + new UInt(y).toLong();
        }

        public long $minus(int y) {
            return this.x - new UInt(y).toLong();
        }

        public long $times(int y) {
            return this.x * new UInt(y).toLong();
        }

        public long $div(int y) {
            return this.x / new UInt(y).toLong();
        }

        public long $percent(int y) {
            return this.x % new UInt(y).toLong();
        }

        public long $amp(int y) {
            return this.x & new UInt(y).toLong();
        }

        public long $bar(int y) {
            return this.x | new UInt(y).toLong();
        }

        public long $up(int y) {
            return this.x ^ new UInt(y).toLong();
        }
    }

    public static class SignedRichIntOps {
        private final int x;

        public SignedRichIntOps(int x) {
            this.x = x;
        }

        public Range.Inclusive to(int y) {
            return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.x), new UInt(y).toInt());
        }

        public Range until(int y) {
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.x), new UInt(y).toInt());
        }
    }

    public static interface UByteIsIntegral
    extends Integral<UByte> {
        public static byte plus$(UByteIsIntegral $this, byte x, byte y) {
            return $this.plus(x, y);
        }

        default public byte plus(byte x, byte y) {
            return new UInt(new UByte(x).$plus(y)).toUByte();
        }

        public static byte minus$(UByteIsIntegral $this, byte x, byte y) {
            return $this.minus(x, y);
        }

        default public byte minus(byte x, byte y) {
            return new UInt(new UByte(x).$minus(y)).toUByte();
        }

        public static byte times$(UByteIsIntegral $this, byte x, byte y) {
            return $this.times(x, y);
        }

        default public byte times(byte x, byte y) {
            return new UInt(new UByte(x).$times(y)).toUByte();
        }

        public static byte quot$(UByteIsIntegral $this, byte x, byte y) {
            return $this.quot(x, y);
        }

        default public byte quot(byte x, byte y) {
            return new UInt(new UByte(x).$div(y)).toUByte();
        }

        public static byte rem$(UByteIsIntegral $this, byte x, byte y) {
            return $this.rem(x, y);
        }

        default public byte rem(byte x, byte y) {
            return new UInt(new UByte(x).$percent(y)).toUByte();
        }

        public static byte negate$(UByteIsIntegral $this, byte x) {
            return $this.negate(x);
        }

        default public byte negate(byte x) {
            return new UInt(new UByte(x).unary_$minus()).toUByte();
        }

        public static byte fromInt$(UByteIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        default public byte fromInt(int x) {
            return UByte$.MODULE$.apply((byte)x);
        }

        public static int toInt$(UByteIsIntegral $this, byte x) {
            return $this.toInt(x);
        }

        default public int toInt(byte x) {
            return new UByte(x).toInt();
        }

        public static long toLong$(UByteIsIntegral $this, byte x) {
            return $this.toLong(x);
        }

        default public long toLong(byte x) {
            return new UByte(x).toLong();
        }

        public static float toFloat$(UByteIsIntegral $this, byte x) {
            return $this.toFloat(x);
        }

        default public float toFloat(byte x) {
            return new UByte(x).toFloat();
        }

        public static double toDouble$(UByteIsIntegral $this, byte x) {
            return $this.toDouble(x);
        }

        default public double toDouble(byte x) {
            return new UByte(x).toDouble();
        }
    }

    public static interface UByteOrdering
    extends Ordering<UByte> {
        public static int compare$(UByteOrdering $this, byte x, byte y) {
            return $this.compare(x, y);
        }

        default public int compare(byte x, byte y) {
            if (new UByte(x).$less(y)) {
                return -1;
            }
            if (x == y) {
                return 0;
            }
            return 1;
        }
    }

    public static interface UIntIsIntegral
    extends Integral<UInt> {
        public static int plus$(UIntIsIntegral $this, int x, int y) {
            return $this.plus(x, y);
        }

        default public int plus(int x, int y) {
            return new UInt(x).$plus(y);
        }

        public static int minus$(UIntIsIntegral $this, int x, int y) {
            return $this.minus(x, y);
        }

        default public int minus(int x, int y) {
            return new UInt(x).$minus(y);
        }

        public static int times$(UIntIsIntegral $this, int x, int y) {
            return $this.times(x, y);
        }

        default public int times(int x, int y) {
            return new UInt(x).$times(y);
        }

        public static int quot$(UIntIsIntegral $this, int x, int y) {
            return $this.quot(x, y);
        }

        default public int quot(int x, int y) {
            return new UInt(x).$div(y);
        }

        public static int rem$(UIntIsIntegral $this, int x, int y) {
            return $this.rem(x, y);
        }

        default public int rem(int x, int y) {
            return new UInt(x).$percent(y);
        }

        public static int negate$(UIntIsIntegral $this, int x) {
            return $this.negate(x);
        }

        default public int negate(int x) {
            return new UInt(x).unary_$minus();
        }

        public static int fromInt$(UIntIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        default public int fromInt(int x) {
            return UInt$.MODULE$.apply(x);
        }

        public static int toInt$(UIntIsIntegral $this, int x) {
            return $this.toInt(x);
        }

        default public int toInt(int x) {
            return new UInt(x).toInt();
        }

        public static long toLong$(UIntIsIntegral $this, int x) {
            return $this.toLong(x);
        }

        default public long toLong(int x) {
            return new UInt(x).toLong();
        }

        public static float toFloat$(UIntIsIntegral $this, int x) {
            return $this.toFloat(x);
        }

        default public float toFloat(int x) {
            return new UInt(x).toFloat();
        }

        public static double toDouble$(UIntIsIntegral $this, int x) {
            return $this.toDouble(x);
        }

        default public double toDouble(int x) {
            return new UInt(x).toDouble();
        }
    }

    public static interface UIntOrdering
    extends Ordering<UInt> {
        public static int compare$(UIntOrdering $this, int x, int y) {
            return $this.compare(x, y);
        }

        default public int compare(int x, int y) {
            if (new UInt(x).$less(y)) {
                return -1;
            }
            if (x == y) {
                return 0;
            }
            return 1;
        }
    }

    public static interface ULongIsIntegral
    extends Integral<ULong> {
        public static long plus$(ULongIsIntegral $this, long x, long y) {
            return $this.plus(x, y);
        }

        default public long plus(long x, long y) {
            return ULong$.MODULE$.$plus$extension(x, y);
        }

        public static long minus$(ULongIsIntegral $this, long x, long y) {
            return $this.minus(x, y);
        }

        default public long minus(long x, long y) {
            return ULong$.MODULE$.$minus$extension(x, y);
        }

        public static long times$(ULongIsIntegral $this, long x, long y) {
            return $this.times(x, y);
        }

        default public long times(long x, long y) {
            return ULong$.MODULE$.$times$extension(x, y);
        }

        public static long quot$(ULongIsIntegral $this, long x, long y) {
            return $this.quot(x, y);
        }

        default public long quot(long x, long y) {
            return ULong$.MODULE$.$div$extension(x, y);
        }

        public static long rem$(ULongIsIntegral $this, long x, long y) {
            return $this.rem(x, y);
        }

        default public long rem(long x, long y) {
            return ULong$.MODULE$.$percent$extension(x, y);
        }

        public static long negate$(ULongIsIntegral $this, long x) {
            return $this.negate(x);
        }

        default public long negate(long x) {
            return ULong$.MODULE$.unary_$minus$extension(x);
        }

        public static long fromInt$(ULongIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        default public long fromInt(int x) {
            return ULong$.MODULE$.apply(Int$.MODULE$.int2long(x));
        }

        public static int toInt$(ULongIsIntegral $this, long x) {
            return $this.toInt(x);
        }

        default public int toInt(long x) {
            return ULong$.MODULE$.toInt$extension(x);
        }

        public static long toLong$(ULongIsIntegral $this, long x) {
            return $this.toLong(x);
        }

        default public long toLong(long x) {
            return ULong$.MODULE$.toLong$extension(x);
        }

        public static float toFloat$(ULongIsIntegral $this, long x) {
            return $this.toFloat(x);
        }

        default public float toFloat(long x) {
            return ULong$.MODULE$.toFloat$extension(x);
        }

        public static double toDouble$(ULongIsIntegral $this, long x) {
            return $this.toDouble(x);
        }

        default public double toDouble(long x) {
            return ULong$.MODULE$.toDouble$extension(x);
        }
    }

    public static interface ULongOrdering
    extends Ordering<ULong> {
        public static int compare$(ULongOrdering $this, long x, long y) {
            return $this.compare(x, y);
        }

        default public int compare(long x, long y) {
            if (ULong$.MODULE$.$less$extension(x, y)) {
                return -1;
            }
            if (x == y) {
                return 0;
            }
            return 1;
        }
    }

    public static interface UShortIsIntegral
    extends Integral<UShort> {
        public static short plus$(UShortIsIntegral $this, short x, short y) {
            return $this.plus(x, y);
        }

        default public short plus(short x, short y) {
            return new UInt(new UShort(x).$plus(y)).toUShort();
        }

        public static short minus$(UShortIsIntegral $this, short x, short y) {
            return $this.minus(x, y);
        }

        default public short minus(short x, short y) {
            return new UInt(new UShort(x).$minus(y)).toUShort();
        }

        public static short times$(UShortIsIntegral $this, short x, short y) {
            return $this.times(x, y);
        }

        default public short times(short x, short y) {
            return new UInt(new UShort(x).$times(y)).toUShort();
        }

        public static short quot$(UShortIsIntegral $this, short x, short y) {
            return $this.quot(x, y);
        }

        default public short quot(short x, short y) {
            return new UInt(new UShort(x).$div(y)).toUShort();
        }

        public static short rem$(UShortIsIntegral $this, short x, short y) {
            return $this.rem(x, y);
        }

        default public short rem(short x, short y) {
            return new UInt(new UShort(x).$percent(y)).toUShort();
        }

        public static short negate$(UShortIsIntegral $this, short x) {
            return $this.negate(x);
        }

        default public short negate(short x) {
            return new UInt(new UShort(x).unary_$minus()).toUShort();
        }

        public static short fromInt$(UShortIsIntegral $this, int x) {
            return $this.fromInt(x);
        }

        default public short fromInt(int x) {
            return UShort$.MODULE$.apply((short)x);
        }

        public static int toInt$(UShortIsIntegral $this, short x) {
            return $this.toInt(x);
        }

        default public int toInt(short x) {
            return new UShort(x).toInt();
        }

        public static long toLong$(UShortIsIntegral $this, short x) {
            return $this.toLong(x);
        }

        default public long toLong(short x) {
            return new UShort(x).toLong();
        }

        public static float toFloat$(UShortIsIntegral $this, short x) {
            return $this.toFloat(x);
        }

        default public float toFloat(short x) {
            return new UShort(x).toFloat();
        }

        public static double toDouble$(UShortIsIntegral $this, short x) {
            return $this.toDouble(x);
        }

        default public double toDouble(short x) {
            return new UShort(x).toDouble();
        }
    }

    public static interface UShortOrdering
    extends Ordering<UShort> {
        public static int compare$(UShortOrdering $this, short x, short y) {
            return $this.compare(x, y);
        }

        default public int compare(short x, short y) {
            if (new UShort(x).$less(y)) {
                return -1;
            }
            if (x == y) {
                return 0;
            }
            return 1;
        }
    }
}

