/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipException;
import os.shaded_org_apache_tools_zip.AsiExtraField;
import os.shaded_org_apache_tools_zip.CentralDirectoryParsingZipExtraField;
import os.shaded_org_apache_tools_zip.JarMarker;
import os.shaded_org_apache_tools_zip.UnicodeCommentExtraField;
import os.shaded_org_apache_tools_zip.UnicodePathExtraField;
import os.shaded_org_apache_tools_zip.UnparseableExtraFieldData;
import os.shaded_org_apache_tools_zip.UnrecognizedExtraField;
import os.shaded_org_apache_tools_zip.Zip64ExtendedInformationExtraField;
import os.shaded_org_apache_tools_zip.ZipExtraField;
import os.shaded_org_apache_tools_zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final Map<ZipShort, Class<?>> implementations = new ConcurrentHashMap();

    public static void register(Class<?> clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            implementations.put(zipExtraField.getHeaderId(), clazz);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(String.valueOf(clazz) + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(String.valueOf(clazz) + " is not a concrete class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(String.valueOf(clazz) + "'s no-arg constructor is not public");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(String.valueOf(clazz) + "'s no-arg constructor not found");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(String.valueOf(clazz) + "'s no-arg constructor threw an exception:" + invocationTargetException.getMessage());
        }
    }

    public static ZipExtraField createExtraField(ZipShort zipShort) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = implementations.get(zipShort);
        if (clazz != null) {
            try {
                return (ZipExtraField)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (InstantiationException)new InstantiationException().initCause(invocationTargetException.getTargetException());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw (InstantiationException)new InstantiationException().initCause(noSuchMethodException);
            }
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static ZipExtraField[] parse(byte[] byArray) throws ZipException {
        return ExtraFieldUtils.parse(byArray, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] byArray, boolean bl) throws ZipException {
        return ExtraFieldUtils.parse(byArray, bl, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] byArray, boolean bl, UnparseableExtraField unparseableExtraField) throws ZipException {
        Object object;
        int n;
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        block7: for (int i = 0; i <= byArray.length - 4; i += n + 4) {
            ZipExtraField zipExtraField;
            object = new ZipShort(byArray, i);
            n = new ZipShort(byArray, i + 2).getValue();
            if (i + 4 + n > byArray.length) {
                switch (unparseableExtraField.getKey()) {
                    case 0: {
                        throw new ZipException("bad extra field starting at " + i + ".  Block length of " + n + " bytes exceeds remaining data of " + (byArray.length - i - 4) + " bytes.");
                    }
                    case 2: {
                        zipExtraField = new UnparseableExtraFieldData();
                        if (bl) {
                            ((UnparseableExtraFieldData)zipExtraField).parseFromLocalFileData(byArray, i, byArray.length - i);
                        } else {
                            ((UnparseableExtraFieldData)zipExtraField).parseFromCentralDirectoryData(byArray, i, byArray.length - i);
                        }
                        arrayList.add(zipExtraField);
                    }
                    case 1: {
                        break block7;
                    }
                    default: {
                        throw new ZipException("unknown UnparseableExtraField key: " + unparseableExtraField.getKey());
                    }
                }
            }
            try {
                zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)object);
                if (bl || !(zipExtraField instanceof CentralDirectoryParsingZipExtraField)) {
                    zipExtraField.parseFromLocalFileData(byArray, i + 4, n);
                } else {
                    ((CentralDirectoryParsingZipExtraField)zipExtraField).parseFromCentralDirectoryData(byArray, i + 4, n);
                }
                arrayList.add(zipExtraField);
                continue;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new ZipException(reflectiveOperationException.getMessage());
            }
        }
        object = new ZipExtraField[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        boolean bl = zipExtraFieldArray.length > 0 && zipExtraFieldArray[zipExtraFieldArray.length - 1] instanceof UnparseableExtraFieldData;
        int n = bl ? zipExtraFieldArray.length - 1 : zipExtraFieldArray.length;
        int n2 = 4 * n;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            n2 += zipExtraField.getLocalFileDataLength().getValue();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int byArray2 = 0; byArray2 < n; ++byArray2) {
            System.arraycopy(zipExtraFieldArray[byArray2].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[byArray2].getLocalFileDataLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray3 = zipExtraFieldArray[byArray2].getLocalFileDataData();
            System.arraycopy(byArray3, 0, byArray, n3 + 4, byArray3.length);
            n3 += byArray3.length + 4;
        }
        if (bl) {
            byte[] byArray4 = zipExtraFieldArray[zipExtraFieldArray.length - 1].getLocalFileDataData();
            System.arraycopy(byArray4, 0, byArray, n3, byArray4.length);
        }
        return byArray;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        boolean bl = zipExtraFieldArray.length > 0 && zipExtraFieldArray[zipExtraFieldArray.length - 1] instanceof UnparseableExtraFieldData;
        int n = bl ? zipExtraFieldArray.length - 1 : zipExtraFieldArray.length;
        int n2 = 4 * n;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            n2 += zipExtraField.getCentralDirectoryLength().getValue();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int byArray2 = 0; byArray2 < n; ++byArray2) {
            System.arraycopy(zipExtraFieldArray[byArray2].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[byArray2].getCentralDirectoryLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray3 = zipExtraFieldArray[byArray2].getCentralDirectoryData();
            System.arraycopy(byArray3, 0, byArray, n3 + 4, byArray3.length);
            n3 += byArray3.length + 4;
        }
        if (bl) {
            byte[] byArray4 = zipExtraFieldArray[zipExtraFieldArray.length - 1].getCentralDirectoryData();
            System.arraycopy(byArray4, 0, byArray, n3, byArray4.length);
        }
        return byArray;
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(JarMarker.class);
        ExtraFieldUtils.register(UnicodePathExtraField.class);
        ExtraFieldUtils.register(UnicodeCommentExtraField.class);
        ExtraFieldUtils.register(Zip64ExtendedInformationExtraField.class);
    }

    public static final class UnparseableExtraField {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int n) {
            this.key = n;
        }

        public int getKey() {
            return this.key;
        }
    }
}

