/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.values;

import com.siemens.ct.exi.core.util.MethodsBag;
import com.siemens.ct.exi.core.values.AbstractValue;
import com.siemens.ct.exi.core.values.IntegerValueType;
import com.siemens.ct.exi.core.values.ValueType;
import java.math.BigInteger;

public class IntegerValue
extends AbstractValue
implements Comparable<IntegerValue> {
    public static final IntegerValue ZERO = new IntegerValue(0);
    public static final BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    protected final int ival;
    protected final long lval;
    protected final BigInteger bval;
    protected final IntegerValueType iValType;

    private IntegerValue(int ival) {
        super(ValueType.INTEGER);
        this.ival = ival;
        this.iValType = IntegerValueType.INT;
        this.lval = 0L;
        this.bval = null;
    }

    public IntegerValueType getIntegerValueType() {
        return this.iValType;
    }

    private IntegerValue(long lval) {
        super(ValueType.INTEGER);
        this.ival = 0;
        this.iValType = IntegerValueType.LONG;
        this.lval = lval;
        this.bval = null;
    }

    private IntegerValue(BigInteger bval) {
        super(ValueType.INTEGER);
        this.bval = bval;
        this.iValType = IntegerValueType.BIG;
        this.ival = 0;
        this.lval = 0L;
    }

    public int intValue() {
        switch (this.iValType) {
            case INT: {
                return this.ival;
            }
            case LONG: {
                return (int)this.lval;
            }
            case BIG: {
                return this.bval.intValue();
            }
        }
        throw new RuntimeException("Unsupported Integer Type " + (Object)((Object)this.valueType));
    }

    public long longValue() {
        switch (this.iValType) {
            case INT: {
                return this.ival;
            }
            case LONG: {
                return this.lval;
            }
            case BIG: {
                return this.bval.longValue();
            }
        }
        throw new RuntimeException("Unsupported Integer Type " + (Object)((Object)this.valueType));
    }

    public BigInteger bigIntegerValue() {
        switch (this.iValType) {
            case INT: {
                return BigInteger.valueOf(this.ival);
            }
            case LONG: {
                return BigInteger.valueOf(this.lval);
            }
            case BIG: {
                return this.bval;
            }
        }
        throw new RuntimeException("Unsupported Integer Type " + (Object)((Object)this.valueType));
    }

    public boolean isPositive() {
        switch (this.iValType) {
            case INT: {
                return this.ival >= 0;
            }
            case LONG: {
                return this.lval >= 0L;
            }
            case BIG: {
                return this.bval.signum() != -1;
            }
        }
        return false;
    }

    public IntegerValue add(IntegerValue val) {
        IntegerValue iv;
        if (val._equals(ZERO)) {
            return this;
        }
        block0 : switch (this.iValType) {
            case INT: {
                switch (val.iValType) {
                    case INT: {
                        iv = new IntegerValue(this.ival + val.ival);
                        break block0;
                    }
                    case LONG: {
                        iv = IntegerValue.valueOf((long)this.ival + val.lval);
                        break block0;
                    }
                    case BIG: {
                        iv = IntegerValue.valueOf(BigInteger.valueOf(this.ival).add(val.bval));
                        break block0;
                    }
                }
                iv = null;
                break;
            }
            case LONG: {
                switch (val.iValType) {
                    case INT: {
                        iv = new IntegerValue(this.lval + (long)val.ival);
                        break block0;
                    }
                    case LONG: {
                        iv = IntegerValue.valueOf(this.lval + val.lval);
                        break block0;
                    }
                    case BIG: {
                        iv = IntegerValue.valueOf(BigInteger.valueOf(this.lval).add(val.bval));
                        break block0;
                    }
                }
                iv = null;
                break;
            }
            case BIG: {
                switch (val.iValType) {
                    case INT: {
                        iv = new IntegerValue(this.bval.add(BigInteger.valueOf(val.ival)));
                        break block0;
                    }
                    case LONG: {
                        iv = IntegerValue.valueOf(this.bval.add(BigInteger.valueOf(val.lval)));
                        break block0;
                    }
                    case BIG: {
                        iv = IntegerValue.valueOf(this.bval.add(val.bval));
                        break block0;
                    }
                }
                iv = null;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Integer Type " + (Object)((Object)this.valueType));
            }
        }
        return iv;
    }

    public IntegerValue subtract(IntegerValue val) {
        IntegerValue iv;
        if (val._equals(ZERO)) {
            return this;
        }
        block0 : switch (this.iValType) {
            case INT: {
                switch (val.iValType) {
                    case INT: {
                        iv = new IntegerValue(this.ival - val.ival);
                        break block0;
                    }
                    case LONG: {
                        iv = IntegerValue.valueOf((long)this.ival - val.lval);
                        break block0;
                    }
                    case BIG: {
                        iv = IntegerValue.valueOf(BigInteger.valueOf(this.ival).subtract(val.bval));
                        break block0;
                    }
                }
                iv = null;
                break;
            }
            case LONG: {
                switch (val.iValType) {
                    case INT: {
                        iv = new IntegerValue(this.lval - (long)val.ival);
                        break block0;
                    }
                    case LONG: {
                        iv = IntegerValue.valueOf(this.lval - val.lval);
                        break block0;
                    }
                    case BIG: {
                        iv = IntegerValue.valueOf(BigInteger.valueOf(this.lval).subtract(val.bval));
                        break block0;
                    }
                }
                iv = null;
                break;
            }
            case BIG: {
                switch (val.iValType) {
                    case INT: {
                        iv = new IntegerValue(this.bval.subtract(BigInteger.valueOf(val.ival)));
                        break block0;
                    }
                    case LONG: {
                        iv = IntegerValue.valueOf(this.bval.subtract(BigInteger.valueOf(val.lval)));
                        break block0;
                    }
                    case BIG: {
                        iv = IntegerValue.valueOf(this.bval.subtract(val.bval));
                        break block0;
                    }
                }
                iv = null;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Integer Type " + (Object)((Object)this.valueType));
            }
        }
        return iv;
    }

    public static IntegerValue valueOf(int ival) {
        return new IntegerValue(ival);
    }

    public static IntegerValue valueOf(long lval) {
        if (lval < Integer.MIN_VALUE || lval > Integer.MAX_VALUE) {
            return new IntegerValue(lval);
        }
        return new IntegerValue((int)lval);
    }

    public static IntegerValue valueOf(BigInteger bval) {
        if (bval.compareTo(INTEGER_MIN_VALUE) == -1 || bval.compareTo(INTEGER_MAX_VALUE) == 1) {
            if (bval.compareTo(LONG_MIN_VALUE) == -1 || bval.compareTo(LONG_MAX_VALUE) == 1) {
                return new IntegerValue(bval);
            }
            return new IntegerValue(bval.longValue());
        }
        return new IntegerValue(bval.intValue());
    }

    protected static String getAdjustedValue(String value) {
        if ((value = value.trim()).length() > 0 && value.charAt(0) == '+') {
            value = value.substring(1);
        }
        return value;
    }

    public static IntegerValue parse(String value) {
        try {
            value = IntegerValue.getAdjustedValue(value);
            int len = value.length();
            if (len > 0) {
                if (value.charAt(0) == '-') {
                    if (len < 11) {
                        return new IntegerValue(Integer.parseInt(value));
                    }
                    if (len < 20) {
                        return new IntegerValue(Long.parseLong(value));
                    }
                    return new IntegerValue(new BigInteger(value));
                }
                if (len < 10) {
                    return new IntegerValue(Integer.parseInt(value));
                }
                if (len < 19) {
                    return new IntegerValue(Long.parseLong(value));
                }
                return new IntegerValue(new BigInteger(value));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public int getCharactersLength() {
        if (this.slen == -1) {
            switch (this.iValType) {
                case INT: {
                    if (this.ival == Integer.MIN_VALUE) {
                        this.slen = MethodsBag.INTEGER_MIN_VALUE_CHARARRAY.length;
                        break;
                    }
                    this.slen = MethodsBag.getStringSize(this.ival);
                    break;
                }
                case LONG: {
                    if (this.lval == Long.MIN_VALUE) {
                        this.slen = MethodsBag.LONG_MIN_VALUE_CHARARRAY.length;
                        break;
                    }
                    this.slen = MethodsBag.getStringSize(this.lval);
                    break;
                }
                case BIG: {
                    this.slen = this.bval.toString().length();
                    break;
                }
                default: {
                    this.slen = -1;
                }
            }
        }
        return this.slen;
    }

    @Override
    public void getCharacters(char[] cbuffer, int offset) {
        switch (this.iValType) {
            case INT: {
                if (this.ival == Integer.MIN_VALUE) {
                    System.arraycopy(MethodsBag.INTEGER_MIN_VALUE_CHARARRAY, 0, cbuffer, offset, MethodsBag.INTEGER_MIN_VALUE_CHARARRAY.length);
                    break;
                }
                assert (cbuffer.length >= this.getCharactersLength());
                MethodsBag.itos(this.ival, offset + this.getCharactersLength(), cbuffer);
                break;
            }
            case LONG: {
                if (this.lval == Long.MIN_VALUE) {
                    System.arraycopy(MethodsBag.LONG_MIN_VALUE_CHARARRAY, 0, cbuffer, offset, MethodsBag.LONG_MIN_VALUE_CHARARRAY.length);
                    break;
                }
                assert (cbuffer.length >= this.getCharactersLength());
                MethodsBag.itos(this.lval, offset + this.getCharactersLength(), cbuffer);
                break;
            }
            case BIG: {
                String src = this.bval.toString();
                src.getChars(0, src.length(), cbuffer, 0);
                break;
            }
        }
    }

    private final boolean _equals(IntegerValue o) {
        switch (this.iValType) {
            case INT: {
                return o.iValType == IntegerValueType.INT && this.ival == o.ival;
            }
            case LONG: {
                return o.iValType == IntegerValueType.LONG && this.lval == o.lval;
            }
            case BIG: {
                return o.iValType == IntegerValueType.BIG && this.bval.equals(o.bval);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof IntegerValue) {
            return this._equals((IntegerValue)o);
        }
        IntegerValue iv = IntegerValue.parse(o.toString());
        return iv == null ? false : this._equals(iv);
    }

    public int hashCode() {
        int hc = 0;
        switch (this.iValType) {
            case INT: {
                hc = this.ival;
                break;
            }
            case LONG: {
                hc = (int)(this.lval ^ this.lval >>> 32);
                break;
            }
            case BIG: {
                hc = this.bval.hashCode();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Integer Type " + (Object)((Object)this.valueType));
            }
        }
        return hc;
    }

    @Override
    public int compareTo(IntegerValue o) {
        switch (this.iValType) {
            case INT: {
                switch (o.iValType) {
                    case INT: {
                        if (this.ival == o.ival) {
                            return 0;
                        }
                        if (this.ival < o.ival) {
                            return -1;
                        }
                        return 1;
                    }
                    case LONG: 
                    case BIG: {
                        return -1;
                    }
                }
                return -2;
            }
            case LONG: {
                switch (o.iValType) {
                    case INT: {
                        return 1;
                    }
                    case LONG: {
                        if (this.lval == o.lval) {
                            return 0;
                        }
                        if (this.lval < o.lval) {
                            return -1;
                        }
                        return 1;
                    }
                    case BIG: {
                        return -1;
                    }
                }
                return -2;
            }
            case BIG: {
                switch (o.iValType) {
                    case INT: 
                    case LONG: {
                        return 1;
                    }
                    case BIG: {
                        return this.bval.compareTo(o.bval);
                    }
                }
                return -2;
            }
        }
        return -2;
    }
}

