/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.web.taglib

import grails.artefact.Artefact
import grails.testing.web.taglib.TagLibUnitTest
import spock.lang.Specification

/**
 * @author Graeme Rocher
 * @since 0.4
 */
class NamedTagBodyParamsTests extends Specification implements TagLibUnitTest<BodyParamTagLib> {

    void testNamedBodyParams() {
        expect:
        applyTemplate('<g:test1>foo: ${foo} one: ${one}</g:test1>') == 'foo: bar one: 2'
    }

    void testOverridingParam() {
        expect:
        applyTemplate('''
<g:set var="foo">Test</g:set>
<g:test1>foo: ${foo} one: ${one}</g:test1>
<% assert foo == 'Test' %>
''').trim() == 'foo: bar one: 2'
    }
}

@Artefact('TagLib')
class BodyParamTagLib {
    Closure test1 = { attrs, body ->
        out << body(foo:"bar", one:2)
    }
}

