/*
 * Decompiled with CFR 0.152.
 */
package grails.gorm;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.grails.datastore.mapping.query.Query;

public class PagedResultList<E>
implements Serializable,
List<E> {
    private static final long serialVersionUID = -5820655628956173929L;
    private final Query query;
    protected List<E> resultList;
    protected int totalCount = Integer.MIN_VALUE;

    public PagedResultList(Query query) {
        this.query = query;
        this.resultList = query == null ? Collections.emptyList() : query.list();
    }

    public int getTotalCount() {
        this.initialize();
        return this.totalCount;
    }

    @Override
    public E get(int i2) {
        return this.resultList.get(i2);
    }

    @Override
    public E set(int i2, E o) {
        return this.resultList.set(i2, o);
    }

    @Override
    public E remove(int i2) {
        return this.resultList.remove(i2);
    }

    @Override
    public int indexOf(Object o) {
        return this.resultList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.resultList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.resultList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index2) {
        return this.resultList.listIterator(index2);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.resultList.subList(fromIndex, toIndex);
    }

    @Override
    public void add(int i2, E o) {
        this.resultList.add(i2, o);
    }

    protected void initialize() {
        if (this.totalCount == Integer.MIN_VALUE) {
            if (this.query == null) {
                this.totalCount = 0;
            } else {
                Query newQuery = (Query)this.query.clone();
                newQuery.projections().count();
                Number result = (Number)newQuery.singleResult();
                this.totalCount = result == null ? 0 : result.intValue();
            }
        }
    }

    @Override
    public int size() {
        return this.resultList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.resultList.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.resultList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.resultList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.resultList.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.resultList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.resultList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.resultList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.resultList.addAll(c);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends E> c) {
        return this.resultList.addAll(index2, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.resultList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.resultList.retainAll(c);
    }

    @Override
    public void clear() {
        this.resultList.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.resultList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.resultList.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getTotalCount();
        out.defaultWriteObject();
    }
}

