/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.bind.binders;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.client.bind.AnnotatedClientRequestBinder;
import io.micronaut.http.client.bind.ClientRequestUriContext;
import java.util.List;

public class HeaderClientRequestBinder
implements AnnotatedClientRequestBinder<Header> {
    @Override
    public void bind(@NonNull MethodInvocationContext<Object, Object> context, @NonNull ClientRequestUriContext uriContext, @NonNull MutableHttpRequest<?> request) {
        List<AnnotationValue<Header>> headerAnnotations = context.getAnnotationValuesByType(Header.class);
        for (AnnotationValue<Header> headerAnnotation : headerAnnotations) {
            String headerName = headerAnnotation.stringValue("name").orElse(null);
            String headerValue = headerAnnotation.stringValue().orElse(null);
            MutableHttpHeaders headers = request.getHeaders();
            if (!StringUtils.isNotEmpty(headerName) || !StringUtils.isNotEmpty(headerValue) || headers.contains(headerName)) continue;
            headers.set(headerName, headerValue);
        }
    }

    @Override
    @NonNull
    public Class<Header> getAnnotationType() {
        return Header.class;
    }
}

