/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal;

import java.util.concurrent.Future;
import net.snowflake.client.jdbc.internal.amazonaws.event.DeliveryMode;
import net.snowflake.client.jdbc.internal.amazonaws.event.ProgressListener;
import net.snowflake.client.jdbc.internal.amazonaws.event.SDKProgressPublisher;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.PersistableTransfer;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class S3ProgressPublisher
extends SDKProgressPublisher {
    public static Future<?> publishTransferPersistable(ProgressListener listener, PersistableTransfer persistableTransfer) {
        if (persistableTransfer == null || !(listener instanceof S3ProgressListener)) {
            return null;
        }
        S3ProgressListener s3listener = (S3ProgressListener)listener;
        return S3ProgressPublisher.deliverEvent(s3listener, persistableTransfer);
    }

    private static Future<?> deliverEvent(final S3ProgressListener listener, final PersistableTransfer persistableTransfer) {
        DeliveryMode mode;
        if (listener instanceof DeliveryMode && (mode = (DeliveryMode)((Object)listener)).isSyncCallSafe()) {
            return S3ProgressPublisher.quietlyCallListener(listener, persistableTransfer);
        }
        return S3ProgressPublisher.setLatestFutureTask(S3ProgressPublisher.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                listener.onPersistableTransfer(persistableTransfer);
            }
        }));
    }

    private static Future<?> quietlyCallListener(S3ProgressListener listener, PersistableTransfer persistableTransfer) {
        try {
            listener.onPersistableTransfer(persistableTransfer);
        }
        catch (Throwable t2) {
            LogFactory.getLog(S3ProgressPublisher.class).debug("Failure from the event listener", t2);
        }
        return null;
    }
}

