/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools;

import java.io.IOException;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.crypto.AesGcmDecryptor;
import org.apache.parquet.crypto.AesGcmEncryptor;
import org.apache.parquet.crypto.AesMode;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.FileKeyUnwrapper;
import org.apache.parquet.crypto.keytools.FileKeyWrapper;
import org.apache.parquet.crypto.keytools.HadoopFSKeyMaterialStore;
import org.apache.parquet.crypto.keytools.KeyMaterial;
import org.apache.parquet.crypto.keytools.KmsClient;
import org.apache.parquet.crypto.keytools.TwoLevelCacheWithExpiration;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.hadoop.util.HiddenFileFilter;

public class KeyToolkit {
    public static final String KMS_CLIENT_CLASS_PROPERTY_NAME = "parquet.encryption.kms.client.class";
    public static final String KMS_INSTANCE_ID_PROPERTY_NAME = "parquet.encryption.kms.instance.id";
    public static final String KMS_INSTANCE_URL_PROPERTY_NAME = "parquet.encryption.kms.instance.url";
    public static final String KEY_ACCESS_TOKEN_PROPERTY_NAME = "parquet.encryption.key.access.token";
    public static final String DOUBLE_WRAPPING_PROPERTY_NAME = "parquet.encryption.double.wrapping";
    public static final String CACHE_LIFETIME_PROPERTY_NAME = "parquet.encryption.cache.lifetime.seconds";
    public static final String KEY_MATERIAL_INTERNAL_PROPERTY_NAME = "parquet.encryption.key.material.store.internally";
    public static final String DATA_KEY_LENGTH_PROPERTY_NAME = "parquet.encryption.data.key.length.bits";
    public static final String KEK_LENGTH_PROPERTY_NAME = "parquet.encryption.kek.length.bits";
    public static final boolean DOUBLE_WRAPPING_DEFAULT = true;
    public static final long CACHE_LIFETIME_DEFAULT_SECONDS = 600L;
    public static final boolean KEY_MATERIAL_INTERNAL_DEFAULT = true;
    public static final int DATA_KEY_LENGTH_DEFAULT = 128;
    public static final int KEK_LENGTH_DEFAULT = 128;
    private static long lastCacheCleanForKeyRotationTime = 0L;
    private static final Object lastCacheCleanForKeyRotationTimeLock = new Object();
    private static final int CACHE_CLEAN_PERIOD_FOR_KEY_ROTATION = 3600000;
    static final TwoLevelCacheWithExpiration<KmsClient> KMS_CLIENT_CACHE_PER_TOKEN = KmsClientCache.access$000(KmsClientCache.INSTANCE);
    static final TwoLevelCacheWithExpiration<KeyEncryptionKey> KEK_WRITE_CACHE_PER_TOKEN = KEKWriteCache.access$100(KEKWriteCache.INSTANCE);
    static final TwoLevelCacheWithExpiration<byte[]> KEK_READ_CACHE_PER_TOKEN = KEKReadCache.access$200(KEKReadCache.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateMasterKeys(String folderPath, Configuration hadoopConfig) throws IOException, ParquetCryptoRuntimeException, KeyAccessDeniedException, UnsupportedOperationException {
        if (hadoopConfig.getBoolean(KEY_MATERIAL_INTERNAL_PROPERTY_NAME, false)) {
            throw new UnsupportedOperationException("Key rotation is not supported for internal key material");
        }
        long currentTime = System.currentTimeMillis();
        Object object = lastCacheCleanForKeyRotationTimeLock;
        synchronized (object) {
            if (currentTime - lastCacheCleanForKeyRotationTime > 3600000L) {
                KEK_WRITE_CACHE_PER_TOKEN.clear();
                lastCacheCleanForKeyRotationTime = currentTime;
            }
        }
        Path parentPath = new Path(folderPath);
        FileSystem hadoopFileSystem = parentPath.getFileSystem(hadoopConfig);
        if (!hadoopFileSystem.exists(parentPath) || !hadoopFileSystem.isDirectory(parentPath)) {
            throw new ParquetCryptoRuntimeException("Couldn't rotate keys - folder doesn't exist or is not a directory: " + folderPath);
        }
        FileStatus[] parquetFilesInFolder = hadoopFileSystem.listStatus(parentPath, (PathFilter)HiddenFileFilter.INSTANCE);
        if (parquetFilesInFolder.length == 0) {
            throw new ParquetCryptoRuntimeException("Couldn't rotate keys - no parquet files in folder " + folderPath);
        }
        for (FileStatus fs : parquetFilesInFolder) {
            Path parquetFile = fs.getPath();
            HadoopFSKeyMaterialStore keyMaterialStore = new HadoopFSKeyMaterialStore(hadoopFileSystem);
            keyMaterialStore.initialize(parquetFile, hadoopConfig, false);
            HadoopFSKeyMaterialStore tempKeyMaterialStore = new HadoopFSKeyMaterialStore(hadoopFileSystem);
            tempKeyMaterialStore.initialize(parquetFile, hadoopConfig, true);
            Set<String> fileKeyIdSet = keyMaterialStore.getKeyIDSet();
            FileKeyUnwrapper fileKeyUnwrapper = new FileKeyUnwrapper(hadoopConfig, parquetFile, keyMaterialStore);
            String keyMaterialString = keyMaterialStore.getKeyMaterial("footerKey");
            KeyWithMasterID key = fileKeyUnwrapper.getDEKandMasterID(KeyMaterial.parse(keyMaterialString));
            KmsClientAndDetails kmsClientAndDetails = fileKeyUnwrapper.getKmsClientAndDetails();
            FileKeyWrapper fileKeyWrapper = new FileKeyWrapper(hadoopConfig, tempKeyMaterialStore, kmsClientAndDetails);
            fileKeyWrapper.getEncryptionKeyMetadata(key.getDataKey(), key.getMasterID(), true, "footerKey");
            fileKeyIdSet.remove("footerKey");
            for (String keyIdInFile : fileKeyIdSet) {
                keyMaterialString = keyMaterialStore.getKeyMaterial(keyIdInFile);
                key = fileKeyUnwrapper.getDEKandMasterID(KeyMaterial.parse(keyMaterialString));
                fileKeyWrapper.getEncryptionKeyMetadata(key.getDataKey(), key.getMasterID(), false, keyIdInFile);
            }
            tempKeyMaterialStore.saveMaterial();
            keyMaterialStore.removeMaterial();
            tempKeyMaterialStore.moveMaterialTo(keyMaterialStore);
        }
    }

    public static void removeCacheEntriesForToken(String accessToken) {
        KMS_CLIENT_CACHE_PER_TOKEN.removeCacheEntriesForToken(accessToken);
        KEK_WRITE_CACHE_PER_TOKEN.removeCacheEntriesForToken(accessToken);
        KEK_READ_CACHE_PER_TOKEN.removeCacheEntriesForToken(accessToken);
    }

    public static void removeCacheEntriesForAllTokens() {
        KMS_CLIENT_CACHE_PER_TOKEN.clear();
        KEK_WRITE_CACHE_PER_TOKEN.clear();
        KEK_READ_CACHE_PER_TOKEN.clear();
    }

    public static String encryptKeyLocally(byte[] keyBytes, byte[] masterKeyBytes, byte[] AAD) {
        AesGcmEncryptor keyEncryptor = (AesGcmEncryptor)ModuleCipherFactory.getEncryptor(AesMode.GCM, masterKeyBytes);
        byte[] encryptedKey = keyEncryptor.encrypt(false, keyBytes, AAD);
        return Base64.getEncoder().encodeToString(encryptedKey);
    }

    public static byte[] decryptKeyLocally(String encodedEncryptedKey, byte[] masterKeyBytes, byte[] AAD) {
        byte[] encryptedKey = Base64.getDecoder().decode(encodedEncryptedKey);
        AesGcmDecryptor keyDecryptor = (AesGcmDecryptor)ModuleCipherFactory.getDecryptor(AesMode.GCM, masterKeyBytes);
        return keyDecryptor.decrypt(encryptedKey, 0, encryptedKey.length, AAD);
    }

    static KmsClient getKmsClient(String kmsInstanceID, String kmsInstanceURL, Configuration configuration, String accessToken, long cacheEntryLifetime) {
        ConcurrentMap<String, KmsClient> kmsClientPerKmsInstanceCache = KMS_CLIENT_CACHE_PER_TOKEN.getOrCreateInternalCache(accessToken, cacheEntryLifetime);
        KmsClient kmsClient = kmsClientPerKmsInstanceCache.computeIfAbsent(kmsInstanceID, k -> KeyToolkit.createAndInitKmsClient(configuration, kmsInstanceID, kmsInstanceURL, accessToken));
        return kmsClient;
    }

    private static KmsClient createAndInitKmsClient(Configuration configuration, String kmsInstanceID, String kmsInstanceURL, String accessToken) {
        Class<?> kmsClientClass = null;
        KmsClient kmsClient = null;
        try {
            kmsClientClass = ConfigurationUtil.getClassFromConfig(configuration, KMS_CLIENT_CLASS_PROPERTY_NAME, KmsClient.class);
            if (null == kmsClientClass) {
                throw new ParquetCryptoRuntimeException("Unspecified parquet.encryption.kms.client.class");
            }
            kmsClient = (KmsClient)kmsClientClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | BadConfigurationException e) {
            throw new ParquetCryptoRuntimeException("Could not instantiate KmsClient class: " + kmsClientClass, (Throwable)e);
        }
        kmsClient.initialize(configuration, kmsInstanceID, kmsInstanceURL, accessToken);
        return kmsClient;
    }

    static String formatTokenForLog(String accessToken) {
        int maxTokenDisplayLength = 5;
        if (accessToken.length() <= maxTokenDisplayLength) {
            return accessToken;
        }
        return accessToken.substring(accessToken.length() - maxTokenDisplayLength);
    }

    static boolean stringIsEmpty(String str) {
        return null == str || str.isEmpty();
    }

    static class KmsClientAndDetails {
        private KmsClient kmsClient;
        private String kmsInstanceID;
        private String kmsInstanceURL;

        public KmsClientAndDetails(KmsClient kmsClient, String kmsInstanceID, String kmsInstanceURL) {
            this.kmsClient = kmsClient;
            this.kmsInstanceID = kmsInstanceID;
            this.kmsInstanceURL = kmsInstanceURL;
        }

        public KmsClient getKmsClient() {
            return this.kmsClient;
        }

        public String getKmsInstanceID() {
            return this.kmsInstanceID;
        }

        public String getKmsInstanceURL() {
            return this.kmsInstanceURL;
        }
    }

    static class KeyEncryptionKey {
        private final byte[] kekBytes;
        private final byte[] kekID;
        private String encodedKekID;
        private final String encodedWrappedKEK;

        KeyEncryptionKey(byte[] kekBytes, byte[] kekID, String encodedWrappedKEK) {
            this.kekBytes = kekBytes;
            this.kekID = kekID;
            this.encodedWrappedKEK = encodedWrappedKEK;
        }

        byte[] getBytes() {
            return this.kekBytes;
        }

        byte[] getID() {
            return this.kekID;
        }

        String getEncodedID() {
            if (null == this.encodedKekID) {
                this.encodedKekID = Base64.getEncoder().encodeToString(this.kekID);
            }
            return this.encodedKekID;
        }

        String getEncodedWrappedKEK() {
            return this.encodedWrappedKEK;
        }
    }

    static class KeyWithMasterID {
        private final byte[] keyBytes;
        private final String masterID;

        KeyWithMasterID(byte[] keyBytes, String masterID) {
            this.keyBytes = keyBytes;
            this.masterID = masterID;
        }

        byte[] getDataKey() {
            return this.keyBytes;
        }

        String getMasterID() {
            return this.masterID;
        }
    }

    private static enum KEKReadCache {
        INSTANCE;

        private final TwoLevelCacheWithExpiration<byte[]> cache = new TwoLevelCacheWithExpiration();

        private TwoLevelCacheWithExpiration<byte[]> getCache() {
            return this.cache;
        }

        static /* synthetic */ TwoLevelCacheWithExpiration access$200(KEKReadCache x0) {
            return x0.getCache();
        }
    }

    private static enum KEKWriteCache {
        INSTANCE;

        private final TwoLevelCacheWithExpiration<KeyEncryptionKey> cache = new TwoLevelCacheWithExpiration();

        private TwoLevelCacheWithExpiration<KeyEncryptionKey> getCache() {
            return this.cache;
        }

        static /* synthetic */ TwoLevelCacheWithExpiration access$100(KEKWriteCache x0) {
            return x0.getCache();
        }
    }

    private static enum KmsClientCache {
        INSTANCE;

        private final TwoLevelCacheWithExpiration<KmsClient> cache = new TwoLevelCacheWithExpiration();

        private TwoLevelCacheWithExpiration<KmsClient> getCache() {
            return this.cache;
        }

        static /* synthetic */ TwoLevelCacheWithExpiration access$000(KmsClientCache x0) {
            return x0.getCache();
        }
    }
}

