/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.dropbox;

import com.dropbox.core.v2.DbxClientV2;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.dropbox.DropboxFileObject;
import org.apache.hop.vfs.dropbox.DropboxFileProvider;

public class DropboxFileSystem
extends AbstractFileSystem {
    private final DbxClientV2 client;

    protected DropboxFileSystem(FileName rootName, DbxClientV2 client, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.client = client;
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(DropboxFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new DropboxFileObject(name, this);
    }

    DbxClientV2 getClient() {
        return this.client;
    }
}

