/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.vectorwise;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.ingres.IngresDatabaseMeta;

@DatabaseMetaPlugin(type="VECTORWISE", typeDescription="Ingres VectorWise", documentationUrl="/database/databases/vectorwise.html")
@GuiPlugin(id="GUI-VectorWiseDatabaseMeta")
public class VectorWiseDatabaseMeta
extends IngresDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";

    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port) || "-1".equals(port)) {
            return "jdbc:ingres://" + hostname + ":VW7/" + databaseName;
        }
        return "jdbc:ingres://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "GENERATED ALWAYS AS IDENTITY START WITH 1 INCREMENT BY 1";
                        break;
                    }
                    retval = (String)retval + "BIGINT PRIMARY KEY NOT NULL";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    if (length == -1 || length > 4) {
                        retval = (String)retval + "INTEGER";
                        break;
                    }
                    if (length > 2) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    retval = (String)retval + "INTEGER1";
                    break;
                }
                retval = (String)retval + "FLOAT8";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length > 32000) {
                        retval = (String)retval + "VARCHAR(32000)";
                        break;
                    }
                    retval = (String)retval + "VARCHAR(" + length + ")";
                    break;
                }
                retval = (String)retval + "VARCHAR(9999)";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getTruncateTableStatement(String tableName) {
        return "CALL VECTORWISE( COMBINE '" + tableName + " - " + tableName + "' )";
    }

    public boolean isSupportsGetBlob() {
        return false;
    }
}

