/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderElement;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.support.BasicResponseBuilder;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestMessageSupport {
    TestMessageSupport() {
    }

    private static Set<String> makeSet(String ... tokens) {
        if (tokens == null) {
            return null;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Collections.addAll(set, tokens);
        return set;
    }

    @Test
    void testTokenSetFormatting() {
        Header header = MessageSupport.header((String)"Trailer", TestMessageSupport.makeSet("z", "b", "a"));
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"z, b, a", (Object)header.getValue());
    }

    @Test
    void testTokenListFormatting() {
        Header header = MessageSupport.headerOfTokens((String)"Trailer", Arrays.asList("z", "b", "a", "a"));
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"z, b, a, a", (Object)header.getValue());
    }

    @Test
    void testTokenListFormattingWithTransformation() {
        Header header = MessageSupport.headerOfTokens((String)"Trailer", Arrays.asList("z", "b", "a", "a"), e -> e.toUpperCase(Locale.ROOT));
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"Z, B, A, A", (Object)header.getValue());
    }

    @Test
    void testTokenSetFormattingSameName() {
        Header header = MessageSupport.header((String)"Trailer", TestMessageSupport.makeSet("a", "a", "a"));
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"a", (Object)header.getValue());
    }

    @Test
    void testTokenListFormattingSameName() {
        Header header = MessageSupport.header((String)"Trailer", (String[])new String[]{"a", "a", "a"});
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"a, a, a", (Object)header.getValue());
    }

    @Test
    void testParseTokensWithConsumer() {
        String s = "a, b, c, c";
        ParserCursor cursor = new ParserCursor(0, "a, b, c, c".length());
        ArrayList tokens = new ArrayList();
        MessageSupport.parseTokens((CharSequence)"a, b, c, c", (ParserCursor)cursor, tokens::add);
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "c"), tokens);
    }

    @Test
    void testParseTokenHeaderWithConsumer() {
        BasicHeader header = new BasicHeader("Trailer", (Object)"a, b, c, c");
        ArrayList tokens = new ArrayList();
        MessageSupport.parseTokens((Header)header, tokens::add);
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "c"), tokens);
    }

    @Test
    void testParseTokenBufferWithConsumer() {
        CharArrayBuffer buf = new CharArrayBuffer(128);
        buf.append("stuff: a, b, c, c");
        BufferedHeader header = BufferedHeader.create((CharArrayBuffer)buf);
        Assertions.assertEquals(TestMessageSupport.makeSet("a", "b", "c", "c"), (Object)MessageSupport.parseTokens((Header)header));
    }

    @Test
    void testParseTokens() {
        String s = "a, b, c, c";
        ParserCursor cursor = new ParserCursor(0, "a, b, c, c".length());
        Assertions.assertEquals(TestMessageSupport.makeSet("a", "b", "c"), (Object)MessageSupport.parseTokens((CharSequence)"a, b, c, c", (ParserCursor)cursor));
    }

    @Test
    void testParseTokenHeader() {
        BasicHeader header = new BasicHeader("Trailer", (Object)"a, b, c, c");
        Assertions.assertEquals(TestMessageSupport.makeSet("a", "b", "c"), (Object)MessageSupport.parseTokens((Header)header));
    }

    @Test
    void testParseTokenBuffer() {
        CharArrayBuffer buf = new CharArrayBuffer(128);
        buf.append("stuff: a, b, c, c");
        BufferedHeader header = BufferedHeader.create((CharArrayBuffer)buf);
        Assertions.assertEquals(TestMessageSupport.makeSet("a", "b", "c"), (Object)MessageSupport.parseTokens((Header)header));
    }

    @Test
    void testElementListFormatting() {
        List<HeaderElement> elements = Arrays.asList(new BasicHeaderElement("name1", "value1", new NameValuePair[]{new BasicNameValuePair("param", "regular_stuff")}), new BasicHeaderElement("name2", "value2", new NameValuePair[]{new BasicNameValuePair("param", "this\\that")}), new BasicHeaderElement("name3", "value3", new NameValuePair[]{new BasicNameValuePair("param", "this,that")}), new BasicHeaderElement("name4", "value4", new NameValuePair[]{new BasicNameValuePair("param", null)}), new BasicHeaderElement("name5", null));
        Header header = MessageSupport.headerOfElements((String)"Some-header", elements);
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"name1=value1; param=regular_stuff, name2=value2; param=\"this\\\\that\", name3=value3; param=\"this,that\", name4=value4; param, name5", (Object)header.getValue());
    }

    @Test
    void testElementArrayFormatting() {
        HeaderElement[] elements = new HeaderElement[]{new BasicHeaderElement("name1", "value1", new NameValuePair[]{new BasicNameValuePair("param", "regular_stuff")}), new BasicHeaderElement("name2", "value2", new NameValuePair[]{new BasicNameValuePair("param", "this\\that")}), new BasicHeaderElement("name3", "value3", new NameValuePair[]{new BasicNameValuePair("param", "this,that")}), new BasicHeaderElement("name4", "value4", new NameValuePair[]{new BasicNameValuePair("param", null)}), new BasicHeaderElement("name5", null)};
        Header header = MessageSupport.header((String)"Some-Header", (HeaderElement[])elements);
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"name1=value1; param=regular_stuff, name2=value2; param=\"this\\\\that\", name3=value3; param=\"this,that\", name4=value4; param, name5", (Object)header.getValue());
    }

    @Test
    void testParseElementsBufferWithConsumer() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"");
        ArrayList elements = new ArrayList();
        ParserCursor cursor = new ParserCursor(0, buf.length());
        MessageSupport.parseElements((CharSequence)buf, (ParserCursor)cursor, elements::add);
        Assertions.assertEquals((int)3, (int)elements.size());
        Assertions.assertEquals((Object)"name1", (Object)((HeaderElement)elements.get(0)).getName());
        Assertions.assertEquals((Object)"value1", (Object)((HeaderElement)elements.get(0)).getValue());
        Assertions.assertEquals((int)2, (int)((HeaderElement)elements.get(0)).getParameters().length);
        Assertions.assertEquals((Object)"name2", (Object)((HeaderElement)elements.get(0)).getParameters()[0].getName());
        Assertions.assertNull((Object)((HeaderElement)elements.get(0)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name3", (Object)((HeaderElement)elements.get(0)).getParameters()[1].getName());
        Assertions.assertEquals((Object)"value3", (Object)((HeaderElement)elements.get(0)).getParameters()[1].getValue());
        Assertions.assertEquals((Object)"name4", (Object)((HeaderElement)elements.get(1)).getName());
        Assertions.assertEquals((Object)"value4", (Object)((HeaderElement)elements.get(1)).getValue());
        Assertions.assertEquals((int)1, (int)((HeaderElement)elements.get(1)).getParameters().length);
        Assertions.assertEquals((Object)"name5", (Object)((HeaderElement)elements.get(1)).getParameters()[0].getName());
        Assertions.assertEquals((Object)"value5", (Object)((HeaderElement)elements.get(1)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name6", (Object)((HeaderElement)elements.get(2)).getName());
        Assertions.assertEquals((Object)"", (Object)((HeaderElement)elements.get(2)).getValue());
        Assertions.assertEquals((int)2, (int)((HeaderElement)elements.get(2)).getParameters().length);
        Assertions.assertEquals((Object)"name7", (Object)((HeaderElement)elements.get(2)).getParameters()[0].getName());
        Assertions.assertEquals((Object)"value7", (Object)((HeaderElement)elements.get(2)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name8", (Object)((HeaderElement)elements.get(2)).getParameters()[1].getName());
        Assertions.assertEquals((Object)" value8", (Object)((HeaderElement)elements.get(2)).getParameters()[1].getValue());
    }

    @Test
    void testParseElementsHeaderWithConsumer() {
        BasicHeader header = new BasicHeader("Some-Header", (Object)"name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"");
        ArrayList elements = new ArrayList();
        MessageSupport.parseElements((Header)header, elements::add);
        Assertions.assertEquals((int)3, (int)elements.size());
        Assertions.assertEquals((Object)"name1", (Object)((HeaderElement)elements.get(0)).getName());
        Assertions.assertEquals((Object)"value1", (Object)((HeaderElement)elements.get(0)).getValue());
        Assertions.assertEquals((int)2, (int)((HeaderElement)elements.get(0)).getParameters().length);
        Assertions.assertEquals((Object)"name2", (Object)((HeaderElement)elements.get(0)).getParameters()[0].getName());
        Assertions.assertNull((Object)((HeaderElement)elements.get(0)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name3", (Object)((HeaderElement)elements.get(0)).getParameters()[1].getName());
        Assertions.assertEquals((Object)"value3", (Object)((HeaderElement)elements.get(0)).getParameters()[1].getValue());
        Assertions.assertEquals((Object)"name4", (Object)((HeaderElement)elements.get(1)).getName());
        Assertions.assertEquals((Object)"value4", (Object)((HeaderElement)elements.get(1)).getValue());
        Assertions.assertEquals((int)1, (int)((HeaderElement)elements.get(1)).getParameters().length);
        Assertions.assertEquals((Object)"name5", (Object)((HeaderElement)elements.get(1)).getParameters()[0].getName());
        Assertions.assertEquals((Object)"value5", (Object)((HeaderElement)elements.get(1)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name6", (Object)((HeaderElement)elements.get(2)).getName());
        Assertions.assertEquals((Object)"", (Object)((HeaderElement)elements.get(2)).getValue());
        Assertions.assertEquals((int)2, (int)((HeaderElement)elements.get(2)).getParameters().length);
        Assertions.assertEquals((Object)"name7", (Object)((HeaderElement)elements.get(2)).getParameters()[0].getName());
        Assertions.assertEquals((Object)"value7", (Object)((HeaderElement)elements.get(2)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name8", (Object)((HeaderElement)elements.get(2)).getParameters()[1].getName());
        Assertions.assertEquals((Object)" value8", (Object)((HeaderElement)elements.get(2)).getParameters()[1].getValue());
    }

    @Test
    void testParseElementsHeader() {
        BasicHeader header = new BasicHeader("Some-Header", (Object)"name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"");
        List elements = MessageSupport.parseElements((Header)header);
        Assertions.assertEquals((int)3, (int)elements.size());
        Assertions.assertEquals((Object)"name1", (Object)((HeaderElement)elements.get(0)).getName());
        Assertions.assertEquals((Object)"value1", (Object)((HeaderElement)elements.get(0)).getValue());
        Assertions.assertEquals((int)2, (int)((HeaderElement)elements.get(0)).getParameters().length);
        Assertions.assertEquals((Object)"name2", (Object)((HeaderElement)elements.get(0)).getParameters()[0].getName());
        Assertions.assertNull((Object)((HeaderElement)elements.get(0)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name3", (Object)((HeaderElement)elements.get(0)).getParameters()[1].getName());
        Assertions.assertEquals((Object)"value3", (Object)((HeaderElement)elements.get(0)).getParameters()[1].getValue());
        Assertions.assertEquals((Object)"name4", (Object)((HeaderElement)elements.get(1)).getName());
        Assertions.assertEquals((Object)"value4", (Object)((HeaderElement)elements.get(1)).getValue());
        Assertions.assertEquals((int)1, (int)((HeaderElement)elements.get(1)).getParameters().length);
        Assertions.assertEquals((Object)"name5", (Object)((HeaderElement)elements.get(1)).getParameters()[0].getName());
        Assertions.assertEquals((Object)"value5", (Object)((HeaderElement)elements.get(1)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name6", (Object)((HeaderElement)elements.get(2)).getName());
        Assertions.assertEquals((Object)"", (Object)((HeaderElement)elements.get(2)).getValue());
        Assertions.assertEquals((int)2, (int)((HeaderElement)elements.get(2)).getParameters().length);
        Assertions.assertEquals((Object)"name7", (Object)((HeaderElement)elements.get(2)).getParameters()[0].getName());
        Assertions.assertEquals((Object)"value7", (Object)((HeaderElement)elements.get(2)).getParameters()[0].getValue());
        Assertions.assertEquals((Object)"name8", (Object)((HeaderElement)elements.get(2)).getParameters()[1].getName());
        Assertions.assertEquals((Object)" value8", (Object)((HeaderElement)elements.get(2)).getParameters()[1].getValue());
    }

    @Test
    void testParamListFormatting() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        MessageSupport.formatParameters((CharArrayBuffer)buf, Arrays.asList(new BasicNameValuePair("param", "regular_stuff"), new BasicNameValuePair("param", "this\\that"), new BasicNameValuePair("param", "this,that")));
        Assertions.assertEquals((Object)"param=regular_stuff; param=\"this\\\\that\"; param=\"this,that\"", (Object)buf.toString());
    }

    @Test
    void testParamArrayFormatting() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        MessageSupport.formatParameters((CharArrayBuffer)buf, (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("param", "regular_stuff"), new BasicNameValuePair("param", "this\\that"), new BasicNameValuePair("param", "this,that")});
        Assertions.assertEquals((Object)"param=regular_stuff; param=\"this\\\\that\"; param=\"this,that\"", (Object)buf.toString());
    }

    @Test
    void testParseParams() {
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=stuff,123";
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=stuff,123");
        ParserCursor cursor = new ParserCursor(0, "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=stuff,123".length());
        ArrayList params = new ArrayList();
        MessageSupport.parseParameters((CharSequence)buffer, (ParserCursor)cursor, params::add);
        Assertions.assertEquals((Object)"test", (Object)((NameValuePair)params.get(0)).getName());
        Assertions.assertNull((Object)((NameValuePair)params.get(0)).getValue());
        Assertions.assertEquals((Object)"test1", (Object)((NameValuePair)params.get(1)).getName());
        Assertions.assertEquals((Object)"stuff", (Object)((NameValuePair)params.get(1)).getValue());
        Assertions.assertEquals((Object)"test2", (Object)((NameValuePair)params.get(2)).getName());
        Assertions.assertEquals((Object)"stuff; stuff", (Object)((NameValuePair)params.get(2)).getValue());
        Assertions.assertEquals((Object)"test3", (Object)((NameValuePair)params.get(3)).getName());
        Assertions.assertEquals((Object)"stuff", (Object)((NameValuePair)params.get(3)).getValue());
        Assertions.assertEquals((int)("test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=stuff,123".length() - 4), (int)cursor.getPos());
        Assertions.assertFalse((boolean)cursor.atEnd());
    }

    @Test
    void testAddContentHeaders() {
        HttpEntity entity = HttpEntities.create((String)"some stuff with trailers", (Charset)StandardCharsets.US_ASCII, (Header[])new Header[]{new BasicHeader("z", (Object)"this"), new BasicHeader("b", (Object)"that"), new BasicHeader("a", (Object)"this and that")});
        BasicHttpResponse message = new BasicHttpResponse(200);
        MessageSupport.addTrailerHeader((HttpMessage)message, (EntityDetails)entity);
        MessageSupport.addContentTypeHeader((HttpMessage)message, (EntityDetails)entity);
        Header h1 = message.getFirstHeader("Trailer");
        Header h2 = message.getFirstHeader("Content-Type");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"z, b, a", (Object)h1.getValue());
        Assertions.assertNotNull((Object)h2);
        Assertions.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)h2.getValue());
    }

    @Test
    void testContentHeadersAlreadyPresent() {
        HttpEntity entity = HttpEntities.create((String)"some stuff with trailers", (Charset)StandardCharsets.US_ASCII, (Header[])new Header[]{new BasicHeader("z", (Object)"this"), new BasicHeader("b", (Object)"that"), new BasicHeader("a", (Object)"this and that")});
        BasicHttpResponse message = new BasicHttpResponse(200);
        message.addHeader("Trailer", (Object)"a, a, a");
        message.addHeader("Content-Type", (Object)"text/plain; charset=ascii");
        MessageSupport.addTrailerHeader((HttpMessage)message, (EntityDetails)entity);
        MessageSupport.addContentTypeHeader((HttpMessage)message, (EntityDetails)entity);
        Header h1 = message.getFirstHeader("Trailer");
        Header h2 = message.getFirstHeader("Content-Type");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"a, a, a", (Object)h1.getValue());
        Assertions.assertNotNull((Object)h2);
        Assertions.assertEquals((Object)"text/plain; charset=ascii", (Object)h2.getValue());
    }

    @Test
    void testHopByHopHeaders() {
        Assertions.assertTrue((boolean)MessageSupport.isHopByHop((String)"Connection"));
        Assertions.assertTrue((boolean)MessageSupport.isHopByHop((String)"connection"));
        Assertions.assertTrue((boolean)MessageSupport.isHopByHop((String)"coNNection"));
        Assertions.assertFalse((boolean)MessageSupport.isHopByHop((String)"Content-Type"));
        Assertions.assertFalse((boolean)MessageSupport.isHopByHop((String)"huh"));
    }

    @Test
    void testHopByHopHeadersConnectionSpecific() {
        BasicHttpResponse response = BasicResponseBuilder.create((int)200).addHeader("Connection", "blah, blah, this, that").addHeader("Content-Type", ContentType.TEXT_PLAIN.toString()).build();
        Set hopByHopConnectionSpecific = MessageSupport.hopByHopConnectionSpecific((MessageHeaders)response);
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("Connection"));
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("connection"));
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("coNNection"));
        Assertions.assertFalse((boolean)hopByHopConnectionSpecific.contains("Content-Type"));
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("blah"));
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("Blah"));
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("This"));
        Assertions.assertTrue((boolean)hopByHopConnectionSpecific.contains("That"));
    }
}

