/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.jdbc.ConnectionProperties;
import org.apache.ignite.internal.jdbc.JdbcClientQueryEventHandler;
import org.apache.ignite.internal.jdbc.JdbcDatabaseMetadata;
import org.apache.ignite.internal.jdbc.JdbcPreparedStatement;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.apache.ignite.shaded.org.apache.ignite.client.BasicAuthenticator;
import org.apache.ignite.shaded.org.apache.ignite.client.IgniteClientAuthenticator;
import org.apache.ignite.shaded.org.apache.ignite.client.SslConfiguration;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.HostAndPort;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.IgniteClientConfigurationImpl;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.IgniteQueryErrorCode;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.JdbcQueryEventHandler;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcConnectResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.jdbc.proto.event.JdbcFinishTxResult;
import org.apache.ignite.shaded.org.apache.ignite.internal.sql.SqlCommon;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.shaded.org.jetbrains.annotations.TestOnly;

public class JdbcConnection
implements Connection {
    private static final String SET_NETWORK_TIMEOUT_PERM = "setNetworkTimeout";
    private static final AtomicLong GLOBAL_CONN_ID_GEN = new AtomicLong();
    private final Object stmtsMux = new Object();
    private final AtomicLong tokenGenerator = new AtomicLong();
    private final JdbcQueryEventHandler handler;
    private final long connectionId;
    private String schema;
    private volatile boolean closed;
    private int txIsolation;
    private boolean autoCommit;
    private boolean readOnly;
    private int holdability;
    private final ConnectionProperties connProps;
    private final Set<JdbcStatement> stmts = Collections.newSetFromMap(new IdentityHashMap());
    private int netTimeout;
    @Nullable
    private final Integer qryTimeout;
    private final TcpIgniteClient client;
    private JdbcDatabaseMetadata metadata;

    public JdbcConnection(ConnectionProperties props, HybridTimestampTracker observableTimeTracker) throws SQLException {
        this.connProps = props;
        this.autoCommit = true;
        String[] addrs = (String[])Arrays.stream(props.getAddresses()).map(this::createStrAddress).toArray(String[]::new);
        this.netTimeout = this.connProps.getConnectionTimeout();
        this.qryTimeout = this.connProps.getQueryTimeout();
        try {
            this.client = this.buildClient(addrs, observableTimeTracker);
        }
        catch (Exception e) {
            throw new SQLException("Failed to connect to server", "08001", e);
        }
        this.handler = new JdbcClientQueryEventHandler(this.client);
        try {
            JdbcConnectResult result = this.handler.connect(this.connProps.getConnectionTimeZone(), null).get();
            if (!result.success()) {
                throw IgniteQueryErrorCode.createJdbcSqlException(result.err(), result.status());
            }
            this.connectionId = result.connectionId();
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Failed to initialize connection.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Connection initialization canceled.", e);
        }
        this.txIsolation = 0;
        this.schema = JdbcConnection.normalizeSchema(this.connProps.getSchema());
        this.holdability = 1;
    }

    private TcpIgniteClient buildClient(String[] addrs, HybridTimestampTracker observableTimeTracker) {
        IgniteClientConfigurationImpl cfg = new IgniteClientConfigurationImpl(null, addrs, this.netTimeout, 30000L, null, 30000L, 5000L, null, null, JdbcConnection.extractSslConfiguration(this.connProps), false, JdbcConnection.extractAuthenticationConfiguration(this.connProps), 0L, 1024, "jdbc_client_" + GLOBAL_CONN_ID_GEN.getAndIncrement());
        return (TcpIgniteClient)ViewUtils.sync(TcpIgniteClient.startAsync(cfg, observableTimeTracker));
    }

    @TestOnly
    public JdbcConnection(JdbcQueryEventHandler handler, ConnectionProperties props) {
        this.connProps = props;
        this.handler = handler;
        this.autoCommit = true;
        this.netTimeout = this.connProps.getConnectionTimeout();
        this.qryTimeout = this.connProps.getQueryTimeout();
        this.holdability = 1;
        this.schema = SqlCommon.DEFAULT_SCHEMA_NAME;
        this.client = null;
        this.connectionId = -1L;
    }

    @Nullable
    private static SslConfiguration extractSslConfiguration(ConnectionProperties connProps) {
        if (connProps.isSslEnabled()) {
            return SslConfiguration.builder().enabled(true).trustStorePath(connProps.getTrustStorePath()).trustStorePassword(connProps.getTrustStorePassword()).ciphers(connProps.getCiphers()).keyStorePath(connProps.getKeyStorePath()).keyStorePassword(connProps.getKeyStorePassword()).build();
        }
        return null;
    }

    @Nullable
    private static IgniteClientAuthenticator extractAuthenticationConfiguration(ConnectionProperties connProps) {
        String username = connProps.getUsername();
        String password = connProps.getPassword();
        if (username != null && password != null) {
            return BasicAuthenticator.builder().username(username).password(password).build();
        }
        return null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        JdbcStatement stmt = new JdbcStatement(this, resSetHoldability, this.schema);
        if (this.qryTimeout != null) {
            stmt.setQueryTimeout(this.qryTimeout);
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        if (sql == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        JdbcPreparedStatement stmt = new JdbcPreparedStatement(this, sql, resSetHoldability, this.schema);
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        Objects.requireNonNull(sql);
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (autoCommit != this.autoCommit) {
            if (autoCommit) {
                this.finishTx(true);
            }
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be committed explicitly in auto-commit mode.");
        }
        this.finishTx(true);
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be rolled back explicitly in auto-commit mode.");
        }
        this.finishTx(false);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Invalid savepoint.");
        }
        if (this.autoCommit) {
            throw new SQLException("Auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    private void finishTx(boolean commit) throws SQLException {
        try {
            JdbcFinishTxResult res = this.handler().finishTxAsync(this.connectionId, commit).get();
            if (res.status() != 0) {
                throw IgniteQueryErrorCode.createJdbcSqlException(res.err(), res.status());
            }
        }
        catch (CancellationException e) {
            throw new SQLException("Request to " + (commit ? "commit" : "rollback") + " the transaction has been canceled.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("The transaction " + (commit ? "commit" : "rollback") + " request failed.", e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        if (!this.autoCommit) {
            this.finishTx(false);
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.clear();
        }
        if (this.client == null) {
            return;
        }
        this.client.close();
    }

    public void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        if (this.metadata == null) {
            this.metadata = new JdbcDatabaseMetadata(this);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new SQLException("Invalid transaction isolation level.", "0700E");
            }
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 1 && holdability != 2) {
            throw new SQLException("Invalid result set holdability value.");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        if (name == null) {
            throw new SQLException("Savepoint name cannot be null.");
        }
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Savepoint cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        return !this.closed;
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureNotClosed();
        this.schema = JdbcConnection.normalizeSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureNotClosed();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor cannot be null.");
        }
        this.close();
    }

    @Override
    public final void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        this.ensureNotClosed();
        if (ms < 0) {
            throw new SQLException("Network timeout cannot be negative.");
        }
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null) {
            secMgr.checkPermission(new SQLPermission(SET_NETWORK_TIMEOUT_PERM));
        }
        this.netTimeout = ms;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.netTimeout;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.ensureNotClosed();
        Connection.super.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.ensureNotClosed();
        Connection.super.endRequest();
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException {
        this.ensureNotClosed();
        return Connection.super.setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException {
        this.ensureNotClosed();
        return Connection.super.setShardingKeyIfValid(shardingKey, timeout);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException {
        this.ensureNotClosed();
        Connection.super.setShardingKey(shardingKey, superShardingKey);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws SQLException {
        this.ensureNotClosed();
        Connection.super.setShardingKey(shardingKey);
    }

    public JdbcQueryEventHandler handler() {
        return this.handler;
    }

    long connectionId() {
        return this.connectionId;
    }

    long observableTimestamp() {
        return this.client.channel().observableTimestamp().get().longValue();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStatement(JdbcStatement stmt) {
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.remove(stmt);
        }
    }

    private void checkCursorOptions(int resSetType, int resSetConcurrency) throws SQLFeatureNotSupportedException {
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported).");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
    }

    private String createStrAddress(HostAndPort range) {
        Object host = range.host();
        int port = range.port();
        boolean ipV6 = ((String)host).contains(":");
        if (ipV6) {
            host = "[" + (String)host + "]";
        }
        return (String)host + ":" + port;
    }

    public static String normalizeSchema(String schemaName) {
        if (schemaName == null || schemaName.isEmpty()) {
            return SqlCommon.DEFAULT_SCHEMA_NAME;
        }
        String res = schemaName.startsWith("\"") && schemaName.endsWith("\"") ? schemaName.substring(1, schemaName.length() - 1) : schemaName.toUpperCase();
        return res;
    }

    public ConnectionProperties connectionProperties() {
        return this.connProps;
    }

    public String url() {
        return this.connProps.getUrl();
    }

    long nextToken() {
        return this.tokenGenerator.getAndIncrement();
    }
}

