/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TimestampWithTimeZoneString;

public class SqlTimestampTzLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimestampTzLiteral(TimestampWithTimeZoneString ts, int precision, SqlParserPos pos) {
        super(ts, false, SqlTypeName.TIMESTAMP_TZ, precision, pos);
        Preconditions.checkArgument((this.precision >= 0 ? 1 : 0) != 0);
    }

    @Override
    public SqlTimestampTzLiteral clone(SqlParserPos pos) {
        return new SqlTimestampTzLiteral(this.getTimestampTz(), this.precision, pos);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getTypeName()) + " '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        TimestampWithTimeZoneString ts = this.getTimestampTz();
        if (this.precision > 0) {
            ts = ts.round(this.precision);
        }
        return ts.toString(this.precision);
    }

    TimestampWithTimeZoneString getTimestampTz() {
        return (TimestampWithTimeZoneString)Objects.requireNonNull(this.value, "value");
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseDateTimeLiteral(writer, this, leftPrec, rightPrec);
    }
}

