/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.ignite.internal.jdbc2.JdbcBinaryBuffer;

public class JdbcBlob
implements Blob {
    private JdbcBinaryBuffer buf;

    public JdbcBlob() {
        this.buf = JdbcBinaryBuffer.createReadWrite();
    }

    public JdbcBlob(JdbcBinaryBuffer buf) {
        this.buf = buf;
    }

    public JdbcBlob(byte[] arr) {
        this(JdbcBinaryBuffer.createReadWrite(arr));
    }

    @Override
    public long length() throws SQLException {
        this.ensureNotClosed();
        return this.buf.length();
    }

    @Override
    public byte[] getBytes(long pos, int len) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L || (long)this.buf.length() - pos < 0L && this.buf.length() > 0 || len < 0) {
            throw new SQLException("Invalid argument. Position can't be less than 1 or greater than Blob length. Requested length also can't be negative [pos=" + pos + ", len=" + len + ", blobLen=" + this.buf.length() + "]");
        }
        int idx = (int)(pos - 1L);
        int size = Math.min(len, this.buf.length() - idx);
        byte[] res = new byte[size];
        if (size == 0) {
            return res;
        }
        this.buf.read(idx, res, 0, size);
        return res;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.ensureNotClosed();
        return this.buf.inputStream();
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L || len < 1L || pos > (long)this.buf.length() || len > (long)this.buf.length() - pos + 1L) {
            throw new SQLException("Invalid argument. Position can't be less than 1 or greater than Blob length. Requested length can't be negative and can't be greater than available bytes from given position [pos=" + pos + ", len=" + len + ", blobLen=" + this.buf.length() + "]");
        }
        return this.buf.inputStream((int)pos - 1, (int)len);
    }

    @Override
    public long position(byte[] ptrn, long start) throws SQLException {
        this.ensureNotClosed();
        if (start < 1L) {
            throw new SQLException("Invalid argument. Start position can't be less than 1 [start=" + start + "]");
        }
        if (start > (long)this.buf.length() || ptrn.length == 0 || ptrn.length > this.buf.length()) {
            return -1L;
        }
        return this.position(new ByteArrayInputStream(ptrn), ptrn.length, (int)start);
    }

    @Override
    public long position(Blob ptrn, long start) throws SQLException {
        this.ensureNotClosed();
        if (start < 1L) {
            throw new SQLException("Invalid argument. Start position can't be less than 1 [start=" + start + "]");
        }
        if (start > (long)this.buf.length() || ptrn.length() == 0L || ptrn.length() > (long)this.buf.length()) {
            return -1L;
        }
        return this.position(ptrn.getBinaryStream(), (int)ptrn.length(), (int)start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int off, int len) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L || pos - 1L > (long)this.buf.length()) {
            throw new SQLException("Invalid argument. Position can't be less than 1 or greater than Blob length + 1 [pos=" + pos + ", blobLen=" + this.buf.length() + "]");
        }
        try {
            this.buf.write((int)pos - 1, bytes, off, len);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L || pos - 1L > (long)this.buf.length()) {
            throw new SQLException("Invalid argument. Position can't be less than 1 or greater than Blob length + 1 [pos=" + pos + ", blobLen=" + this.buf.length() + "]");
        }
        return this.buf.outputStream((int)pos - 1);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.ensureNotClosed();
        if (len < 0L || len > (long)this.buf.length()) {
            throw new SQLException("Invalid argument. Length can't be less than zero or greater than Blob length [len=" + len + ", blobLen=" + this.buf.length() + "]");
        }
        this.buf.truncate((int)len);
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long position(InputStream ptrn, int ptrnLen, int idx) throws SQLException {
        try (InputStream blob = this.buf.inputStream(idx - 1, this.buf.length() - idx + 1);){
            int b;
            boolean patternStarted = false;
            int ptrnPos = 0;
            int blobPos = idx - 1;
            while ((b = blob.read()) != -1) {
                if (b == ptrn.read()) {
                    if (!patternStarted) {
                        patternStarted = true;
                        blob.mark(Integer.MAX_VALUE);
                    }
                    ++blobPos;
                    if (++ptrnPos != ptrnLen) continue;
                    long l = blobPos - ptrnLen + 1;
                    return l;
                }
                blobPos = blobPos - ptrnPos + 1;
                ptrnPos = 0;
                ptrn.reset();
                if (!patternStarted) continue;
                patternStarted = false;
                blob.reset();
            }
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void ensureNotClosed() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("Blob instance can't be used after free() has been called.");
        }
    }
}

